/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BehqueuedataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjectsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeysFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.batch.DefaultBusinessEventQueueServiceBatch;

/**
 * <p>
 *
 * The service reads business events from a queue for a given subscriber. The business event contains the type and the
 * key of the object triggering the event and the action. There are appropriate checks for restricted values and
 * authorizations. The system displays a failure message in the response if the entry is invalid..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/c73813685a44ddaadb2fbdd86e92a5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/C_BEHQUEUEDATA_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>C_BEHQUEUEDATA_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>OpenText Business Event Integration(SAP_COM_0007), Business Event Handling Integration
 * (Obsolete)(SAP_COM_0121)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NN'>Business Event Handling(1NN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessEventQueueService" )
@Deprecated
public class DefaultBusinessEventQueueService implements BusinessEventQueueService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessEventQueueService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessEventQueueService()
    {
        servicePath = BusinessEventQueueService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessEventQueueService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessEventQueueService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessEventQueueService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessEventQueueServiceBatch batch()
    {
        return new DefaultBusinessEventQueueServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BehqueuedataFluentHelper getAllBehqueuedata()
    {
        return new BehqueuedataFluentHelper(servicePath, "C_Behqueuedata");
    }

    @Override
    @Nonnull
    public BehqueuedataByKeyFluentHelper getBehqueuedataByKey( final UUID businessEvent )
    {
        return new BehqueuedataByKeyFluentHelper(servicePath, "C_Behqueuedata", businessEvent);
    }

    @Override
    @Nonnull
    public BusinessObjectKeysFluentHelper getAllBusinessObjectKeys()
    {
        return new BusinessObjectKeysFluentHelper(servicePath, "I_BusinessObjectKeys");
    }

    @Override
    @Nonnull
    public BusinessObjectKeysByKeyFluentHelper getBusinessObjectKeysByKey( final String sAPObjectType )
    {
        return new BusinessObjectKeysByKeyFluentHelper(servicePath, "I_BusinessObjectKeys", sAPObjectType);
    }

    @Override
    @Nonnull
    public BusObjectsFluentHelper getAllBusObjects()
    {
        return new BusObjectsFluentHelper(servicePath, "I_BusObjects");
    }

    @Override
    @Nonnull
    public BusObjectsByKeyFluentHelper getBusObjectsByKey(
        final String sAPObjectType,
        final String sAPObjectTypeName,
        final String sAPObjectTaskCode,
        final String sAPObjectTaskTypeName )
    {
        return new BusObjectsByKeyFluentHelper(
            servicePath,
            "I_BusObjects",
            sAPObjectType,
            sAPObjectTypeName,
            sAPObjectTaskCode,
            sAPObjectTaskTypeName);
    }

}
