/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintainUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionReadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.batch.DefaultBusinessEventSubscriptionServiceBatch;

/**
 * <p>
 *
 * This service enables the caller to create a subscription for business events for a given subscriber. A subscription
 * is required to activate the events so they are delivered to the event queue where they can be read. The information
 * sent in the request as a payload is used to maintain a business events subscription, make the appropriate checks for
 * restricted values and authorizations. Once an event subscription is maintained, the system displays a success or
 * failure message in the response.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/31/ca00d025e14973a1d9cd727cc09419/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CA_BEH_SUBSCRIPTION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CA_BEH_SUBSCRIPTION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>OpenText Business Event Integration(SAP_COM_0007), Business Event Handling Integration
 * (Obsolete)(SAP_COM_0121)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NN'>Business Event Handling(1NN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessEventSubscriptionService" )
@Deprecated
public class DefaultBusinessEventSubscriptionService implements BusinessEventSubscriptionService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessEventSubscriptionService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessEventSubscriptionService()
    {
        servicePath = BusinessEventSubscriptionService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessEventSubscriptionService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessEventSubscriptionService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessEventSubscriptionService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessEventSubscriptionServiceBatch batch()
    {
        return new DefaultBusinessEventSubscriptionServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SubscriptionMaintainFluentHelper getAllSubscriptionMaintain()
    {
        return new SubscriptionMaintainFluentHelper(servicePath, "SubscriptionMaintain");
    }

    @Override
    @Nonnull
    public SubscriptionMaintainByKeyFluentHelper getSubscriptionMaintainByKey(
        final String busEventSubscriberCode,
        final String sAPObjectType,
        final String sAPObjectTaskCode )
    {
        return new SubscriptionMaintainByKeyFluentHelper(
            servicePath,
            "SubscriptionMaintain",
            busEventSubscriberCode,
            sAPObjectType,
            sAPObjectTaskCode);
    }

    @Override
    @Nonnull
    public SubscriptionMaintainCreateFluentHelper createSubscriptionMaintain(
        @Nonnull final SubscriptionMaintain subscriptionMaintain )
    {
        return new SubscriptionMaintainCreateFluentHelper(servicePath, subscriptionMaintain, "SubscriptionMaintain");
    }

    @Override
    @Nonnull
    public SubscriptionMaintainUpdateFluentHelper updateSubscriptionMaintain(
        @Nonnull final SubscriptionMaintain subscriptionMaintain )
    {
        return new SubscriptionMaintainUpdateFluentHelper(servicePath, subscriptionMaintain, "SubscriptionMaintain");
    }

    @Override
    @Nonnull
    public SubscriptionReadFluentHelper getAllSubscriptionRead()
    {
        return new SubscriptionReadFluentHelper(servicePath, "SubscriptionRead");
    }

    @Override
    @Nonnull
    public SubscriptionReadByKeyFluentHelper getSubscriptionReadByKey(
        final String busEventSubscriberCode,
        final String sAPObjectType,
        final String sAPObjectTaskCode )
    {
        return new SubscriptionReadByKeyFluentHelper(
            servicePath,
            "SubscriptionRead",
            busEventSubscriberCode,
            sAPObjectType,
            sAPObjectTaskCode);
    }

}
