/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURLUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDeptUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthinessUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReportingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentificationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBankUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRatingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRoleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGroupingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPointUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFuncUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.batch.DefaultBusinessPartnerServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, display, update, and delete data related to Business Partner, Supplier, and
 * Customer with the data provided in a payload, in an API call. This service also supports create deep entity operation
 * and batch processing..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/85/043858ea0f9244e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUSINESS_PARTNER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUSINESS_PARTNER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Partner, Customer and Supplier Integration(SAP_COM_0008), SAP Analytics Cloud for Planning
 * Integration(SAP_COM_0087), SAP Real Estate Contract API Integration(SAP_COM_0393), Excise Tax
 * Integration(SAP_COM_0568), Delivery Insights Replication App Integration (Obsolete)(SAP_COM_0571), Procurement -
 * Supplier Quotation Management Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration(1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4N6'>SAP Central Invoice Management Backend Enablement(4N6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1T6'>Lease-In Accounting(1T6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21Q'>Lease-Out Accounting(21Q)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21R'>Service Contract(21R)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O1Q'>Lease-Out Accounting(O1Q)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O1R'>Service Contract(O1R)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OT6'>Lease-In Accounting(OT6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X3'>Integration of SAP S/4HANA and SAP Cloud for Real
 * Estate(4X3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax
 * Management(4LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights Enabled by IoT(4IH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Partner</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessPartnerService" )
@Deprecated
public class DefaultBusinessPartnerService implements BusinessPartnerService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessPartnerService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessPartnerService()
    {
        servicePath = BusinessPartnerService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessPartnerService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessPartnerService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessPartnerService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessPartnerServiceBatch batch()
    {
        return new DefaultBusinessPartnerServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public AddressEmailAddressFluentHelper getAllAddressEmailAddress()
    {
        return new AddressEmailAddressFluentHelper(servicePath, "A_AddressEmailAddress");
    }

    @Override
    @Nonnull
    public
        AddressEmailAddressByKeyFluentHelper
        getAddressEmailAddressByKey( final String addressID, final String person, final String ordinalNumber )
    {
        return new AddressEmailAddressByKeyFluentHelper(
            servicePath,
            "A_AddressEmailAddress",
            addressID,
            person,
            ordinalNumber);
    }

    @Override
    @Nonnull
    public AddressEmailAddressCreateFluentHelper createAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return new AddressEmailAddressCreateFluentHelper(servicePath, addressEmailAddress, "A_AddressEmailAddress");
    }

    @Override
    @Nonnull
    public AddressEmailAddressUpdateFluentHelper updateAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return new AddressEmailAddressUpdateFluentHelper(servicePath, addressEmailAddress, "A_AddressEmailAddress");
    }

    @Override
    @Nonnull
    public AddressEmailAddressDeleteFluentHelper deleteAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return new AddressEmailAddressDeleteFluentHelper(servicePath, addressEmailAddress, "A_AddressEmailAddress");
    }

    @Override
    @Nonnull
    public AddressFaxNumberFluentHelper getAllAddressFaxNumber()
    {
        return new AddressFaxNumberFluentHelper(servicePath, "A_AddressFaxNumber");
    }

    @Override
    @Nonnull
    public
        AddressFaxNumberByKeyFluentHelper
        getAddressFaxNumberByKey( final String addressID, final String person, final String ordinalNumber )
    {
        return new AddressFaxNumberByKeyFluentHelper(
            servicePath,
            "A_AddressFaxNumber",
            addressID,
            person,
            ordinalNumber);
    }

    @Override
    @Nonnull
    public AddressFaxNumberCreateFluentHelper createAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return new AddressFaxNumberCreateFluentHelper(servicePath, addressFaxNumber, "A_AddressFaxNumber");
    }

    @Override
    @Nonnull
    public AddressFaxNumberUpdateFluentHelper updateAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return new AddressFaxNumberUpdateFluentHelper(servicePath, addressFaxNumber, "A_AddressFaxNumber");
    }

    @Override
    @Nonnull
    public AddressFaxNumberDeleteFluentHelper deleteAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return new AddressFaxNumberDeleteFluentHelper(servicePath, addressFaxNumber, "A_AddressFaxNumber");
    }

    @Override
    @Nonnull
    public AddressHomePageURLFluentHelper getAllAddressHomePageURL()
    {
        return new AddressHomePageURLFluentHelper(servicePath, "A_AddressHomePageURL");
    }

    @Override
    @Nonnull
    public AddressHomePageURLByKeyFluentHelper getAddressHomePageURLByKey(
        final String addressID,
        final String person,
        final String ordinalNumber,
        final LocalDateTime validityStartDate,
        final Boolean isDefaultURLAddress )
    {
        return new AddressHomePageURLByKeyFluentHelper(
            servicePath,
            "A_AddressHomePageURL",
            addressID,
            person,
            ordinalNumber,
            validityStartDate,
            isDefaultURLAddress);
    }

    @Override
    @Nonnull
    public AddressHomePageURLCreateFluentHelper createAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return new AddressHomePageURLCreateFluentHelper(servicePath, addressHomePageURL, "A_AddressHomePageURL");
    }

    @Override
    @Nonnull
    public AddressHomePageURLUpdateFluentHelper updateAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return new AddressHomePageURLUpdateFluentHelper(servicePath, addressHomePageURL, "A_AddressHomePageURL");
    }

    @Override
    @Nonnull
    public AddressHomePageURLDeleteFluentHelper deleteAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return new AddressHomePageURLDeleteFluentHelper(servicePath, addressHomePageURL, "A_AddressHomePageURL");
    }

    @Override
    @Nonnull
    public AddressPhoneNumberFluentHelper getAllAddressPhoneNumber()
    {
        return new AddressPhoneNumberFluentHelper(servicePath, "A_AddressPhoneNumber");
    }

    @Override
    @Nonnull
    public
        AddressPhoneNumberByKeyFluentHelper
        getAddressPhoneNumberByKey( final String addressID, final String person, final String ordinalNumber )
    {
        return new AddressPhoneNumberByKeyFluentHelper(
            servicePath,
            "A_AddressPhoneNumber",
            addressID,
            person,
            ordinalNumber);
    }

    @Override
    @Nonnull
    public AddressPhoneNumberCreateFluentHelper createAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return new AddressPhoneNumberCreateFluentHelper(servicePath, addressPhoneNumber, "A_AddressPhoneNumber");
    }

    @Override
    @Nonnull
    public AddressPhoneNumberUpdateFluentHelper updateAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return new AddressPhoneNumberUpdateFluentHelper(servicePath, addressPhoneNumber, "A_AddressPhoneNumber");
    }

    @Override
    @Nonnull
    public AddressPhoneNumberDeleteFluentHelper deleteAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return new AddressPhoneNumberDeleteFluentHelper(servicePath, addressPhoneNumber, "A_AddressPhoneNumber");
    }

    @Override
    @Nonnull
    public BPAddrDepdntIntlLocNumberFluentHelper getAllBPAddrDepdntIntlLocNumber()
    {
        return new BPAddrDepdntIntlLocNumberFluentHelper(servicePath, "A_BPAddrDepdntIntlLocNumber");
    }

    @Override
    @Nonnull
    public
        BPAddrDepdntIntlLocNumberByKeyFluentHelper
        getBPAddrDepdntIntlLocNumberByKey( final String businessPartner, final String addressID )
    {
        return new BPAddrDepdntIntlLocNumberByKeyFluentHelper(
            servicePath,
            "A_BPAddrDepdntIntlLocNumber",
            businessPartner,
            addressID);
    }

    @Override
    @Nonnull
    public BPAddrDepdntIntlLocNumberCreateFluentHelper createBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return new BPAddrDepdntIntlLocNumberCreateFluentHelper(
            servicePath,
            bPAddrDepdntIntlLocNumber,
            "A_BPAddrDepdntIntlLocNumber");
    }

    @Override
    @Nonnull
    public BPAddrDepdntIntlLocNumberUpdateFluentHelper updateBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return new BPAddrDepdntIntlLocNumberUpdateFluentHelper(
            servicePath,
            bPAddrDepdntIntlLocNumber,
            "A_BPAddrDepdntIntlLocNumber");
    }

    @Override
    @Nonnull
    public BPAddrDepdntIntlLocNumberDeleteFluentHelper deleteBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return new BPAddrDepdntIntlLocNumberDeleteFluentHelper(
            servicePath,
            bPAddrDepdntIntlLocNumber,
            "A_BPAddrDepdntIntlLocNumber");
    }

    @Override
    @Nonnull
    public BPContactToAddressFluentHelper getAllBPContactToAddress()
    {
        return new BPContactToAddressFluentHelper(servicePath, "A_BPContactToAddress");
    }

    @Override
    @Nonnull
    public BPContactToAddressByKeyFluentHelper getBPContactToAddressByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate,
        final String addressID )
    {
        return new BPContactToAddressByKeyFluentHelper(
            servicePath,
            "A_BPContactToAddress",
            relationshipNumber,
            businessPartnerCompany,
            businessPartnerPerson,
            validityEndDate,
            addressID);
    }

    @Override
    @Nonnull
    public BPContactToAddressCreateFluentHelper createBPContactToAddress(
        @Nonnull final BPContactToAddress bPContactToAddress )
    {
        return new BPContactToAddressCreateFluentHelper(servicePath, bPContactToAddress, "A_BPContactToAddress");
    }

    @Override
    @Nonnull
    public BPContactToFuncAndDeptFluentHelper getAllBPContactToFuncAndDept()
    {
        return new BPContactToFuncAndDeptFluentHelper(servicePath, "A_BPContactToFuncAndDept");
    }

    @Override
    @Nonnull
    public BPContactToFuncAndDeptByKeyFluentHelper getBPContactToFuncAndDeptByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate )
    {
        return new BPContactToFuncAndDeptByKeyFluentHelper(
            servicePath,
            "A_BPContactToFuncAndDept",
            relationshipNumber,
            businessPartnerCompany,
            businessPartnerPerson,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BPContactToFuncAndDeptUpdateFluentHelper updateBPContactToFuncAndDept(
        @Nonnull final BPContactToFuncAndDept bPContactToFuncAndDept )
    {
        return new BPContactToFuncAndDeptUpdateFluentHelper(
            servicePath,
            bPContactToFuncAndDept,
            "A_BPContactToFuncAndDept");
    }

    @Override
    @Nonnull
    public BPCreditWorthinessFluentHelper getAllBPCreditWorthiness()
    {
        return new BPCreditWorthinessFluentHelper(servicePath, "A_BPCreditWorthiness");
    }

    @Override
    @Nonnull
    public BPCreditWorthinessByKeyFluentHelper getBPCreditWorthinessByKey( final String businessPartner )
    {
        return new BPCreditWorthinessByKeyFluentHelper(servicePath, "A_BPCreditWorthiness", businessPartner);
    }

    @Override
    @Nonnull
    public BPCreditWorthinessCreateFluentHelper createBPCreditWorthiness(
        @Nonnull final BPCreditWorthiness bPCreditWorthiness )
    {
        return new BPCreditWorthinessCreateFluentHelper(servicePath, bPCreditWorthiness, "A_BPCreditWorthiness");
    }

    @Override
    @Nonnull
    public BPCreditWorthinessUpdateFluentHelper updateBPCreditWorthiness(
        @Nonnull final BPCreditWorthiness bPCreditWorthiness )
    {
        return new BPCreditWorthinessUpdateFluentHelper(servicePath, bPCreditWorthiness, "A_BPCreditWorthiness");
    }

    @Override
    @Nonnull
    public BPFinancialServicesExtnFluentHelper getAllBPFinancialServicesExtn()
    {
        return new BPFinancialServicesExtnFluentHelper(servicePath, "A_BPFinancialServicesExtn");
    }

    @Override
    @Nonnull
    public BPFinancialServicesExtnByKeyFluentHelper getBPFinancialServicesExtnByKey( final String businessPartner )
    {
        return new BPFinancialServicesExtnByKeyFluentHelper(servicePath, "A_BPFinancialServicesExtn", businessPartner);
    }

    @Override
    @Nonnull
    public BPFinancialServicesExtnCreateFluentHelper createBPFinancialServicesExtn(
        @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn )
    {
        return new BPFinancialServicesExtnCreateFluentHelper(
            servicePath,
            bPFinancialServicesExtn,
            "A_BPFinancialServicesExtn");
    }

    @Override
    @Nonnull
    public BPFinancialServicesExtnUpdateFluentHelper updateBPFinancialServicesExtn(
        @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn )
    {
        return new BPFinancialServicesExtnUpdateFluentHelper(
            servicePath,
            bPFinancialServicesExtn,
            "A_BPFinancialServicesExtn");
    }

    @Override
    @Nonnull
    public BPFinancialServicesReportingFluentHelper getAllBPFinancialServicesReporting()
    {
        return new BPFinancialServicesReportingFluentHelper(servicePath, "A_BPFinancialServicesReporting");
    }

    @Override
    @Nonnull
    public BPFinancialServicesReportingByKeyFluentHelper getBPFinancialServicesReportingByKey(
        final String businessPartner )
    {
        return new BPFinancialServicesReportingByKeyFluentHelper(
            servicePath,
            "A_BPFinancialServicesReporting",
            businessPartner);
    }

    @Override
    @Nonnull
    public BPFinancialServicesReportingCreateFluentHelper createBPFinancialServicesReporting(
        @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting )
    {
        return new BPFinancialServicesReportingCreateFluentHelper(
            servicePath,
            bPFinancialServicesReporting,
            "A_BPFinancialServicesReporting");
    }

    @Override
    @Nonnull
    public BPFinancialServicesReportingUpdateFluentHelper updateBPFinancialServicesReporting(
        @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting )
    {
        return new BPFinancialServicesReportingUpdateFluentHelper(
            servicePath,
            bPFinancialServicesReporting,
            "A_BPFinancialServicesReporting");
    }

    @Override
    @Nonnull
    public BPFiscalYearInformationFluentHelper getAllBPFiscalYearInformation()
    {
        return new BPFiscalYearInformationFluentHelper(servicePath, "A_BPFiscalYearInformation");
    }

    @Override
    @Nonnull
    public
        BPFiscalYearInformationByKeyFluentHelper
        getBPFiscalYearInformationByKey( final String businessPartner, final String businessPartnerFiscalYear )
    {
        return new BPFiscalYearInformationByKeyFluentHelper(
            servicePath,
            "A_BPFiscalYearInformation",
            businessPartner,
            businessPartnerFiscalYear);
    }

    @Override
    @Nonnull
    public BPFiscalYearInformationCreateFluentHelper createBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return new BPFiscalYearInformationCreateFluentHelper(
            servicePath,
            bPFiscalYearInformation,
            "A_BPFiscalYearInformation");
    }

    @Override
    @Nonnull
    public BPFiscalYearInformationUpdateFluentHelper updateBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return new BPFiscalYearInformationUpdateFluentHelper(
            servicePath,
            bPFiscalYearInformation,
            "A_BPFiscalYearInformation");
    }

    @Override
    @Nonnull
    public BPFiscalYearInformationDeleteFluentHelper deleteBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return new BPFiscalYearInformationDeleteFluentHelper(
            servicePath,
            bPFiscalYearInformation,
            "A_BPFiscalYearInformation");
    }

    @Override
    @Nonnull
    public BPRelationshipFluentHelper getAllBPRelationship()
    {
        return new BPRelationshipFluentHelper(servicePath, "A_BPRelationship");
    }

    @Override
    @Nonnull
    public BPRelationshipByKeyFluentHelper getBPRelationshipByKey(
        final String relationshipNumber,
        final String businessPartner1,
        final String businessPartner2,
        final LocalDateTime validityEndDate )
    {
        return new BPRelationshipByKeyFluentHelper(
            servicePath,
            "A_BPRelationship",
            relationshipNumber,
            businessPartner1,
            businessPartner2,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BPRelationshipCreateFluentHelper createBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return new BPRelationshipCreateFluentHelper(servicePath, bPRelationship, "A_BPRelationship");
    }

    @Override
    @Nonnull
    public BPRelationshipUpdateFluentHelper updateBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return new BPRelationshipUpdateFluentHelper(servicePath, bPRelationship, "A_BPRelationship");
    }

    @Override
    @Nonnull
    public BPRelationshipDeleteFluentHelper deleteBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return new BPRelationshipDeleteFluentHelper(servicePath, bPRelationship, "A_BPRelationship");
    }

    @Override
    @Nonnull
    public BuPaAddressUsageFluentHelper getAllBuPaAddressUsage()
    {
        return new BuPaAddressUsageFluentHelper(servicePath, "A_BuPaAddressUsage");
    }

    @Override
    @Nonnull
    public BuPaAddressUsageByKeyFluentHelper getBuPaAddressUsageByKey(
        final String businessPartner,
        final ZonedDateTime validityEndDate,
        final String addressUsage,
        final String addressID )
    {
        return new BuPaAddressUsageByKeyFluentHelper(
            servicePath,
            "A_BuPaAddressUsage",
            businessPartner,
            validityEndDate,
            addressUsage,
            addressID);
    }

    @Override
    @Nonnull
    public BuPaAddressUsageCreateFluentHelper createBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return new BuPaAddressUsageCreateFluentHelper(servicePath, buPaAddressUsage, "A_BuPaAddressUsage");
    }

    @Override
    @Nonnull
    public BuPaAddressUsageUpdateFluentHelper updateBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return new BuPaAddressUsageUpdateFluentHelper(servicePath, buPaAddressUsage, "A_BuPaAddressUsage");
    }

    @Override
    @Nonnull
    public BuPaAddressUsageDeleteFluentHelper deleteBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return new BuPaAddressUsageDeleteFluentHelper(servicePath, buPaAddressUsage, "A_BuPaAddressUsage");
    }

    @Override
    @Nonnull
    public BuPaIdentificationFluentHelper getAllBuPaIdentification()
    {
        return new BuPaIdentificationFluentHelper(servicePath, "A_BuPaIdentification");
    }

    @Override
    @Nonnull
    public BuPaIdentificationByKeyFluentHelper getBuPaIdentificationByKey(
        final String businessPartner,
        final String bPIdentificationType,
        final String bPIdentificationNumber )
    {
        return new BuPaIdentificationByKeyFluentHelper(
            servicePath,
            "A_BuPaIdentification",
            businessPartner,
            bPIdentificationType,
            bPIdentificationNumber);
    }

    @Override
    @Nonnull
    public BuPaIdentificationCreateFluentHelper createBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return new BuPaIdentificationCreateFluentHelper(servicePath, buPaIdentification, "A_BuPaIdentification");
    }

    @Override
    @Nonnull
    public BuPaIdentificationUpdateFluentHelper updateBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return new BuPaIdentificationUpdateFluentHelper(servicePath, buPaIdentification, "A_BuPaIdentification");
    }

    @Override
    @Nonnull
    public BuPaIdentificationDeleteFluentHelper deleteBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return new BuPaIdentificationDeleteFluentHelper(servicePath, buPaIdentification, "A_BuPaIdentification");
    }

    @Override
    @Nonnull
    public BuPaIndustryFluentHelper getAllBuPaIndustry()
    {
        return new BuPaIndustryFluentHelper(servicePath, "A_BuPaIndustry");
    }

    @Override
    @Nonnull
    public BuPaIndustryByKeyFluentHelper getBuPaIndustryByKey(
        final String industrySector,
        final String industrySystemType,
        final String businessPartner )
    {
        return new BuPaIndustryByKeyFluentHelper(
            servicePath,
            "A_BuPaIndustry",
            industrySector,
            industrySystemType,
            businessPartner);
    }

    @Override
    @Nonnull
    public BuPaIndustryCreateFluentHelper createBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return new BuPaIndustryCreateFluentHelper(servicePath, buPaIndustry, "A_BuPaIndustry");
    }

    @Override
    @Nonnull
    public BuPaIndustryUpdateFluentHelper updateBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return new BuPaIndustryUpdateFluentHelper(servicePath, buPaIndustry, "A_BuPaIndustry");
    }

    @Override
    @Nonnull
    public BuPaIndustryDeleteFluentHelper deleteBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return new BuPaIndustryDeleteFluentHelper(servicePath, buPaIndustry, "A_BuPaIndustry");
    }

    @Override
    @Nonnull
    public BusinessPartnerFluentHelper getAllBusinessPartner()
    {
        return new BusinessPartnerFluentHelper(servicePath, "A_BusinessPartner");
    }

    @Override
    @Nonnull
    public BusinessPartnerByKeyFluentHelper getBusinessPartnerByKey( final String businessPartner )
    {
        return new BusinessPartnerByKeyFluentHelper(servicePath, "A_BusinessPartner", businessPartner);
    }

    @Override
    @Nonnull
    public BusinessPartnerCreateFluentHelper createBusinessPartner( @Nonnull final BusinessPartner businessPartner )
    {
        return new BusinessPartnerCreateFluentHelper(servicePath, businessPartner, "A_BusinessPartner");
    }

    @Override
    @Nonnull
    public BusinessPartnerUpdateFluentHelper updateBusinessPartner( @Nonnull final BusinessPartner businessPartner )
    {
        return new BusinessPartnerUpdateFluentHelper(servicePath, businessPartner, "A_BusinessPartner");
    }

    @Override
    @Nonnull
    public BusinessPartnerAddressFluentHelper getAllBusinessPartnerAddress()
    {
        return new BusinessPartnerAddressFluentHelper(servicePath, "A_BusinessPartnerAddress");
    }

    @Override
    @Nonnull
    public
        BusinessPartnerAddressByKeyFluentHelper
        getBusinessPartnerAddressByKey( final String businessPartner, final String addressID )
    {
        return new BusinessPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerAddress",
            businessPartner,
            addressID);
    }

    @Override
    @Nonnull
    public BusinessPartnerAddressCreateFluentHelper createBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return new BusinessPartnerAddressCreateFluentHelper(
            servicePath,
            businessPartnerAddress,
            "A_BusinessPartnerAddress");
    }

    @Override
    @Nonnull
    public BusinessPartnerAddressUpdateFluentHelper updateBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return new BusinessPartnerAddressUpdateFluentHelper(
            servicePath,
            businessPartnerAddress,
            "A_BusinessPartnerAddress");
    }

    @Override
    @Nonnull
    public BusinessPartnerAddressDeleteFluentHelper deleteBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return new BusinessPartnerAddressDeleteFluentHelper(
            servicePath,
            businessPartnerAddress,
            "A_BusinessPartnerAddress");
    }

    @Override
    @Nonnull
    public BusinessPartnerBankFluentHelper getAllBusinessPartnerBank()
    {
        return new BusinessPartnerBankFluentHelper(servicePath, "A_BusinessPartnerBank");
    }

    @Override
    @Nonnull
    public
        BusinessPartnerBankByKeyFluentHelper
        getBusinessPartnerBankByKey( final String businessPartner, final String bankIdentification )
    {
        return new BusinessPartnerBankByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerBank",
            businessPartner,
            bankIdentification);
    }

    @Override
    @Nonnull
    public BusinessPartnerBankCreateFluentHelper createBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return new BusinessPartnerBankCreateFluentHelper(servicePath, businessPartnerBank, "A_BusinessPartnerBank");
    }

    @Override
    @Nonnull
    public BusinessPartnerBankUpdateFluentHelper updateBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return new BusinessPartnerBankUpdateFluentHelper(servicePath, businessPartnerBank, "A_BusinessPartnerBank");
    }

    @Override
    @Nonnull
    public BusinessPartnerBankDeleteFluentHelper deleteBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return new BusinessPartnerBankDeleteFluentHelper(servicePath, businessPartnerBank, "A_BusinessPartnerBank");
    }

    @Override
    @Nonnull
    public BusinessPartnerContactFluentHelper getAllBusinessPartnerContact()
    {
        return new BusinessPartnerContactFluentHelper(servicePath, "A_BusinessPartnerContact");
    }

    @Override
    @Nonnull
    public BusinessPartnerContactByKeyFluentHelper getBusinessPartnerContactByKey(
        final String relationshipNumber,
        final String businessPartnerCompany,
        final String businessPartnerPerson,
        final LocalDateTime validityEndDate )
    {
        return new BusinessPartnerContactByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerContact",
            relationshipNumber,
            businessPartnerCompany,
            businessPartnerPerson,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BusinessPartnerContactCreateFluentHelper createBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return new BusinessPartnerContactCreateFluentHelper(
            servicePath,
            businessPartnerContact,
            "A_BusinessPartnerContact");
    }

    @Override
    @Nonnull
    public BusinessPartnerContactUpdateFluentHelper updateBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return new BusinessPartnerContactUpdateFluentHelper(
            servicePath,
            businessPartnerContact,
            "A_BusinessPartnerContact");
    }

    @Override
    @Nonnull
    public BusinessPartnerContactDeleteFluentHelper deleteBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return new BusinessPartnerContactDeleteFluentHelper(
            servicePath,
            businessPartnerContact,
            "A_BusinessPartnerContact");
    }

    @Override
    @Nonnull
    public BusinessPartnerRatingFluentHelper getAllBusinessPartnerRating()
    {
        return new BusinessPartnerRatingFluentHelper(servicePath, "A_BusinessPartnerRating");
    }

    @Override
    @Nonnull
    public BusinessPartnerRatingByKeyFluentHelper getBusinessPartnerRatingByKey(
        final String businessPartner,
        final String businessPartnerRatingProcedure,
        final LocalDateTime bPRatingValidityEndDate )
    {
        return new BusinessPartnerRatingByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerRating",
            businessPartner,
            businessPartnerRatingProcedure,
            bPRatingValidityEndDate);
    }

    @Override
    @Nonnull
    public BusinessPartnerRatingCreateFluentHelper createBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return new BusinessPartnerRatingCreateFluentHelper(
            servicePath,
            businessPartnerRating,
            "A_BusinessPartnerRating");
    }

    @Override
    @Nonnull
    public BusinessPartnerRatingUpdateFluentHelper updateBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return new BusinessPartnerRatingUpdateFluentHelper(
            servicePath,
            businessPartnerRating,
            "A_BusinessPartnerRating");
    }

    @Override
    @Nonnull
    public BusinessPartnerRatingDeleteFluentHelper deleteBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return new BusinessPartnerRatingDeleteFluentHelper(
            servicePath,
            businessPartnerRating,
            "A_BusinessPartnerRating");
    }

    @Override
    @Nonnull
    public BusinessPartnerRoleFluentHelper getAllBusinessPartnerRole()
    {
        return new BusinessPartnerRoleFluentHelper(servicePath, "A_BusinessPartnerRole");
    }

    @Override
    @Nonnull
    public
        BusinessPartnerRoleByKeyFluentHelper
        getBusinessPartnerRoleByKey( final String businessPartner, final String businessPartnerRole )
    {
        return new BusinessPartnerRoleByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerRole",
            businessPartner,
            businessPartnerRole);
    }

    @Override
    @Nonnull
    public BusinessPartnerRoleCreateFluentHelper createBusinessPartnerRole(
        @Nonnull final BusinessPartnerRole businessPartnerRole )
    {
        return new BusinessPartnerRoleCreateFluentHelper(servicePath, businessPartnerRole, "A_BusinessPartnerRole");
    }

    @Override
    @Nonnull
    public BusinessPartnerRoleUpdateFluentHelper updateBusinessPartnerRole(
        @Nonnull final BusinessPartnerRole businessPartnerRole )
    {
        return new BusinessPartnerRoleUpdateFluentHelper(servicePath, businessPartnerRole, "A_BusinessPartnerRole");
    }

    @Override
    @Nonnull
    public BusinessPartnerTaxNumberFluentHelper getAllBusinessPartnerTaxNumber()
    {
        return new BusinessPartnerTaxNumberFluentHelper(servicePath, "A_BusinessPartnerTaxNumber");
    }

    @Override
    @Nonnull
    public
        BusinessPartnerTaxNumberByKeyFluentHelper
        getBusinessPartnerTaxNumberByKey( final String businessPartner, final String bPTaxType )
    {
        return new BusinessPartnerTaxNumberByKeyFluentHelper(
            servicePath,
            "A_BusinessPartnerTaxNumber",
            businessPartner,
            bPTaxType);
    }

    @Override
    @Nonnull
    public BusinessPartnerTaxNumberCreateFluentHelper createBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return new BusinessPartnerTaxNumberCreateFluentHelper(
            servicePath,
            businessPartnerTaxNumber,
            "A_BusinessPartnerTaxNumber");
    }

    @Override
    @Nonnull
    public BusinessPartnerTaxNumberUpdateFluentHelper updateBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return new BusinessPartnerTaxNumberUpdateFluentHelper(
            servicePath,
            businessPartnerTaxNumber,
            "A_BusinessPartnerTaxNumber");
    }

    @Override
    @Nonnull
    public BusinessPartnerTaxNumberDeleteFluentHelper deleteBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return new BusinessPartnerTaxNumberDeleteFluentHelper(
            servicePath,
            businessPartnerTaxNumber,
            "A_BusinessPartnerTaxNumber");
    }

    @Override
    @Nonnull
    public BusPartAddrDepdntTaxNmbrFluentHelper getAllBusPartAddrDepdntTaxNmbr()
    {
        return new BusPartAddrDepdntTaxNmbrFluentHelper(servicePath, "A_BusPartAddrDepdntTaxNmbr");
    }

    @Override
    @Nonnull
    public
        BusPartAddrDepdntTaxNmbrByKeyFluentHelper
        getBusPartAddrDepdntTaxNmbrByKey( final String businessPartner, final String addressID, final String bPTaxType )
    {
        return new BusPartAddrDepdntTaxNmbrByKeyFluentHelper(
            servicePath,
            "A_BusPartAddrDepdntTaxNmbr",
            businessPartner,
            addressID,
            bPTaxType);
    }

    @Override
    @Nonnull
    public BusPartAddrDepdntTaxNmbrCreateFluentHelper createBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return new BusPartAddrDepdntTaxNmbrCreateFluentHelper(
            servicePath,
            busPartAddrDepdntTaxNmbr,
            "A_BusPartAddrDepdntTaxNmbr");
    }

    @Override
    @Nonnull
    public BusPartAddrDepdntTaxNmbrUpdateFluentHelper updateBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return new BusPartAddrDepdntTaxNmbrUpdateFluentHelper(
            servicePath,
            busPartAddrDepdntTaxNmbr,
            "A_BusPartAddrDepdntTaxNmbr");
    }

    @Override
    @Nonnull
    public BusPartAddrDepdntTaxNmbrDeleteFluentHelper deleteBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return new BusPartAddrDepdntTaxNmbrDeleteFluentHelper(
            servicePath,
            busPartAddrDepdntTaxNmbr,
            "A_BusPartAddrDepdntTaxNmbr");
    }

    @Override
    @Nonnull
    public CustAddrDepdntExtIdentifierFluentHelper getAllCustAddrDepdntExtIdentifier()
    {
        return new CustAddrDepdntExtIdentifierFluentHelper(servicePath, "A_CustAddrDepdntExtIdentifier");
    }

    @Override
    @Nonnull
    public
        CustAddrDepdntExtIdentifierByKeyFluentHelper
        getCustAddrDepdntExtIdentifierByKey( final String customer, final String addressID )
    {
        return new CustAddrDepdntExtIdentifierByKeyFluentHelper(
            servicePath,
            "A_CustAddrDepdntExtIdentifier",
            customer,
            addressID);
    }

    @Override
    @Nonnull
    public CustAddrDepdntExtIdentifierCreateFluentHelper createCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return new CustAddrDepdntExtIdentifierCreateFluentHelper(
            servicePath,
            custAddrDepdntExtIdentifier,
            "A_CustAddrDepdntExtIdentifier");
    }

    @Override
    @Nonnull
    public CustAddrDepdntExtIdentifierUpdateFluentHelper updateCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return new CustAddrDepdntExtIdentifierUpdateFluentHelper(
            servicePath,
            custAddrDepdntExtIdentifier,
            "A_CustAddrDepdntExtIdentifier");
    }

    @Override
    @Nonnull
    public CustAddrDepdntExtIdentifierDeleteFluentHelper deleteCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return new CustAddrDepdntExtIdentifierDeleteFluentHelper(
            servicePath,
            custAddrDepdntExtIdentifier,
            "A_CustAddrDepdntExtIdentifier");
    }

    @Override
    @Nonnull
    public CustAddrDepdntInformationFluentHelper getAllCustAddrDepdntInformation()
    {
        return new CustAddrDepdntInformationFluentHelper(servicePath, "A_CustAddrDepdntInformation");
    }

    @Override
    @Nonnull
    public
        CustAddrDepdntInformationByKeyFluentHelper
        getCustAddrDepdntInformationByKey( final String customer, final String addressID )
    {
        return new CustAddrDepdntInformationByKeyFluentHelper(
            servicePath,
            "A_CustAddrDepdntInformation",
            customer,
            addressID);
    }

    @Override
    @Nonnull
    public CustAddrDepdntInformationCreateFluentHelper createCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return new CustAddrDepdntInformationCreateFluentHelper(
            servicePath,
            custAddrDepdntInformation,
            "A_CustAddrDepdntInformation");
    }

    @Override
    @Nonnull
    public CustAddrDepdntInformationUpdateFluentHelper updateCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return new CustAddrDepdntInformationUpdateFluentHelper(
            servicePath,
            custAddrDepdntInformation,
            "A_CustAddrDepdntInformation");
    }

    @Override
    @Nonnull
    public CustAddrDepdntInformationDeleteFluentHelper deleteCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return new CustAddrDepdntInformationDeleteFluentHelper(
            servicePath,
            custAddrDepdntInformation,
            "A_CustAddrDepdntInformation");
    }

    @Override
    @Nonnull
    public CustomerFluentHelper getAllCustomer()
    {
        return new CustomerFluentHelper(servicePath, "A_Customer");
    }

    @Override
    @Nonnull
    public CustomerByKeyFluentHelper getCustomerByKey( final String customer )
    {
        return new CustomerByKeyFluentHelper(servicePath, "A_Customer", customer);
    }

    @Override
    @Nonnull
    public CustomerCreateFluentHelper createCustomer( @Nonnull final Customer customer )
    {
        return new CustomerCreateFluentHelper(servicePath, customer, "A_Customer");
    }

    @Override
    @Nonnull
    public CustomerUpdateFluentHelper updateCustomer( @Nonnull final Customer customer )
    {
        return new CustomerUpdateFluentHelper(servicePath, customer, "A_Customer");
    }

    @Override
    @Nonnull
    public CustomerCompanyFluentHelper getAllCustomerCompany()
    {
        return new CustomerCompanyFluentHelper(servicePath, "A_CustomerCompany");
    }

    @Override
    @Nonnull
    public CustomerCompanyByKeyFluentHelper getCustomerCompanyByKey( final String customer, final String companyCode )
    {
        return new CustomerCompanyByKeyFluentHelper(servicePath, "A_CustomerCompany", customer, companyCode);
    }

    @Override
    @Nonnull
    public CustomerCompanyCreateFluentHelper createCustomerCompany( @Nonnull final CustomerCompany customerCompany )
    {
        return new CustomerCompanyCreateFluentHelper(servicePath, customerCompany, "A_CustomerCompany");
    }

    @Override
    @Nonnull
    public CustomerCompanyUpdateFluentHelper updateCustomerCompany( @Nonnull final CustomerCompany customerCompany )
    {
        return new CustomerCompanyUpdateFluentHelper(servicePath, customerCompany, "A_CustomerCompany");
    }

    @Override
    @Nonnull
    public CustomerCompanyTextFluentHelper getAllCustomerCompanyText()
    {
        return new CustomerCompanyTextFluentHelper(servicePath, "A_CustomerCompanyText");
    }

    @Override
    @Nonnull
    public CustomerCompanyTextByKeyFluentHelper getCustomerCompanyTextByKey(
        final String customer,
        final String companyCode,
        final String language,
        final String longTextID )
    {
        return new CustomerCompanyTextByKeyFluentHelper(
            servicePath,
            "A_CustomerCompanyText",
            customer,
            companyCode,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustomerCompanyTextCreateFluentHelper createCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return new CustomerCompanyTextCreateFluentHelper(servicePath, customerCompanyText, "A_CustomerCompanyText");
    }

    @Override
    @Nonnull
    public CustomerCompanyTextUpdateFluentHelper updateCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return new CustomerCompanyTextUpdateFluentHelper(servicePath, customerCompanyText, "A_CustomerCompanyText");
    }

    @Override
    @Nonnull
    public CustomerCompanyTextDeleteFluentHelper deleteCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return new CustomerCompanyTextDeleteFluentHelper(servicePath, customerCompanyText, "A_CustomerCompanyText");
    }

    @Override
    @Nonnull
    public CustomerDunningFluentHelper getAllCustomerDunning()
    {
        return new CustomerDunningFluentHelper(servicePath, "A_CustomerDunning");
    }

    @Override
    @Nonnull
    public
        CustomerDunningByKeyFluentHelper
        getCustomerDunningByKey( final String customer, final String companyCode, final String dunningArea )
    {
        return new CustomerDunningByKeyFluentHelper(
            servicePath,
            "A_CustomerDunning",
            customer,
            companyCode,
            dunningArea);
    }

    @Override
    @Nonnull
    public CustomerDunningCreateFluentHelper createCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return new CustomerDunningCreateFluentHelper(servicePath, customerDunning, "A_CustomerDunning");
    }

    @Override
    @Nonnull
    public CustomerDunningUpdateFluentHelper updateCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return new CustomerDunningUpdateFluentHelper(servicePath, customerDunning, "A_CustomerDunning");
    }

    @Override
    @Nonnull
    public CustomerDunningDeleteFluentHelper deleteCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return new CustomerDunningDeleteFluentHelper(servicePath, customerDunning, "A_CustomerDunning");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaFluentHelper getAllCustomerSalesArea()
    {
        return new CustomerSalesAreaFluentHelper(servicePath, "A_CustomerSalesArea");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaByKeyFluentHelper getCustomerSalesAreaByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division )
    {
        return new CustomerSalesAreaByKeyFluentHelper(
            servicePath,
            "A_CustomerSalesArea",
            customer,
            salesOrganization,
            distributionChannel,
            division);
    }

    @Override
    @Nonnull
    public CustomerSalesAreaCreateFluentHelper createCustomerSalesArea(
        @Nonnull final CustomerSalesArea customerSalesArea )
    {
        return new CustomerSalesAreaCreateFluentHelper(servicePath, customerSalesArea, "A_CustomerSalesArea");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaUpdateFluentHelper updateCustomerSalesArea(
        @Nonnull final CustomerSalesArea customerSalesArea )
    {
        return new CustomerSalesAreaUpdateFluentHelper(servicePath, customerSalesArea, "A_CustomerSalesArea");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTaxFluentHelper getAllCustomerSalesAreaTax()
    {
        return new CustomerSalesAreaTaxFluentHelper(servicePath, "A_CustomerSalesAreaTax");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTaxByKeyFluentHelper getCustomerSalesAreaTaxByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String departureCountry,
        final String customerTaxCategory )
    {
        return new CustomerSalesAreaTaxByKeyFluentHelper(
            servicePath,
            "A_CustomerSalesAreaTax",
            customer,
            salesOrganization,
            distributionChannel,
            division,
            departureCountry,
            customerTaxCategory);
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTaxCreateFluentHelper createCustomerSalesAreaTax(
        @Nonnull final CustomerSalesAreaTax customerSalesAreaTax )
    {
        return new CustomerSalesAreaTaxCreateFluentHelper(servicePath, customerSalesAreaTax, "A_CustomerSalesAreaTax");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTaxUpdateFluentHelper updateCustomerSalesAreaTax(
        @Nonnull final CustomerSalesAreaTax customerSalesAreaTax )
    {
        return new CustomerSalesAreaTaxUpdateFluentHelper(servicePath, customerSalesAreaTax, "A_CustomerSalesAreaTax");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTextFluentHelper getAllCustomerSalesAreaText()
    {
        return new CustomerSalesAreaTextFluentHelper(servicePath, "A_CustomerSalesAreaText");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTextByKeyFluentHelper getCustomerSalesAreaTextByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String language,
        final String longTextID )
    {
        return new CustomerSalesAreaTextByKeyFluentHelper(
            servicePath,
            "A_CustomerSalesAreaText",
            customer,
            salesOrganization,
            distributionChannel,
            division,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTextCreateFluentHelper createCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return new CustomerSalesAreaTextCreateFluentHelper(
            servicePath,
            customerSalesAreaText,
            "A_CustomerSalesAreaText");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTextUpdateFluentHelper updateCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return new CustomerSalesAreaTextUpdateFluentHelper(
            servicePath,
            customerSalesAreaText,
            "A_CustomerSalesAreaText");
    }

    @Override
    @Nonnull
    public CustomerSalesAreaTextDeleteFluentHelper deleteCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return new CustomerSalesAreaTextDeleteFluentHelper(
            servicePath,
            customerSalesAreaText,
            "A_CustomerSalesAreaText");
    }

    @Override
    @Nonnull
    public CustomerTaxGroupingFluentHelper getAllCustomerTaxGrouping()
    {
        return new CustomerTaxGroupingFluentHelper(servicePath, "A_CustomerTaxGrouping");
    }

    @Override
    @Nonnull
    public
        CustomerTaxGroupingByKeyFluentHelper
        getCustomerTaxGroupingByKey( final String customer, final String customerTaxGroupingCode )
    {
        return new CustomerTaxGroupingByKeyFluentHelper(
            servicePath,
            "A_CustomerTaxGrouping",
            customer,
            customerTaxGroupingCode);
    }

    @Override
    @Nonnull
    public CustomerTaxGroupingUpdateFluentHelper updateCustomerTaxGrouping(
        @Nonnull final CustomerTaxGrouping customerTaxGrouping )
    {
        return new CustomerTaxGroupingUpdateFluentHelper(servicePath, customerTaxGrouping, "A_CustomerTaxGrouping");
    }

    @Override
    @Nonnull
    public CustomerTaxGroupingDeleteFluentHelper deleteCustomerTaxGrouping(
        @Nonnull final CustomerTaxGrouping customerTaxGrouping )
    {
        return new CustomerTaxGroupingDeleteFluentHelper(servicePath, customerTaxGrouping, "A_CustomerTaxGrouping");
    }

    @Override
    @Nonnull
    public CustomerTextFluentHelper getAllCustomerText()
    {
        return new CustomerTextFluentHelper(servicePath, "A_CustomerText");
    }

    @Override
    @Nonnull
    public
        CustomerTextByKeyFluentHelper
        getCustomerTextByKey( final String customer, final String language, final String longTextID )
    {
        return new CustomerTextByKeyFluentHelper(servicePath, "A_CustomerText", customer, language, longTextID);
    }

    @Override
    @Nonnull
    public CustomerTextCreateFluentHelper createCustomerText( @Nonnull final CustomerText customerText )
    {
        return new CustomerTextCreateFluentHelper(servicePath, customerText, "A_CustomerText");
    }

    @Override
    @Nonnull
    public CustomerTextUpdateFluentHelper updateCustomerText( @Nonnull final CustomerText customerText )
    {
        return new CustomerTextUpdateFluentHelper(servicePath, customerText, "A_CustomerText");
    }

    @Override
    @Nonnull
    public CustomerTextDeleteFluentHelper deleteCustomerText( @Nonnull final CustomerText customerText )
    {
        return new CustomerTextDeleteFluentHelper(servicePath, customerText, "A_CustomerText");
    }

    @Override
    @Nonnull
    public CustomerUnloadingPointFluentHelper getAllCustomerUnloadingPoint()
    {
        return new CustomerUnloadingPointFluentHelper(servicePath, "A_CustomerUnloadingPoint");
    }

    @Override
    @Nonnull
    public
        CustomerUnloadingPointByKeyFluentHelper
        getCustomerUnloadingPointByKey( final String customer, final String unloadingPointName )
    {
        return new CustomerUnloadingPointByKeyFluentHelper(
            servicePath,
            "A_CustomerUnloadingPoint",
            customer,
            unloadingPointName);
    }

    @Override
    @Nonnull
    public CustomerUnloadingPointCreateFluentHelper createCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return new CustomerUnloadingPointCreateFluentHelper(
            servicePath,
            customerUnloadingPoint,
            "A_CustomerUnloadingPoint");
    }

    @Override
    @Nonnull
    public CustomerUnloadingPointUpdateFluentHelper updateCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return new CustomerUnloadingPointUpdateFluentHelper(
            servicePath,
            customerUnloadingPoint,
            "A_CustomerUnloadingPoint");
    }

    @Override
    @Nonnull
    public CustomerUnloadingPointDeleteFluentHelper deleteCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return new CustomerUnloadingPointDeleteFluentHelper(
            servicePath,
            customerUnloadingPoint,
            "A_CustomerUnloadingPoint");
    }

    @Override
    @Nonnull
    public CustomerWithHoldingTaxFluentHelper getAllCustomerWithHoldingTax()
    {
        return new CustomerWithHoldingTaxFluentHelper(servicePath, "A_CustomerWithHoldingTax");
    }

    @Override
    @Nonnull
    public CustomerWithHoldingTaxByKeyFluentHelper getCustomerWithHoldingTaxByKey(
        final String customer,
        final String companyCode,
        final String withholdingTaxType )
    {
        return new CustomerWithHoldingTaxByKeyFluentHelper(
            servicePath,
            "A_CustomerWithHoldingTax",
            customer,
            companyCode,
            withholdingTaxType);
    }

    @Override
    @Nonnull
    public CustomerWithHoldingTaxCreateFluentHelper createCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return new CustomerWithHoldingTaxCreateFluentHelper(
            servicePath,
            customerWithHoldingTax,
            "A_CustomerWithHoldingTax");
    }

    @Override
    @Nonnull
    public CustomerWithHoldingTaxUpdateFluentHelper updateCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return new CustomerWithHoldingTaxUpdateFluentHelper(
            servicePath,
            customerWithHoldingTax,
            "A_CustomerWithHoldingTax");
    }

    @Override
    @Nonnull
    public CustomerWithHoldingTaxDeleteFluentHelper deleteCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return new CustomerWithHoldingTaxDeleteFluentHelper(
            servicePath,
            customerWithHoldingTax,
            "A_CustomerWithHoldingTax");
    }

    @Override
    @Nonnull
    public CustSalesPartnerFuncFluentHelper getAllCustSalesPartnerFunc()
    {
        return new CustSalesPartnerFuncFluentHelper(servicePath, "A_CustSalesPartnerFunc");
    }

    @Override
    @Nonnull
    public CustSalesPartnerFuncByKeyFluentHelper getCustSalesPartnerFuncByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String partnerCounter,
        final String partnerFunction )
    {
        return new CustSalesPartnerFuncByKeyFluentHelper(
            servicePath,
            "A_CustSalesPartnerFunc",
            customer,
            salesOrganization,
            distributionChannel,
            division,
            partnerCounter,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CustSalesPartnerFuncCreateFluentHelper createCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return new CustSalesPartnerFuncCreateFluentHelper(servicePath, custSalesPartnerFunc, "A_CustSalesPartnerFunc");
    }

    @Override
    @Nonnull
    public CustSalesPartnerFuncUpdateFluentHelper updateCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return new CustSalesPartnerFuncUpdateFluentHelper(servicePath, custSalesPartnerFunc, "A_CustSalesPartnerFunc");
    }

    @Override
    @Nonnull
    public CustSalesPartnerFuncDeleteFluentHelper deleteCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return new CustSalesPartnerFuncDeleteFluentHelper(servicePath, custSalesPartnerFunc, "A_CustSalesPartnerFunc");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntInfoFluentHelper getAllCustSlsAreaAddrDepdntInfo()
    {
        return new CustSlsAreaAddrDepdntInfoFluentHelper(servicePath, "A_CustSlsAreaAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntInfoByKeyFluentHelper getCustSlsAreaAddrDepdntInfoByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String addressID )
    {
        return new CustSlsAreaAddrDepdntInfoByKeyFluentHelper(
            servicePath,
            "A_CustSlsAreaAddrDepdntInfo",
            customer,
            salesOrganization,
            distributionChannel,
            division,
            addressID);
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntInfoCreateFluentHelper createCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return new CustSlsAreaAddrDepdntInfoCreateFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntInfo,
            "A_CustSlsAreaAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntInfoUpdateFluentHelper updateCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return new CustSlsAreaAddrDepdntInfoUpdateFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntInfo,
            "A_CustSlsAreaAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntInfoDeleteFluentHelper deleteCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return new CustSlsAreaAddrDepdntInfoDeleteFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntInfo,
            "A_CustSlsAreaAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntTaxInfoFluentHelper getAllCustSlsAreaAddrDepdntTaxInfo()
    {
        return new CustSlsAreaAddrDepdntTaxInfoFluentHelper(servicePath, "A_CustSlsAreaAddrDepdntTaxInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper getCustSlsAreaAddrDepdntTaxInfoByKey(
        final String customer,
        final String salesOrganization,
        final String distributionChannel,
        final String division,
        final String addressID,
        final String departureCountry,
        final String customerTaxCategory )
    {
        return new CustSlsAreaAddrDepdntTaxInfoByKeyFluentHelper(
            servicePath,
            "A_CustSlsAreaAddrDepdntTaxInfo",
            customer,
            salesOrganization,
            distributionChannel,
            division,
            addressID,
            departureCountry,
            customerTaxCategory);
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper createCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return new CustSlsAreaAddrDepdntTaxInfoCreateFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntTaxInfo,
            "A_CustSlsAreaAddrDepdntTaxInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper updateCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return new CustSlsAreaAddrDepdntTaxInfoUpdateFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntTaxInfo,
            "A_CustSlsAreaAddrDepdntTaxInfo");
    }

    @Override
    @Nonnull
    public CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper deleteCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return new CustSlsAreaAddrDepdntTaxInfoDeleteFluentHelper(
            servicePath,
            custSlsAreaAddrDepdntTaxInfo,
            "A_CustSlsAreaAddrDepdntTaxInfo");
    }

    @Override
    @Nonnull
    public CustUnldgPtAddrDepdntInfoFluentHelper getAllCustUnldgPtAddrDepdntInfo()
    {
        return new CustUnldgPtAddrDepdntInfoFluentHelper(servicePath, "A_CustUnldgPtAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustUnldgPtAddrDepdntInfoByKeyFluentHelper getCustUnldgPtAddrDepdntInfoByKey(
        final String customer,
        final String addressID,
        final String unloadingPointName )
    {
        return new CustUnldgPtAddrDepdntInfoByKeyFluentHelper(
            servicePath,
            "A_CustUnldgPtAddrDepdntInfo",
            customer,
            addressID,
            unloadingPointName);
    }

    @Override
    @Nonnull
    public CustUnldgPtAddrDepdntInfoCreateFluentHelper createCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return new CustUnldgPtAddrDepdntInfoCreateFluentHelper(
            servicePath,
            custUnldgPtAddrDepdntInfo,
            "A_CustUnldgPtAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustUnldgPtAddrDepdntInfoUpdateFluentHelper updateCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return new CustUnldgPtAddrDepdntInfoUpdateFluentHelper(
            servicePath,
            custUnldgPtAddrDepdntInfo,
            "A_CustUnldgPtAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public CustUnldgPtAddrDepdntInfoDeleteFluentHelper deleteCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return new CustUnldgPtAddrDepdntInfoDeleteFluentHelper(
            servicePath,
            custUnldgPtAddrDepdntInfo,
            "A_CustUnldgPtAddrDepdntInfo");
    }

    @Override
    @Nonnull
    public SupplierFluentHelper getAllSupplier()
    {
        return new SupplierFluentHelper(servicePath, "A_Supplier");
    }

    @Override
    @Nonnull
    public SupplierByKeyFluentHelper getSupplierByKey( final String supplier )
    {
        return new SupplierByKeyFluentHelper(servicePath, "A_Supplier", supplier);
    }

    @Override
    @Nonnull
    public SupplierCreateFluentHelper createSupplier( @Nonnull final Supplier supplier )
    {
        return new SupplierCreateFluentHelper(servicePath, supplier, "A_Supplier");
    }

    @Override
    @Nonnull
    public SupplierUpdateFluentHelper updateSupplier( @Nonnull final Supplier supplier )
    {
        return new SupplierUpdateFluentHelper(servicePath, supplier, "A_Supplier");
    }

    @Override
    @Nonnull
    public SupplierCompanyFluentHelper getAllSupplierCompany()
    {
        return new SupplierCompanyFluentHelper(servicePath, "A_SupplierCompany");
    }

    @Override
    @Nonnull
    public SupplierCompanyByKeyFluentHelper getSupplierCompanyByKey( final String supplier, final String companyCode )
    {
        return new SupplierCompanyByKeyFluentHelper(servicePath, "A_SupplierCompany", supplier, companyCode);
    }

    @Override
    @Nonnull
    public SupplierCompanyCreateFluentHelper createSupplierCompany( @Nonnull final SupplierCompany supplierCompany )
    {
        return new SupplierCompanyCreateFluentHelper(servicePath, supplierCompany, "A_SupplierCompany");
    }

    @Override
    @Nonnull
    public SupplierCompanyUpdateFluentHelper updateSupplierCompany( @Nonnull final SupplierCompany supplierCompany )
    {
        return new SupplierCompanyUpdateFluentHelper(servicePath, supplierCompany, "A_SupplierCompany");
    }

    @Override
    @Nonnull
    public SupplierCompanyTextFluentHelper getAllSupplierCompanyText()
    {
        return new SupplierCompanyTextFluentHelper(servicePath, "A_SupplierCompanyText");
    }

    @Override
    @Nonnull
    public SupplierCompanyTextByKeyFluentHelper getSupplierCompanyTextByKey(
        final String supplier,
        final String companyCode,
        final String language,
        final String longTextID )
    {
        return new SupplierCompanyTextByKeyFluentHelper(
            servicePath,
            "A_SupplierCompanyText",
            supplier,
            companyCode,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SupplierCompanyTextCreateFluentHelper createSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return new SupplierCompanyTextCreateFluentHelper(servicePath, supplierCompanyText, "A_SupplierCompanyText");
    }

    @Override
    @Nonnull
    public SupplierCompanyTextUpdateFluentHelper updateSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return new SupplierCompanyTextUpdateFluentHelper(servicePath, supplierCompanyText, "A_SupplierCompanyText");
    }

    @Override
    @Nonnull
    public SupplierCompanyTextDeleteFluentHelper deleteSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return new SupplierCompanyTextDeleteFluentHelper(servicePath, supplierCompanyText, "A_SupplierCompanyText");
    }

    @Override
    @Nonnull
    public SupplierDunningFluentHelper getAllSupplierDunning()
    {
        return new SupplierDunningFluentHelper(servicePath, "A_SupplierDunning");
    }

    @Override
    @Nonnull
    public
        SupplierDunningByKeyFluentHelper
        getSupplierDunningByKey( final String supplier, final String companyCode, final String dunningArea )
    {
        return new SupplierDunningByKeyFluentHelper(
            servicePath,
            "A_SupplierDunning",
            supplier,
            companyCode,
            dunningArea);
    }

    @Override
    @Nonnull
    public SupplierDunningCreateFluentHelper createSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return new SupplierDunningCreateFluentHelper(servicePath, supplierDunning, "A_SupplierDunning");
    }

    @Override
    @Nonnull
    public SupplierDunningUpdateFluentHelper updateSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return new SupplierDunningUpdateFluentHelper(servicePath, supplierDunning, "A_SupplierDunning");
    }

    @Override
    @Nonnull
    public SupplierDunningDeleteFluentHelper deleteSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return new SupplierDunningDeleteFluentHelper(servicePath, supplierDunning, "A_SupplierDunning");
    }

    @Override
    @Nonnull
    public SupplierPartnerFuncFluentHelper getAllSupplierPartnerFunc()
    {
        return new SupplierPartnerFuncFluentHelper(servicePath, "A_SupplierPartnerFunc");
    }

    @Override
    @Nonnull
    public SupplierPartnerFuncByKeyFluentHelper getSupplierPartnerFuncByKey(
        final String supplier,
        final String purchasingOrganization,
        final String supplierSubrange,
        final String plant,
        final String partnerFunction,
        final String partnerCounter )
    {
        return new SupplierPartnerFuncByKeyFluentHelper(
            servicePath,
            "A_SupplierPartnerFunc",
            supplier,
            purchasingOrganization,
            supplierSubrange,
            plant,
            partnerFunction,
            partnerCounter);
    }

    @Override
    @Nonnull
    public SupplierPartnerFuncCreateFluentHelper createSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return new SupplierPartnerFuncCreateFluentHelper(servicePath, supplierPartnerFunc, "A_SupplierPartnerFunc");
    }

    @Override
    @Nonnull
    public SupplierPartnerFuncUpdateFluentHelper updateSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return new SupplierPartnerFuncUpdateFluentHelper(servicePath, supplierPartnerFunc, "A_SupplierPartnerFunc");
    }

    @Override
    @Nonnull
    public SupplierPartnerFuncDeleteFluentHelper deleteSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return new SupplierPartnerFuncDeleteFluentHelper(servicePath, supplierPartnerFunc, "A_SupplierPartnerFunc");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgFluentHelper getAllSupplierPurchasingOrg()
    {
        return new SupplierPurchasingOrgFluentHelper(servicePath, "A_SupplierPurchasingOrg");
    }

    @Override
    @Nonnull
    public
        SupplierPurchasingOrgByKeyFluentHelper
        getSupplierPurchasingOrgByKey( final String supplier, final String purchasingOrganization )
    {
        return new SupplierPurchasingOrgByKeyFluentHelper(
            servicePath,
            "A_SupplierPurchasingOrg",
            supplier,
            purchasingOrganization);
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgCreateFluentHelper createSupplierPurchasingOrg(
        @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg )
    {
        return new SupplierPurchasingOrgCreateFluentHelper(
            servicePath,
            supplierPurchasingOrg,
            "A_SupplierPurchasingOrg");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgUpdateFluentHelper updateSupplierPurchasingOrg(
        @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg )
    {
        return new SupplierPurchasingOrgUpdateFluentHelper(
            servicePath,
            supplierPurchasingOrg,
            "A_SupplierPurchasingOrg");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgTextFluentHelper getAllSupplierPurchasingOrgText()
    {
        return new SupplierPurchasingOrgTextFluentHelper(servicePath, "A_SupplierPurchasingOrgText");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgTextByKeyFluentHelper getSupplierPurchasingOrgTextByKey(
        final String supplier,
        final String purchasingOrganization,
        final String language,
        final String longTextID )
    {
        return new SupplierPurchasingOrgTextByKeyFluentHelper(
            servicePath,
            "A_SupplierPurchasingOrgText",
            supplier,
            purchasingOrganization,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgTextCreateFluentHelper createSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return new SupplierPurchasingOrgTextCreateFluentHelper(
            servicePath,
            supplierPurchasingOrgText,
            "A_SupplierPurchasingOrgText");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgTextUpdateFluentHelper updateSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return new SupplierPurchasingOrgTextUpdateFluentHelper(
            servicePath,
            supplierPurchasingOrgText,
            "A_SupplierPurchasingOrgText");
    }

    @Override
    @Nonnull
    public SupplierPurchasingOrgTextDeleteFluentHelper deleteSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return new SupplierPurchasingOrgTextDeleteFluentHelper(
            servicePath,
            supplierPurchasingOrgText,
            "A_SupplierPurchasingOrgText");
    }

    @Override
    @Nonnull
    public SupplierTextFluentHelper getAllSupplierText()
    {
        return new SupplierTextFluentHelper(servicePath, "A_SupplierText");
    }

    @Override
    @Nonnull
    public
        SupplierTextByKeyFluentHelper
        getSupplierTextByKey( final String supplier, final String language, final String longTextID )
    {
        return new SupplierTextByKeyFluentHelper(servicePath, "A_SupplierText", supplier, language, longTextID);
    }

    @Override
    @Nonnull
    public SupplierTextCreateFluentHelper createSupplierText( @Nonnull final SupplierText supplierText )
    {
        return new SupplierTextCreateFluentHelper(servicePath, supplierText, "A_SupplierText");
    }

    @Override
    @Nonnull
    public SupplierTextUpdateFluentHelper updateSupplierText( @Nonnull final SupplierText supplierText )
    {
        return new SupplierTextUpdateFluentHelper(servicePath, supplierText, "A_SupplierText");
    }

    @Override
    @Nonnull
    public SupplierTextDeleteFluentHelper deleteSupplierText( @Nonnull final SupplierText supplierText )
    {
        return new SupplierTextDeleteFluentHelper(servicePath, supplierText, "A_SupplierText");
    }

    @Override
    @Nonnull
    public SupplierWithHoldingTaxFluentHelper getAllSupplierWithHoldingTax()
    {
        return new SupplierWithHoldingTaxFluentHelper(servicePath, "A_SupplierWithHoldingTax");
    }

    @Override
    @Nonnull
    public SupplierWithHoldingTaxByKeyFluentHelper getSupplierWithHoldingTaxByKey(
        final String supplier,
        final String companyCode,
        final String withholdingTaxType )
    {
        return new SupplierWithHoldingTaxByKeyFluentHelper(
            servicePath,
            "A_SupplierWithHoldingTax",
            supplier,
            companyCode,
            withholdingTaxType);
    }

    @Override
    @Nonnull
    public SupplierWithHoldingTaxCreateFluentHelper createSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return new SupplierWithHoldingTaxCreateFluentHelper(
            servicePath,
            supplierWithHoldingTax,
            "A_SupplierWithHoldingTax");
    }

    @Override
    @Nonnull
    public SupplierWithHoldingTaxUpdateFluentHelper updateSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return new SupplierWithHoldingTaxUpdateFluentHelper(
            servicePath,
            supplierWithHoldingTax,
            "A_SupplierWithHoldingTax");
    }

    @Override
    @Nonnull
    public SupplierWithHoldingTaxDeleteFluentHelper deleteSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return new SupplierWithHoldingTaxDeleteFluentHelper(
            servicePath,
            supplierWithHoldingTax,
            "A_SupplierWithHoldingTax");
    }

}
