/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.BusinessPlaceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.GetBusinessPlaceFieldPropertiesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessplace.batch.DefaultBusinessPlaceServiceBatch;

/**
 * <p>
 *
 * This service provides queries about business places based on countries/regions or scenarios. The detailed information
 * you can query is as follows: - Enablement status of a business place in the current business scenario. Based on the
 * enablement status, customers can decide the field status of the business place on the UI, which can be invisible,
 * display only, optional or mandatory. - List of business places by input variants. - Detailed information about
 * business places, such as tax registration number and address. - Attributes of country/region-specific business
 * places..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/78/fc370156da42ada3adf104341ba32e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GLO_BUSINESSPLACE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GLO_BUSINESSPLACE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Place Integration(SAP_COM_0394)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J59'>Accounts Receivable(J59)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J60'>Accounts Payable(J60)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Place</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessPlaceService" )
@Deprecated
public class DefaultBusinessPlaceService implements BusinessPlaceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessPlaceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessPlaceService()
    {
        servicePath = BusinessPlaceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessPlaceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessPlaceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessPlaceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessPlaceServiceBatch batch()
    {
        return new DefaultBusinessPlaceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusinessPlaceFluentHelper getAllBusinessPlace()
    {
        return new BusinessPlaceFluentHelper(servicePath, "BusinessPlaceSet");
    }

    @Override
    @Nonnull
    public
        BusinessPlaceByKeyFluentHelper
        getBusinessPlaceByKey( final String companyCode, final String businessPlaceID )
    {
        return new BusinessPlaceByKeyFluentHelper(servicePath, "BusinessPlaceSet", companyCode, businessPlaceID);
    }

    @Override
    @Nonnull
    public
        GetBusinessPlaceFieldPropertiesFluentHelper
        getBusinessPlaceFieldProperties( @Nonnull final String scenarioID, @Nonnull final String companyCode )
    {
        return new GetBusinessPlaceFieldPropertiesFluentHelper(servicePath, scenarioID, companyCode);
    }

}
