/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChangesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.BusinessRoleChangesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessrolechanges.batch.DefaultBusinessRoleChangesServiceBatch;

/**
 * <p>
 *
 * The service provides a list of change documents for business roles..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f4/b667f2fa8041d5b5ac2e63393d0225/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_APS_IAM_API_BROLE_CDOC_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_APS_IAM_API_BROLE_CDOC_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Role Change Document Integration(SAP_COM_0366)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessRoleChangesService" )
@Deprecated
public class DefaultBusinessRoleChangesService implements BusinessRoleChangesService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessRoleChangesService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessRoleChangesService()
    {
        servicePath = BusinessRoleChangesService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessRoleChangesService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessRoleChangesService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessRoleChangesService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessRoleChangesServiceBatch batch()
    {
        return new DefaultBusinessRoleChangesServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusinessRoleChangesFluentHelper getAllBusinessRoleChanges()
    {
        return new BusinessRoleChangesFluentHelper(servicePath, "BusinessRoleChanges");
    }

    @Override
    @Nonnull
    public BusinessRoleChangesByKeyFluentHelper getBusinessRoleChangesByKey(
        final String businessRoleID,
        final ZonedDateTime changedOn,
        final String changeCategory,
        final String attribute,
        final String valueChangedFrom,
        final String valueChangedTo )
    {
        return new BusinessRoleChangesByKeyFluentHelper(
            servicePath,
            "BusinessRoleChanges",
            businessRoleID,
            changedOn,
            changeCategory,
            attribute,
            valueChangedFrom,
            valueChangedTo);
    }

}
