/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SendActionStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.batch.DefaultBusinessSituationServiceBatch;

/**
 * <p>
 *
 * This API is based on the OData protocol. It provides the situation instance and context data in the payload’s
 * response. This includes the situation instance ID, situation creation time, situation status, situation type ID,
 * situation template ID, situation anchor and trigger object key, anchor object, data context ID, data context, data
 * context creation time, situation activity ID, and situation activity. The payload data can then be consumed, for
 * example, by advanced analytics or automation. It also updates the situation action status for automation. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e3/1831d5c0934e34a982039cfd389211/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUSINESS_SITUATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUSINESS_SITUATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Situation Integration(SAP_COM_0345)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/31N'>Situation Handling(31N)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Situation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessSituationService" )
@Deprecated
public class DefaultBusinessSituationService implements BusinessSituationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessSituationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessSituationService()
    {
        servicePath = BusinessSituationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessSituationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessSituationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessSituationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessSituationServiceBatch batch()
    {
        return new DefaultBusinessSituationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SitnDataContextFluentHelper getAllSitnDataContext()
    {
        return new SitnDataContextFluentHelper(servicePath, "A_SitnDataContext");
    }

    @Override
    @Nonnull
    public SitnDataContextByKeyFluentHelper getSitnDataContextByKey( final String sitnDataContextID )
    {
        return new SitnDataContextByKeyFluentHelper(servicePath, "A_SitnDataContext", sitnDataContextID);
    }

    @Override
    @Nonnull
    public SitnInstanceFluentHelper getAllSitnInstance()
    {
        return new SitnInstanceFluentHelper(servicePath, "A_SitnInstance");
    }

    @Override
    @Nonnull
    public SitnInstanceByKeyFluentHelper getSitnInstanceByKey( final String sitnInstanceID )
    {
        return new SitnInstanceByKeyFluentHelper(servicePath, "A_SitnInstance", sitnInstanceID);
    }

    @Override
    @Nonnull
    public SendActionStatusFluentHelper sendActionStatus(
        @Nonnull final String sitnActionInstanceID,
        @Nonnull final String sitnActionID,
        @Nonnull final String sitnActionStatus,
        @Nonnull final String sitnInstanceID,
        @Nonnull final String sitnInstceTargetStatus )
    {
        return new SendActionStatusFluentHelper(
            servicePath,
            sitnActionInstanceID,
            sitnActionID,
            sitnActionStatus,
            sitnInstanceID,
            sitnInstceTargetStatus);
    }

}
