/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.batch.DefaultBusinessSituationTypeServiceBatch;

/**
 * <p>
 *
 * This API is based on the OData protocol. It provides the situation instance and context data in the payload’s
 * response. This includes the situation instance ID, situation creation time, situation status, situation type ID,
 * situation template ID, situation anchor and trigger object key, anchor object, data context ID, data context, data
 * context creation time, situation activity ID, and situation activity. The payload data can then be consumed, for
 * example, by advanced analytics or automation. It also updates the situation action status for automation.
 *
 * Only use the version 2 of this API. Do not use version 1 as this version is deprecated..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/25/1bcc094bb64219adc396d13332ff23/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUS_SITN_MSTRDATA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUS_SITN_MSTRDATA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Situation Master Data Integration(SAP_COM_0376)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/31N'>Situation Handling(31N)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Situation Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessSituationTypeService" )
@Deprecated
public class DefaultBusinessSituationTypeService implements BusinessSituationTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessSituationTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessSituationTypeService()
    {
        servicePath = BusinessSituationTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessSituationTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessSituationTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessSituationTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessSituationTypeServiceBatch batch()
    {
        return new DefaultBusinessSituationTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SituationActionFluentHelper getAllSituationAction()
    {
        return new SituationActionFluentHelper(servicePath, "SituationAction");
    }

    @Override
    @Nonnull
    public
        SituationActionByKeyFluentHelper
        getSituationActionByKey( final String sitnDefTemplateID, final String sitnActionID )
    {
        return new SituationActionByKeyFluentHelper(servicePath, "SituationAction", sitnDefTemplateID, sitnActionID);
    }

    @Override
    @Nonnull
    public SituationActionTextFluentHelper getAllSituationActionText()
    {
        return new SituationActionTextFluentHelper(servicePath, "SituationActionText");
    }

    @Override
    @Nonnull
    public
        SituationActionTextByKeyFluentHelper
        getSituationActionTextByKey( final String sitnActionID, final String language )
    {
        return new SituationActionTextByKeyFluentHelper(servicePath, "SituationActionText", sitnActionID, language);
    }

    @Override
    @Nonnull
    public SituationTemplateTextFluentHelper getAllSituationTemplateText()
    {
        return new SituationTemplateTextFluentHelper(servicePath, "SituationTemplateText");
    }

    @Override
    @Nonnull
    public
        SituationTemplateTextByKeyFluentHelper
        getSituationTemplateTextByKey( final String sitnDefTemplateID, final String language )
    {
        return new SituationTemplateTextByKeyFluentHelper(
            servicePath,
            "SituationTemplateText",
            sitnDefTemplateID,
            language);
    }

    @Override
    @Nonnull
    public SituationTypeFluentHelper getAllSituationType()
    {
        return new SituationTypeFluentHelper(servicePath, "SituationType");
    }

    @Override
    @Nonnull
    public SituationTypeByKeyFluentHelper getSituationTypeByKey( final String sitnDefinitionID )
    {
        return new SituationTypeByKeyFluentHelper(servicePath, "SituationType", sitnDefinitionID);
    }

    @Override
    @Nonnull
    public SituationTypeTextFluentHelper getAllSituationTypeText()
    {
        return new SituationTypeTextFluentHelper(servicePath, "SituationTypeText");
    }

    @Override
    @Nonnull
    public
        SituationTypeTextByKeyFluentHelper
        getSituationTypeTextByKey( final String sitnDefinitionID, final String language )
    {
        return new SituationTypeTextByKeyFluentHelper(servicePath, "SituationTypeText", sitnDefinitionID, language);
    }

    @Override
    @Nonnull
    public SituationTemplateFluentHelper getAllSituationTemplate()
    {
        return new SituationTemplateFluentHelper(servicePath, "SituationTemplate");
    }

    @Override
    @Nonnull
    public SituationTemplateByKeyFluentHelper getSituationTemplateByKey( final String sitnDefTemplateID )
    {
        return new SituationTemplateByKeyFluentHelper(servicePath, "SituationTemplate", sitnDefTemplateID);
    }

    @Override
    @Nonnull
    public SituationContextDefSchemaFluentHelper getAllSituationContextDefSchema()
    {
        return new SituationContextDefSchemaFluentHelper(servicePath, "SituationContextDefSchema");
    }

    @Override
    @Nonnull
    public SituationContextDefSchemaByKeyFluentHelper getSituationContextDefSchemaByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion )
    {
        return new SituationContextDefSchemaByKeyFluentHelper(
            servicePath,
            "SituationContextDefSchema",
            sitnDefTemplateID,
            sitnDataCntxtFormatVersion,
            sitnDataCntxtSchemaVersion);
    }

    @Override
    @Nonnull
    public SituationContextDefTextFluentHelper getAllSituationContextDefText()
    {
        return new SituationContextDefTextFluentHelper(servicePath, "SituationContextDefText");
    }

    @Override
    @Nonnull
    public SituationContextDefTextByKeyFluentHelper getSituationContextDefTextByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion,
        final String language )
    {
        return new SituationContextDefTextByKeyFluentHelper(
            servicePath,
            "SituationContextDefText",
            sitnDefTemplateID,
            sitnDataCntxtFormatVersion,
            sitnDataCntxtSchemaVersion,
            language);
    }

}
