/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.LinkProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.ReDistributeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.RejectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.UnlinkProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.batch.DefaultBusinessSolutionOrderServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with Business Solution Order processing in Service in SAP
 * S/4HANA Cloud. In each API call, you can use the following operations: - Retrieve Business Solution Order. - Create
 * Business Solution Order. Note: You must use “deep insert” requests (a header plus the following entities: Header
 * details, Header text, Sales Items, Service Items and Service Contract Items). - Create new items for existing
 * Business Solution Order. - Create an item reference object, item object list, item pricing element, and an item text
 * for existing Business Solution Order items. - Update the header, header text, item, item pricing element, and item
 * text of existing Business Solution Orders. - Delete the item, item reference object, item object list, item pricing
 * element, and item text of existing Business Solution Orders.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fb/d802bd29b1477082675f2eefe1e45b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUS_SOLUTION_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUS_SOLUTION_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Solution Order Integration(SAP_COM_0706)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4GT'>Solution Order Management(4GT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Solution Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessSolutionOrderService" )
@Deprecated
public class DefaultBusinessSolutionOrderService implements BusinessSolutionOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessSolutionOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessSolutionOrderService()
    {
        servicePath = BusinessSolutionOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessSolutionOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessSolutionOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessSolutionOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessSolutionOrderServiceBatch batch()
    {
        return new DefaultBusinessSolutionOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BSOrdSrvcContrItmBillgReqItmFluentHelper getAllBSOrdSrvcContrItmBillgReqItm()
    {
        return new BSOrdSrvcContrItmBillgReqItmFluentHelper(servicePath, "A_BSOrdSrvcContrItmBillgReqItm");
    }

    @Override
    @Nonnull
    public BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper getBSOrdSrvcContrItmBillgReqItmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String billingRequestItem )
    {
        return new BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper(
            servicePath,
            "A_BSOrdSrvcContrItmBillgReqItm",
            businessSolutionOrder,
            businessSolutionOrderItem,
            billingRequestItem);
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderFluentHelper getAllBusinessSolutionOrder()
    {
        return new BusinessSolutionOrderFluentHelper(servicePath, "A_BusinessSolutionOrder");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderByKeyFluentHelper getBusinessSolutionOrderByKey( final String businessSolutionOrder )
    {
        return new BusinessSolutionOrderByKeyFluentHelper(
            servicePath,
            "A_BusinessSolutionOrder",
            businessSolutionOrder);
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderCreateFluentHelper createBusinessSolutionOrder(
        @Nonnull final BusinessSolutionOrder businessSolutionOrder )
    {
        return new BusinessSolutionOrderCreateFluentHelper(
            servicePath,
            businessSolutionOrder,
            "A_BusinessSolutionOrder");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderUpdateFluentHelper updateBusinessSolutionOrder(
        @Nonnull final BusinessSolutionOrder businessSolutionOrder )
    {
        return new BusinessSolutionOrderUpdateFluentHelper(
            servicePath,
            businessSolutionOrder,
            "A_BusinessSolutionOrder");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderTextFluentHelper getAllBusinessSolutionOrderText()
    {
        return new BusinessSolutionOrderTextFluentHelper(servicePath, "A_BusinessSolutionOrderText");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderTextByKeyFluentHelper getBusinessSolutionOrderTextByKey(
        final String businessSolutionOrder,
        final String language,
        final String textObjectType )
    {
        return new BusinessSolutionOrderTextByKeyFluentHelper(
            servicePath,
            "A_BusinessSolutionOrderText",
            businessSolutionOrder,
            language,
            textObjectType);
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderTextCreateFluentHelper createBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return new BusinessSolutionOrderTextCreateFluentHelper(
            servicePath,
            businessSolutionOrderText,
            "A_BusinessSolutionOrderText");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderTextUpdateFluentHelper updateBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return new BusinessSolutionOrderTextUpdateFluentHelper(
            servicePath,
            businessSolutionOrderText,
            "A_BusinessSolutionOrderText");
    }

    @Override
    @Nonnull
    public BusinessSolutionOrderTextDeleteFluentHelper deleteBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return new BusinessSolutionOrderTextDeleteFluentHelper(
            servicePath,
            businessSolutionOrderText,
            "A_BusinessSolutionOrderText");
    }

    @Override
    @Nonnull
    public BusSolnOrdBillgReqItmPrcElmFluentHelper getAllBusSolnOrdBillgReqItmPrcElm()
    {
        return new BusSolnOrdBillgReqItmPrcElmFluentHelper(servicePath, "A_BusSolnOrdBillgReqItmPrcElm");
    }

    @Override
    @Nonnull
    public BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper getBusSolnOrdBillgReqItmPrcElmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String billingRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdBillgReqItmPrcElm",
            businessSolutionOrder,
            businessSolutionOrderItem,
            billingRequestItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BusSolnOrdEntProjectItemFluentHelper getAllBusSolnOrdEntProjectItem()
    {
        return new BusSolnOrdEntProjectItemFluentHelper(servicePath, "A_BusSolnOrdEntProjectItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrdEntProjectItemByKeyFluentHelper
        getBusSolnOrdEntProjectItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrdEntProjectItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdEntProjectItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrdEntProjectItemCreateFluentHelper createBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return new BusSolnOrdEntProjectItemCreateFluentHelper(
            servicePath,
            busSolnOrdEntProjectItem,
            "A_BusSolnOrdEntProjectItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdEntProjectItemUpdateFluentHelper updateBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return new BusSolnOrdEntProjectItemUpdateFluentHelper(
            servicePath,
            busSolnOrdEntProjectItem,
            "A_BusSolnOrdEntProjectItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdEntProjectItemDeleteFluentHelper deleteBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return new BusSolnOrdEntProjectItemDeleteFluentHelper(
            servicePath,
            busSolnOrdEntProjectItem,
            "A_BusSolnOrdEntProjectItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderExpenseItemFluentHelper getAllBusSolnOrderExpenseItem()
    {
        return new BusSolnOrderExpenseItemFluentHelper(servicePath, "A_BusSolnOrderExpenseItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrderExpenseItemByKeyFluentHelper
        getBusSolnOrderExpenseItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrderExpenseItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderExpenseItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrderExpenseItemCreateFluentHelper createBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return new BusSolnOrderExpenseItemCreateFluentHelper(
            servicePath,
            busSolnOrderExpenseItem,
            "A_BusSolnOrderExpenseItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderExpenseItemUpdateFluentHelper updateBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return new BusSolnOrderExpenseItemUpdateFluentHelper(
            servicePath,
            busSolnOrderExpenseItem,
            "A_BusSolnOrderExpenseItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderExpenseItemDeleteFluentHelper deleteBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return new BusSolnOrderExpenseItemDeleteFluentHelper(
            servicePath,
            busSolnOrderExpenseItem,
            "A_BusSolnOrderExpenseItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderFUPSalesOrderFluentHelper getAllBusSolnOrderFUPSalesOrder()
    {
        return new BusSolnOrderFUPSalesOrderFluentHelper(servicePath, "A_BusSolnOrderFUPSalesOrder");
    }

    @Override
    @Nonnull
    public BusSolnOrderFUPSalesOrderByKeyFluentHelper getBusSolnOrderFUPSalesOrderByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber )
    {
        return new BusSolnOrderFUPSalesOrderByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderFUPSalesOrder",
            serviceDocumentRelationUUID,
            serviceDocRltnSequenceNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrderItemObjectListFluentHelper getAllBusSolnOrderItemObjectList()
    {
        return new BusSolnOrderItemObjectListFluentHelper(servicePath, "A_BusSolnOrderItemObjectList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemObjectListByKeyFluentHelper getBusSolnOrderItemObjectListByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String product,
        final String equipment,
        final String serviceRefFunctionalLocation )
    {
        return new BusSolnOrderItemObjectListByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderItemObjectList",
            businessSolutionOrder,
            businessSolutionOrderItem,
            product,
            equipment,
            serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    public BusSolnOrderItemObjectListCreateFluentHelper createBusSolnOrderItemObjectList(
        @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList )
    {
        return new BusSolnOrderItemObjectListCreateFluentHelper(
            servicePath,
            busSolnOrderItemObjectList,
            "A_BusSolnOrderItemObjectList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemObjectListDeleteFluentHelper deleteBusSolnOrderItemObjectList(
        @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList )
    {
        return new BusSolnOrderItemObjectListDeleteFluentHelper(
            servicePath,
            busSolnOrderItemObjectList,
            "A_BusSolnOrderItemObjectList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemPriceElementFluentHelper getAllBusSolnOrderItemPriceElement()
    {
        return new BusSolnOrderItemPriceElementFluentHelper(servicePath, "A_BusSolnOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemPriceElementByKeyFluentHelper getBusSolnOrderItemPriceElementByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BusSolnOrderItemPriceElementByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderItemPriceElement",
            businessSolutionOrder,
            businessSolutionOrderItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BusSolnOrderItemPriceElementCreateFluentHelper createBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return new BusSolnOrderItemPriceElementCreateFluentHelper(
            servicePath,
            busSolnOrderItemPriceElement,
            "A_BusSolnOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemPriceElementUpdateFluentHelper updateBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return new BusSolnOrderItemPriceElementUpdateFluentHelper(
            servicePath,
            busSolnOrderItemPriceElement,
            "A_BusSolnOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemPriceElementDeleteFluentHelper deleteBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return new BusSolnOrderItemPriceElementDeleteFluentHelper(
            servicePath,
            busSolnOrderItemPriceElement,
            "A_BusSolnOrderItemPriceElement");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemProductListFluentHelper getAllBusSolnOrderItemProductList()
    {
        return new BusSolnOrderItemProductListFluentHelper(servicePath, "A_BusSolnOrderItemProductList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemProductListByKeyFluentHelper getBusSolnOrderItemProductListByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String srvcProductListProduct )
    {
        return new BusSolnOrderItemProductListByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderItemProductList",
            businessSolutionOrder,
            businessSolutionOrderItem,
            srvcProductListProduct);
    }

    @Override
    @Nonnull
    public BusSolnOrderItemProductListCreateFluentHelper createBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return new BusSolnOrderItemProductListCreateFluentHelper(
            servicePath,
            busSolnOrderItemProductList,
            "A_BusSolnOrderItemProductList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemProductListUpdateFluentHelper updateBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return new BusSolnOrderItemProductListUpdateFluentHelper(
            servicePath,
            busSolnOrderItemProductList,
            "A_BusSolnOrderItemProductList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemProductListDeleteFluentHelper deleteBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return new BusSolnOrderItemProductListDeleteFluentHelper(
            servicePath,
            busSolnOrderItemProductList,
            "A_BusSolnOrderItemProductList");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemScheduleLineFluentHelper getAllBusSolnOrderItemScheduleLine()
    {
        return new BusSolnOrderItemScheduleLineFluentHelper(servicePath, "A_BusSolnOrderItemScheduleLine");
    }

    @Override
    @Nonnull
    public BusSolnOrderItemScheduleLineByKeyFluentHelper getBusSolnOrderItemScheduleLineByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String scheduleLine )
    {
        return new BusSolnOrderItemScheduleLineByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderItemScheduleLine",
            businessSolutionOrder,
            businessSolutionOrderItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public BusSolnOrderSalesItemFluentHelper getAllBusSolnOrderSalesItem()
    {
        return new BusSolnOrderSalesItemFluentHelper(servicePath, "A_BusSolnOrderSalesItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrderSalesItemByKeyFluentHelper
        getBusSolnOrderSalesItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrderSalesItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderSalesItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrderSalesItemCreateFluentHelper createBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return new BusSolnOrderSalesItemCreateFluentHelper(
            servicePath,
            busSolnOrderSalesItem,
            "A_BusSolnOrderSalesItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderSalesItemUpdateFluentHelper updateBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return new BusSolnOrderSalesItemUpdateFluentHelper(
            servicePath,
            busSolnOrderSalesItem,
            "A_BusSolnOrderSalesItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderSalesItemDeleteFluentHelper deleteBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return new BusSolnOrderSalesItemDeleteFluentHelper(
            servicePath,
            busSolnOrderSalesItem,
            "A_BusSolnOrderSalesItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderServiceItemFluentHelper getAllBusSolnOrderServiceItem()
    {
        return new BusSolnOrderServiceItemFluentHelper(servicePath, "A_BusSolnOrderServiceItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrderServiceItemByKeyFluentHelper
        getBusSolnOrderServiceItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrderServiceItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrderServiceItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrderServiceItemCreateFluentHelper createBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return new BusSolnOrderServiceItemCreateFluentHelper(
            servicePath,
            busSolnOrderServiceItem,
            "A_BusSolnOrderServiceItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderServiceItemUpdateFluentHelper updateBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return new BusSolnOrderServiceItemUpdateFluentHelper(
            servicePath,
            busSolnOrderServiceItem,
            "A_BusSolnOrderServiceItem");
    }

    @Override
    @Nonnull
    public BusSolnOrderServiceItemDeleteFluentHelper deleteBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return new BusSolnOrderServiceItemDeleteFluentHelper(
            servicePath,
            busSolnOrderServiceItem,
            "A_BusSolnOrderServiceItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPEntProjectFluentHelper getAllBusSolnOrdFUPEntProject()
    {
        return new BusSolnOrdFUPEntProjectFluentHelper(servicePath, "A_BusSolnOrdFUPEntProject");
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPEntProjectByKeyFluentHelper getBusSolnOrdFUPEntProjectByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber )
    {
        return new BusSolnOrdFUPEntProjectByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdFUPEntProject",
            serviceDocumentRelationUUID,
            serviceDocRltnSequenceNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPServiceContractFluentHelper getAllBusSolnOrdFUPServiceContract()
    {
        return new BusSolnOrdFUPServiceContractFluentHelper(servicePath, "A_BusSolnOrdFUPServiceContract");
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPServiceContractByKeyFluentHelper getBusSolnOrdFUPServiceContractByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber )
    {
        return new BusSolnOrdFUPServiceContractByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdFUPServiceContract",
            serviceDocumentRelationUUID,
            serviceDocRltnSequenceNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPServiceOrderFluentHelper getAllBusSolnOrdFUPServiceOrder()
    {
        return new BusSolnOrdFUPServiceOrderFluentHelper(servicePath, "A_BusSolnOrdFUPServiceOrder");
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPServiceOrderByKeyFluentHelper getBusSolnOrdFUPServiceOrderByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber )
    {
        return new BusSolnOrdFUPServiceOrderByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdFUPServiceOrder",
            serviceDocumentRelationUUID,
            serviceDocRltnSequenceNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPSubscrpnFluentHelper getAllBusSolnOrdFUPSubscrpn()
    {
        return new BusSolnOrdFUPSubscrpnFluentHelper(servicePath, "A_BusSolnOrdFUPSubscrpn");
    }

    @Override
    @Nonnull
    public BusSolnOrdFUPSubscrpnByKeyFluentHelper getBusSolnOrdFUPSubscrpnByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber )
    {
        return new BusSolnOrdFUPSubscrpnByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdFUPSubscrpn",
            serviceDocumentRelationUUID,
            serviceDocRltnSequenceNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItemRelationshipsFluentHelper getAllBusSolnOrdItemRelationships()
    {
        return new BusSolnOrdItemRelationshipsFluentHelper(servicePath, "A_BusSolnOrdItemRelationships");
    }

    @Override
    @Nonnull
    public BusSolnOrdItemRelationshipsByKeyFluentHelper getBusSolnOrdItemRelationshipsByKey(
        final String businessSolutionOrder,
        final String srvcItemRelshpFromItemNumber,
        final String srvcItemRelshpType,
        final String srvcItemRelshpToItemNumber )
    {
        return new BusSolnOrdItemRelationshipsByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItemRelationships",
            businessSolutionOrder,
            srvcItemRelshpFromItemNumber,
            srvcItemRelshpType,
            srvcItemRelshpToItemNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItemRelationshipsCreateFluentHelper createBusSolnOrdItemRelationships(
        @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships )
    {
        return new BusSolnOrdItemRelationshipsCreateFluentHelper(
            servicePath,
            busSolnOrdItemRelationships,
            "A_BusSolnOrdItemRelationships");
    }

    @Override
    @Nonnull
    public BusSolnOrdItemRelationshipsDeleteFluentHelper deleteBusSolnOrdItemRelationships(
        @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships )
    {
        return new BusSolnOrdItemRelationshipsDeleteFluentHelper(
            servicePath,
            busSolnOrdItemRelationships,
            "A_BusSolnOrdItemRelationships");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmConfigurationFluentHelper getAllBusSolnOrdItmConfiguration()
    {
        return new BusSolnOrdItmConfigurationFluentHelper(servicePath, "A_BusSolnOrdItmConfiguration");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmConfigurationByKeyFluentHelper getBusSolnOrdItmConfigurationByKey(
        final String varConfignInstceBusObjectKey,
        final String varConfignInstceBusObjectType,
        final String variantConfigurationInstance,
        final String charcInternalID,
        final String charcValue,
        final Double charcFromNumericValue,
        final Double charcToNumericValue )
    {
        return new BusSolnOrdItmConfigurationByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmConfiguration",
            varConfignInstceBusObjectKey,
            varConfignInstceBusObjectType,
            variantConfigurationInstance,
            charcInternalID,
            charcValue,
            charcFromNumericValue,
            charcToNumericValue);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmConfigurationCreateFluentHelper createBusSolnOrdItmConfiguration(
        @Nonnull final BusSolnOrdItmConfiguration busSolnOrdItmConfiguration )
    {
        return new BusSolnOrdItmConfigurationCreateFluentHelper(
            servicePath,
            busSolnOrdItmConfiguration,
            "A_BusSolnOrdItmConfiguration");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPEntProjectFluentHelper getAllBusSolnOrdItmFUPEntProject()
    {
        return new BusSolnOrdItmFUPEntProjectFluentHelper(servicePath, "A_BusSolnOrdItmFUPEntProject");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPEntProjectByKeyFluentHelper getBusSolnOrdItmFUPEntProjectByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new BusSolnOrdItmFUPEntProjectByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmFUPEntProject",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSalesOrderFluentHelper getAllBusSolnOrdItmFUPSalesOrder()
    {
        return new BusSolnOrdItmFUPSalesOrderFluentHelper(servicePath, "A_BusSolnOrdItmFUPSalesOrder");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSalesOrderByKeyFluentHelper getBusSolnOrdItmFUPSalesOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new BusSolnOrdItmFUPSalesOrderByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmFUPSalesOrder",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPServiceOrderFluentHelper getAllBusSolnOrdItmFUPServiceOrder()
    {
        return new BusSolnOrdItmFUPServiceOrderFluentHelper(servicePath, "A_BusSolnOrdItmFUPServiceOrder");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPServiceOrderByKeyFluentHelper getBusSolnOrdItmFUPServiceOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new BusSolnOrdItmFUPServiceOrderByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmFUPServiceOrder",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSrvcContrFluentHelper getAllBusSolnOrdItmFUPSrvcContr()
    {
        return new BusSolnOrdItmFUPSrvcContrFluentHelper(servicePath, "A_BusSolnOrdItmFUPSrvcContr");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSrvcContrByKeyFluentHelper getBusSolnOrdItmFUPSrvcContrByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new BusSolnOrdItmFUPSrvcContrByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmFUPSrvcContr",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSubscrpnFluentHelper getAllBusSolnOrdItmFUPSubscrpn()
    {
        return new BusSolnOrdItmFUPSubscrpnFluentHelper(servicePath, "A_BusSolnOrdItmFUPSubscrpn");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmFUPSubscrpnByKeyFluentHelper getBusSolnOrdItmFUPSubscrpnByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        return new BusSolnOrdItmFUPSubscrpnByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmFUPSubscrpn",
            serviceDocumentItmRelationUUID,
            serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmRateElementFluentHelper getAllBusSolnOrdItmRateElement()
    {
        return new BusSolnOrdItmRateElementFluentHelper(servicePath, "A_BusSolnOrdItmRateElement");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmRateElementByKeyFluentHelper getBusSolnOrdItmRateElementByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String subscriptionRateElementType )
    {
        return new BusSolnOrdItmRateElementByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmRateElement",
            businessSolutionOrder,
            businessSolutionOrderItem,
            subscriptionRateElement,
            subscriptionRateElementType);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmRateElmntPrcElmFluentHelper getAllBusSolnOrdItmRateElmntPrcElm()
    {
        return new BusSolnOrdItmRateElmntPrcElmFluentHelper(servicePath, "A_BusSolnOrdItmRateElmntPrcElm");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper getBusSolnOrdItmRateElmntPrcElmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmRateElmntPrcElm",
            businessSolutionOrder,
            businessSolutionOrderItem,
            subscriptionRateElement,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmReferenceObjectFluentHelper getAllBusSolnOrdItmReferenceObject()
    {
        return new BusSolnOrdItmReferenceObjectFluentHelper(servicePath, "A_BusSolnOrdItmReferenceObject");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmReferenceObjectByKeyFluentHelper getBusSolnOrdItmReferenceObjectByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String referenceProduct,
        final String serviceRefFunctionalLocation,
        final String serviceReferenceEquipment )
    {
        return new BusSolnOrdItmReferenceObjectByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmReferenceObject",
            businessSolutionOrder,
            businessSolutionOrderItem,
            referenceProduct,
            serviceRefFunctionalLocation,
            serviceReferenceEquipment);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmReferenceObjectCreateFluentHelper createBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return new BusSolnOrdItmReferenceObjectCreateFluentHelper(
            servicePath,
            busSolnOrdItmReferenceObject,
            "A_BusSolnOrdItmReferenceObject");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmReferenceObjectUpdateFluentHelper updateBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return new BusSolnOrdItmReferenceObjectUpdateFluentHelper(
            servicePath,
            busSolnOrdItmReferenceObject,
            "A_BusSolnOrdItmReferenceObject");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmReferenceObjectDeleteFluentHelper deleteBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return new BusSolnOrdItmReferenceObjectDeleteFluentHelper(
            servicePath,
            busSolnOrdItmReferenceObject,
            "A_BusSolnOrdItmReferenceObject");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnParamFluentHelper getAllBusSolnOrdItmSubscrpnParam()
    {
        return new BusSolnOrdItmSubscrpnParamFluentHelper(servicePath, "A_BusSolnOrdItmSubscrpnParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnParamByKeyFluentHelper getBusSolnOrdItmSubscrpnParamByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionParameter )
    {
        return new BusSolnOrdItmSubscrpnParamByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmSubscrpnParam",
            businessSolutionOrder,
            businessSolutionOrderItem,
            subscriptionParameter);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnParamCreateFluentHelper createBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return new BusSolnOrdItmSubscrpnParamCreateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnParam,
            "A_BusSolnOrdItmSubscrpnParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnParamUpdateFluentHelper updateBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return new BusSolnOrdItmSubscrpnParamUpdateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnParam,
            "A_BusSolnOrdItmSubscrpnParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnParamDeleteFluentHelper deleteBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return new BusSolnOrdItmSubscrpnParamDeleteFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnParam,
            "A_BusSolnOrdItmSubscrpnParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrAgrmtFluentHelper getAllBusSolnOrdItmSubscrpnPrAgrmt()
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtFluentHelper(servicePath, "A_BusSolnOrdItmSubscrpnPrAgrmt");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper getBusSolnOrdItmSubscrpnPrAgrmtByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String subscriptionRateSubElement,
        final String subscrpnBillgPrcElmntSpec,
        final String subscrpnBillgPricingField,
        final String subscrpnBillgPrcAgreementLine )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmSubscrpnPrAgrmt",
            businessSolutionOrder,
            businessSolutionOrderItem,
            subscriptionRateElement,
            subscriptionRateSubElement,
            subscrpnBillgPrcElmntSpec,
            subscrpnBillgPricingField,
            subscrpnBillgPrcAgreementLine);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper createBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrAgrmt,
            "A_BusSolnOrdItmSubscrpnPrAgrmt");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper updateBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrAgrmt,
            "A_BusSolnOrdItmSubscrpnPrAgrmt");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper deleteBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrAgrmt,
            "A_BusSolnOrdItmSubscrpnPrAgrmt");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrParamFluentHelper getAllBusSolnOrdItmSubscrpnPrParam()
    {
        return new BusSolnOrdItmSubscrpnPrParamFluentHelper(servicePath, "A_BusSolnOrdItmSubscrpnPrParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper getBusSolnOrdItmSubscrpnPrParamByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscrpnPrcgParameter )
    {
        return new BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmSubscrpnPrParam",
            businessSolutionOrder,
            businessSolutionOrderItem,
            subscrpnPrcgParameter);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrParamCreateFluentHelper createBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return new BusSolnOrdItmSubscrpnPrParamCreateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrParam,
            "A_BusSolnOrdItmSubscrpnPrParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper updateBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return new BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrParam,
            "A_BusSolnOrdItmSubscrpnPrParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper deleteBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return new BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper(
            servicePath,
            busSolnOrdItmSubscrpnPrParam,
            "A_BusSolnOrdItmSubscrpnPrParam");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmUserStatusFluentHelper getAllBusSolnOrdItmUserStatus()
    {
        return new BusSolnOrdItmUserStatusFluentHelper(servicePath, "A_BusSolnOrdItmUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmUserStatusByKeyFluentHelper getBusSolnOrdItmUserStatusByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String userStatus )
    {
        return new BusSolnOrdItmUserStatusByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdItmUserStatus",
            businessSolutionOrder,
            businessSolutionOrderItem,
            userStatus);
    }

    @Override
    @Nonnull
    public BusSolnOrdItmUserStatusCreateFluentHelper createBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return new BusSolnOrdItmUserStatusCreateFluentHelper(
            servicePath,
            busSolnOrdItmUserStatus,
            "A_BusSolnOrdItmUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmUserStatusUpdateFluentHelper updateBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return new BusSolnOrdItmUserStatusUpdateFluentHelper(
            servicePath,
            busSolnOrdItmUserStatus,
            "A_BusSolnOrdItmUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdItmUserStatusDeleteFluentHelper deleteBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return new BusSolnOrdItmUserStatusDeleteFluentHelper(
            servicePath,
            busSolnOrdItmUserStatus,
            "A_BusSolnOrdItmUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcContractItemFluentHelper getAllBusSolnOrdSrvcContractItem()
    {
        return new BusSolnOrdSrvcContractItemFluentHelper(servicePath, "A_BusSolnOrdSrvcContractItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrdSrvcContractItemByKeyFluentHelper
        getBusSolnOrdSrvcContractItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrdSrvcContractItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdSrvcContractItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcContractItemCreateFluentHelper createBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return new BusSolnOrdSrvcContractItemCreateFluentHelper(
            servicePath,
            busSolnOrdSrvcContractItem,
            "A_BusSolnOrdSrvcContractItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcContractItemUpdateFluentHelper updateBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return new BusSolnOrdSrvcContractItemUpdateFluentHelper(
            servicePath,
            busSolnOrdSrvcContractItem,
            "A_BusSolnOrdSrvcContractItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcContractItemDeleteFluentHelper deleteBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return new BusSolnOrdSrvcContractItemDeleteFluentHelper(
            servicePath,
            busSolnOrdSrvcContractItem,
            "A_BusSolnOrdSrvcContractItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcPrtItemFluentHelper getAllBusSolnOrdSrvcPrtItem()
    {
        return new BusSolnOrdSrvcPrtItemFluentHelper(servicePath, "A_BusSolnOrdSrvcPrtItem");
    }

    @Override
    @Nonnull
    public
        BusSolnOrdSrvcPrtItemByKeyFluentHelper
        getBusSolnOrdSrvcPrtItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem )
    {
        return new BusSolnOrdSrvcPrtItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdSrvcPrtItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcPrtItemCreateFluentHelper createBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return new BusSolnOrdSrvcPrtItemCreateFluentHelper(
            servicePath,
            busSolnOrdSrvcPrtItem,
            "A_BusSolnOrdSrvcPrtItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcPrtItemUpdateFluentHelper updateBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return new BusSolnOrdSrvcPrtItemUpdateFluentHelper(
            servicePath,
            busSolnOrdSrvcPrtItem,
            "A_BusSolnOrdSrvcPrtItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSrvcPrtItemDeleteFluentHelper deleteBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return new BusSolnOrdSrvcPrtItemDeleteFluentHelper(
            servicePath,
            busSolnOrdSrvcPrtItem,
            "A_BusSolnOrdSrvcPrtItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSubscrpnBillgItemFluentHelper getAllBusSolnOrdSubscrpnBillgItem()
    {
        return new BusSolnOrdSubscrpnBillgItemFluentHelper(servicePath, "A_BusSolnOrdSubscrpnBillgItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSubscrpnBillgItemByKeyFluentHelper getBusSolnOrdSubscrpnBillgItemByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem )
    {
        return new BusSolnOrdSubscrpnBillgItemByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdSubscrpnBillgItem",
            businessSolutionOrder,
            businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    public BusSolnOrdSubscrpnBillgItemCreateFluentHelper createBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return new BusSolnOrdSubscrpnBillgItemCreateFluentHelper(
            servicePath,
            busSolnOrdSubscrpnBillgItem,
            "A_BusSolnOrdSubscrpnBillgItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSubscrpnBillgItemUpdateFluentHelper updateBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return new BusSolnOrdSubscrpnBillgItemUpdateFluentHelper(
            servicePath,
            busSolnOrdSubscrpnBillgItem,
            "A_BusSolnOrdSubscrpnBillgItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdSubscrpnBillgItemDeleteFluentHelper deleteBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return new BusSolnOrdSubscrpnBillgItemDeleteFluentHelper(
            servicePath,
            busSolnOrdSubscrpnBillgItem,
            "A_BusSolnOrdSubscrpnBillgItem");
    }

    @Override
    @Nonnull
    public BusSolnOrdUserStatusFluentHelper getAllBusSolnOrdUserStatus()
    {
        return new BusSolnOrdUserStatusFluentHelper(servicePath, "A_BusSolnOrdUserStatus");
    }

    @Override
    @Nonnull
    public
        BusSolnOrdUserStatusByKeyFluentHelper
        getBusSolnOrdUserStatusByKey( final String businessSolutionOrder, final String userStatus )
    {
        return new BusSolnOrdUserStatusByKeyFluentHelper(
            servicePath,
            "A_BusSolnOrdUserStatus",
            businessSolutionOrder,
            userStatus);
    }

    @Override
    @Nonnull
    public BusSolnOrdUserStatusCreateFluentHelper createBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return new BusSolnOrdUserStatusCreateFluentHelper(servicePath, busSolnOrdUserStatus, "A_BusSolnOrdUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdUserStatusUpdateFluentHelper updateBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return new BusSolnOrdUserStatusUpdateFluentHelper(servicePath, busSolnOrdUserStatus, "A_BusSolnOrdUserStatus");
    }

    @Override
    @Nonnull
    public BusSolnOrdUserStatusDeleteFluentHelper deleteBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return new BusSolnOrdUserStatusDeleteFluentHelper(servicePath, busSolnOrdUserStatus, "A_BusSolnOrdUserStatus");
    }

    @Override
    @Nonnull
    public BusSolutionOrderItemTextFluentHelper getAllBusSolutionOrderItemText()
    {
        return new BusSolutionOrderItemTextFluentHelper(servicePath, "A_BusSolutionOrderItemText");
    }

    @Override
    @Nonnull
    public BusSolutionOrderItemTextByKeyFluentHelper getBusSolutionOrderItemTextByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String language,
        final String textObjectType )
    {
        return new BusSolutionOrderItemTextByKeyFluentHelper(
            servicePath,
            "A_BusSolutionOrderItemText",
            businessSolutionOrder,
            businessSolutionOrderItem,
            language,
            textObjectType);
    }

    @Override
    @Nonnull
    public BusSolutionOrderItemTextCreateFluentHelper createBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return new BusSolutionOrderItemTextCreateFluentHelper(
            servicePath,
            busSolutionOrderItemText,
            "A_BusSolutionOrderItemText");
    }

    @Override
    @Nonnull
    public BusSolutionOrderItemTextUpdateFluentHelper updateBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return new BusSolutionOrderItemTextUpdateFluentHelper(
            servicePath,
            busSolutionOrderItemText,
            "A_BusSolutionOrderItemText");
    }

    @Override
    @Nonnull
    public BusSolutionOrderItemTextDeleteFluentHelper deleteBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return new BusSolutionOrderItemTextDeleteFluentHelper(
            servicePath,
            busSolutionOrderItemText,
            "A_BusSolutionOrderItemText");
    }

    @Override
    @Nonnull
    public LinkProjectItemFluentHelper linkProjectItem(
        @Nonnull final String linkedProject,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder )
    {
        return new LinkProjectItemFluentHelper(
            servicePath,
            linkedProject,
            businessSolutionOrderItem,
            businessSolutionOrder);
    }

    @Override
    @Nonnull
    public UnlinkProjectItemFluentHelper unlinkProjectItem(
        @Nonnull final String linkedProject,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder )
    {
        return new UnlinkProjectItemFluentHelper(
            servicePath,
            linkedProject,
            businessSolutionOrderItem,
            businessSolutionOrder);
    }

    @Override
    @Nonnull
    public RejectItemFluentHelper rejectItem(
        @Nonnull final String busSolnOrdItmRjcnReason,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder )
    {
        return new RejectItemFluentHelper(
            servicePath,
            busSolnOrdItmRjcnReason,
            businessSolutionOrderItem,
            businessSolutionOrder);
    }

    @Override
    @Nonnull
    public ReDistributeFluentHelper reDistribute( @Nonnull final String businessSolutionOrder )
    {
        return new ReDistributeFluentHelper(servicePath, businessSolutionOrder);
    }

}
