/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.batch.DefaultBusinessUserChangeServiceBatch;

/**
 * <p>
 *
 * The service provides a list of change documents for business users. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1c/042caa1d7142da8de5260bee663864/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_APS_IAM_API_BUSER_CDOC_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_APS_IAM_API_BUSER_CDOC_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business User Change Document Integration(SAP_COM_0327)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business User</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessUserChangeService" )
@Deprecated
public class DefaultBusinessUserChangeService implements BusinessUserChangeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessUserChangeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessUserChangeService()
    {
        servicePath = BusinessUserChangeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessUserChangeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessUserChangeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessUserChangeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessUserChangeServiceBatch batch()
    {
        return new DefaultBusinessUserChangeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusinessUserChangesFluentHelper getAllBusinessUserChanges()
    {
        return new BusinessUserChangesFluentHelper(servicePath, "BusinessUserChanges");
    }

    @Override
    @Nonnull
    public BusinessUserChangesByKeyFluentHelper getBusinessUserChangesByKey(
        final String businessUserID,
        final ZonedDateTime changedOn,
        final String changeCategory,
        final String attribute,
        final String valueChangedFrom,
        final String valueChangedTo )
    {
        return new BusinessUserChangesByKeyFluentHelper(
            servicePath,
            "BusinessUserChanges",
            businessUserID,
            changedOn,
            changeCategory,
            attribute,
            valueChangedFrom,
            valueChangedTo);
    }

}
