/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.AssignLegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CancelContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.UnAssignLegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.batch.DefaultCentralPurchaseContractServiceBatch;

/**
 * <p>
 *
 * With this inbound service, you can create and maintain central purchase contracts and central purchase contract
 * hierarchies. This service is based on the OData protocol and can be consumed by external systems and other
 * interfaces. This service contains entities, such as header, header distribution, header partner, header notes,
 * subordinate central contract, item, item distribution, item partner, item notes, item condition validity, item
 * condition amount, item condition scales, distribution message, legal transaction, and version history. This service
 * allows purchasers from various parts of the company at different locations to take advantage of the negotiated global
 * agreement with suppliers. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/49/95aa55d3b4428f882d512356aa5307/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CENTRAL_PURCHASECONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CENTRAL_PURCHASECONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP S/4HANA Procurement Hub - Central Contract Management Integration(SAP_COM_0243)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2ME'>Central Purchase Contracts(2ME)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Central Purchase Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCentralPurchaseContractService" )
@Deprecated
public class DefaultCentralPurchaseContractService implements CentralPurchaseContractService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CentralPurchaseContractService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCentralPurchaseContractService()
    {
        servicePath = CentralPurchaseContractService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCentralPurchaseContractService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCentralPurchaseContractService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCentralPurchaseContractService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCentralPurchaseContractServiceBatch batch()
    {
        return new DefaultCentralPurchaseContractServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CentralPurchaseContractFluentHelper getAllCentralPurchaseContract()
    {
        return new CentralPurchaseContractFluentHelper(servicePath, "A_CentralPurchaseContract");
    }

    @Override
    @Nonnull
    public CentralPurchaseContractByKeyFluentHelper getCentralPurchaseContractByKey(
        final String centralPurchaseContract )
    {
        return new CentralPurchaseContractByKeyFluentHelper(
            servicePath,
            "A_CentralPurchaseContract",
            centralPurchaseContract);
    }

    @Override
    @Nonnull
    public CentralPurchaseContractCreateFluentHelper createCentralPurchaseContract(
        @Nonnull final CentralPurchaseContract centralPurchaseContract )
    {
        return new CentralPurchaseContractCreateFluentHelper(
            servicePath,
            centralPurchaseContract,
            "A_CentralPurchaseContract");
    }

    @Override
    @Nonnull
    public CePuCoDistrdContrPaytTrmsFluentHelper getAllCePuCoDistrdContrPaytTrms()
    {
        return new CePuCoDistrdContrPaytTrmsFluentHelper(servicePath, "A_CePuCoDistrdContrPaytTrms");
    }

    @Override
    @Nonnull
    public CePuCoDistrdContrPaytTrmsByKeyFluentHelper getCePuCoDistrdContrPaytTrmsByKey(
        final String centralPurchaseContract,
        final String extContractForPurg,
        final String procurementHubSourceSystem )
    {
        return new CePuCoDistrdContrPaytTrmsByKeyFluentHelper(
            servicePath,
            "A_CePuCoDistrdContrPaytTrms",
            centralPurchaseContract,
            extContractForPurg,
            procurementHubSourceSystem);
    }

    @Override
    @Nonnull
    public CePuCoDistrdOutlineAgrmtFluentHelper getAllCePuCoDistrdOutlineAgrmt()
    {
        return new CePuCoDistrdOutlineAgrmtFluentHelper(servicePath, "A_CePuCoDistrdOutlineAgrmt");
    }

    @Override
    @Nonnull
    public CePuCoDistrdOutlineAgrmtByKeyFluentHelper getCePuCoDistrdOutlineAgrmtByKey(
        final String centralPurchaseContract,
        final String extContractForPurg,
        final String procurementHubSourceSystem )
    {
        return new CePuCoDistrdOutlineAgrmtByKeyFluentHelper(
            servicePath,
            "A_CePuCoDistrdOutlineAgrmt",
            centralPurchaseContract,
            extContractForPurg,
            procurementHubSourceSystem);
    }

    @Override
    @Nonnull
    public CntrlPurchaseContractItemFluentHelper getAllCntrlPurchaseContractItem()
    {
        return new CntrlPurchaseContractItemFluentHelper(servicePath, "A_CntrlPurchaseContractItem");
    }

    @Override
    @Nonnull
    public CntrlPurchaseContractItemByKeyFluentHelper getCntrlPurchaseContractItemByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem )
    {
        return new CntrlPurchaseContractItemByKeyFluentHelper(
            servicePath,
            "A_CntrlPurchaseContractItem",
            centralPurchaseContract,
            centralPurchaseContractItem);
    }

    @Override
    @Nonnull
    public CntrlPurContractHeaderNotesFluentHelper getAllCntrlPurContractHeaderNotes()
    {
        return new CntrlPurContractHeaderNotesFluentHelper(servicePath, "A_CntrlPurContractHeaderNotes");
    }

    @Override
    @Nonnull
    public CntrlPurContractHeaderNotesByKeyFluentHelper getCntrlPurContractHeaderNotesByKey(
        final String purchasingDocumentNoteObjectID,
        final String purchasingDocumentNoteType,
        final String purchasingDocumentNoteLanguage )
    {
        return new CntrlPurContractHeaderNotesByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContractHeaderNotes",
            purchasingDocumentNoteObjectID,
            purchasingDocumentNoteType,
            purchasingDocumentNoteLanguage);
    }

    @Override
    @Nonnull
    public CntrlPurContractItemNotesFluentHelper getAllCntrlPurContractItemNotes()
    {
        return new CntrlPurContractItemNotesFluentHelper(servicePath, "A_CntrlPurContractItemNotes");
    }

    @Override
    @Nonnull
    public CntrlPurContractItemNotesByKeyFluentHelper getCntrlPurContractItemNotesByKey(
        final String purchasingDocumentNoteObjectID,
        final String purchasingDocumentNoteType,
        final String purchasingDocumentNoteLanguage )
    {
        return new CntrlPurContractItemNotesByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContractItemNotes",
            purchasingDocumentNoteObjectID,
            purchasingDocumentNoteType,
            purchasingDocumentNoteLanguage);
    }

    @Override
    @Nonnull
    public CntrlPurContrDistrMessagesFluentHelper getAllCntrlPurContrDistrMessages()
    {
        return new CntrlPurContrDistrMessagesFluentHelper(servicePath, "A_CntrlPurContrDistrMessages");
    }

    @Override
    @Nonnull
    public
        CntrlPurContrDistrMessagesByKeyFluentHelper
        getCntrlPurContrDistrMessagesByKey( final String sequenceNumber, final UUID distrResponseMessageUUID )
    {
        return new CntrlPurContrDistrMessagesByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrDistrMessages",
            sequenceNumber,
            distrResponseMessageUUID);
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnAmountFluentHelper getAllCntrlPurContrHdrCndnAmount()
    {
        return new CntrlPurContrHdrCndnAmountFluentHelper(servicePath, "A_CntrlPurContrHdrCndnAmount");
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnAmountByKeyFluentHelper getCntrlPurContrHdrCndnAmountByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber )
    {
        return new CntrlPurContrHdrCndnAmountByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrHdrCndnAmount",
            centralPurchaseContract,
            conditionRecord,
            conditionValidityEndDate,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnScalesFluentHelper getAllCntrlPurContrHdrCndnScales()
    {
        return new CntrlPurContrHdrCndnScalesFluentHelper(servicePath, "A_CntrlPurContrHdrCndnScales");
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnScalesByKeyFluentHelper getCntrlPurContrHdrCndnScalesByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine )
    {
        return new CntrlPurContrHdrCndnScalesByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrHdrCndnScales",
            centralPurchaseContract,
            conditionRecord,
            conditionSequentialNumber,
            conditionValidityEndDate,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnValdtyFluentHelper getAllCntrlPurContrHdrCndnValdty()
    {
        return new CntrlPurContrHdrCndnValdtyFluentHelper(servicePath, "A_CntrlPurContrHdrCndnValdty");
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrCndnValdtyByKeyFluentHelper getCntrlPurContrHdrCndnValdtyByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        return new CntrlPurContrHdrCndnValdtyByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrHdrCndnValdty",
            centralPurchaseContract,
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public CntrlPurContrHdrDistributionFluentHelper getAllCntrlPurContrHdrDistribution()
    {
        return new CntrlPurContrHdrDistributionFluentHelper(servicePath, "A_CntrlPurContrHdrDistribution");
    }

    @Override
    @Nonnull
    public
        CntrlPurContrHdrDistributionByKeyFluentHelper
        getCntrlPurContrHdrDistributionByKey( final String centralPurchaseContract, final String distributionKey )
    {
        return new CntrlPurContrHdrDistributionByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrHdrDistribution",
            centralPurchaseContract,
            distributionKey);
    }

    @Override
    @Nonnull
    public CntrlPurContrHeaderPartnerFluentHelper getAllCntrlPurContrHeaderPartner()
    {
        return new CntrlPurContrHeaderPartnerFluentHelper(servicePath, "A_CntrlPurContrHeaderPartner");
    }

    @Override
    @Nonnull
    public CntrlPurContrHeaderPartnerByKeyFluentHelper getCntrlPurContrHeaderPartnerByKey(
        final String centralPurchaseContract,
        final String distributionKey,
        final String partnerCounter )
    {
        return new CntrlPurContrHeaderPartnerByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrHeaderPartner",
            centralPurchaseContract,
            distributionKey,
            partnerCounter);
    }

    @Override
    @Nonnull
    public CntrlPurContrItemPartnerFluentHelper getAllCntrlPurContrItemPartner()
    {
        return new CntrlPurContrItemPartnerFluentHelper(servicePath, "A_CntrlPurContrItemPartner");
    }

    @Override
    @Nonnull
    public CntrlPurContrItemPartnerByKeyFluentHelper getCntrlPurContrItemPartnerByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String distributionKey,
        final String partnerCounter )
    {
        return new CntrlPurContrItemPartnerByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItemPartner",
            centralPurchaseContract,
            centralPurchaseContractItem,
            distributionKey,
            partnerCounter);
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCmmdtyQtyFluentHelper getAllCntrlPurContrItmCmmdtyQty()
    {
        return new CntrlPurContrItmCmmdtyQtyFluentHelper(servicePath, "A_CntrlPurContrItmCmmdtyQty");
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCmmdtyQtyByKeyFluentHelper getCntrlPurContrItmCmmdtyQtyByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String purgDocCmmdtyQtySqntlNumber )
    {
        return new CntrlPurContrItmCmmdtyQtyByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItmCmmdtyQty",
            centralPurchaseContract,
            centralPurchaseContractItem,
            purgDocCmmdtyQtySqntlNumber);
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnAmountFluentHelper getAllCntrlPurContrItmCndnAmount()
    {
        return new CntrlPurContrItmCndnAmountFluentHelper(servicePath, "A_CntrlPurContrItmCndnAmount");
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnAmountByKeyFluentHelper getCntrlPurContrItmCndnAmountByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber )
    {
        return new CntrlPurContrItmCndnAmountByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItmCndnAmount",
            centralPurchaseContract,
            centralPurchaseContractItem,
            conditionRecord,
            conditionValidityEndDate,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnScalesFluentHelper getAllCntrlPurContrItmCndnScales()
    {
        return new CntrlPurContrItmCndnScalesFluentHelper(servicePath, "A_CntrlPurContrItmCndnScales");
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnScalesByKeyFluentHelper getCntrlPurContrItmCndnScalesByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine )
    {
        return new CntrlPurContrItmCndnScalesByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItmCndnScales",
            centralPurchaseContract,
            centralPurchaseContractItem,
            conditionRecord,
            conditionSequentialNumber,
            conditionValidityEndDate,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnValdtyFluentHelper getAllCntrlPurContrItmCndnValdty()
    {
        return new CntrlPurContrItmCndnValdtyFluentHelper(servicePath, "A_CntrlPurContrItmCndnValdty");
    }

    @Override
    @Nonnull
    public CntrlPurContrItmCndnValdtyByKeyFluentHelper getCntrlPurContrItmCndnValdtyByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        return new CntrlPurContrItmCndnValdtyByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItmCndnValdty",
            centralPurchaseContract,
            centralPurchaseContractItem,
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public CntrlPurContrItmDistributionFluentHelper getAllCntrlPurContrItmDistribution()
    {
        return new CntrlPurContrItmDistributionFluentHelper(servicePath, "A_CntrlPurContrItmDistribution");
    }

    @Override
    @Nonnull
    public CntrlPurContrItmDistributionByKeyFluentHelper getCntrlPurContrItmDistributionByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String distributionKey )
    {
        return new CntrlPurContrItmDistributionByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrItmDistribution",
            centralPurchaseContract,
            centralPurchaseContractItem,
            distributionKey);
    }

    @Override
    @Nonnull
    public CntrlPurContrLegalTransFluentHelper getAllCntrlPurContrLegalTrans()
    {
        return new CntrlPurContrLegalTransFluentHelper(servicePath, "A_CntrlPurContrLegalTrans");
    }

    @Override
    @Nonnull
    public
        CntrlPurContrLegalTransByKeyFluentHelper
        getCntrlPurContrLegalTransByKey( final String centralPurchaseContract, final String legalTransaction )
    {
        return new CntrlPurContrLegalTransByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrLegalTrans",
            centralPurchaseContract,
            legalTransaction);
    }

    @Override
    @Nonnull
    public CntrlPurContrVersionHistoryFluentHelper getAllCntrlPurContrVersionHistory()
    {
        return new CntrlPurContrVersionHistoryFluentHelper(servicePath, "A_CntrlPurContrVersionHistory");
    }

    @Override
    @Nonnull
    public CntrlPurContrVersionHistoryByKeyFluentHelper getCntrlPurContrVersionHistoryByKey(
        final String centralPurchaseContract,
        final String purchasingDocumentVersion )
    {
        return new CntrlPurContrVersionHistoryByKeyFluentHelper(
            servicePath,
            "A_CntrlPurContrVersionHistory",
            centralPurchaseContract,
            purchasingDocumentVersion);
    }

    @Override
    @Nonnull
    public SubordinateCntrlContractFluentHelper getAllSubordinateCntrlContract()
    {
        return new SubordinateCntrlContractFluentHelper(servicePath, "A_SubordinateCntrlContract");
    }

    @Override
    @Nonnull
    public SubordinateCntrlContractByKeyFluentHelper getSubordinateCntrlContractByKey(
        final String purchasingParentDocument,
        final String subordCntrlPurContract,
        final String procmtHubCompanyCodeGroupingID )
    {
        return new SubordinateCntrlContractByKeyFluentHelper(
            servicePath,
            "A_SubordinateCntrlContract",
            purchasingParentDocument,
            subordCntrlPurContract,
            procmtHubCompanyCodeGroupingID);
    }

    @Override
    @Nonnull
    public WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String centralPurchaseContract )
    {
        return new WithdrawFromApprovalFluentHelper(servicePath, centralPurchaseContract);
    }

    @Override
    @Nonnull
    public AssignLegalTransactionFluentHelper assignLegalTransaction(
        @Nonnull final String legalTransactionId,
        @Nonnull final String centralPurchaseContract )
    {
        return new AssignLegalTransactionFluentHelper(servicePath, legalTransactionId, centralPurchaseContract);
    }

    @Override
    @Nonnull
    public UnAssignLegalTransactionFluentHelper unAssignLegalTransaction(
        @Nonnull final String legaltransactionlinkdobjuuid )
    {
        return new UnAssignLegalTransactionFluentHelper(servicePath, legaltransactionlinkdobjuuid);
    }

    @Override
    @Nonnull
    public CancelContractFluentHelper cancelContract( @Nonnull final String centralPurchaseContract )
    {
        return new CancelContractFluentHelper(servicePath, centralPurchaseContract);
    }

}
