/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMaterialObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMatlBOMObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAlternativeDateToObjectMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ShiftValidityStartDateOfChangeMasterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMaterialObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAlternativeDateFromObjMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.batch.DefaultChangeMasterV2ServiceBatch;

/**
 * <p>
 *
 * You can display and edit change master header data, as well as specify the allowed object types and add alternative
 * dates to your change masters. You can also maintain object management records of the following objects: document info
 * record, material, and bill of material..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/86/ebe598240d486dafbda2b4e523f553/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHANGEMASTER_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHANGEMASTER_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Change Master</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultChangeMasterV2Service" )
@Deprecated
public class DefaultChangeMasterV2Service implements ChangeMasterV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ChangeMasterV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultChangeMasterV2Service()
    {
        servicePath = ChangeMasterV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultChangeMasterV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultChangeMasterV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultChangeMasterV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultChangeMasterV2ServiceBatch batch()
    {
        return new DefaultChangeMasterV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ChangeMasterAltDateFluentHelper getAllChangeMasterAltDate()
    {
        return new ChangeMasterAltDateFluentHelper(servicePath, "A_ChangeMasterAltDate");
    }

    @Override
    @Nonnull
    public
        ChangeMasterAltDateByKeyFluentHelper
        getChangeMasterAltDateByKey( final String changeNumber, final String chgNmbrAlternativeDateID )
    {
        return new ChangeMasterAltDateByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterAltDate",
            changeNumber,
            chgNmbrAlternativeDateID);
    }

    @Override
    @Nonnull
    public ChangeMasterAltDateCreateFluentHelper createChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return new ChangeMasterAltDateCreateFluentHelper(servicePath, changeMasterAltDate, "A_ChangeMasterAltDate");
    }

    @Override
    @Nonnull
    public ChangeMasterAltDateUpdateFluentHelper updateChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return new ChangeMasterAltDateUpdateFluentHelper(servicePath, changeMasterAltDate, "A_ChangeMasterAltDate");
    }

    @Override
    @Nonnull
    public ChangeMasterAltDateDeleteFluentHelper deleteChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return new ChangeMasterAltDateDeleteFluentHelper(servicePath, changeMasterAltDate, "A_ChangeMasterAltDate");
    }

    @Override
    @Nonnull
    public ChangeMasterCharcFluentHelper getAllChangeMasterCharc()
    {
        return new ChangeMasterCharcFluentHelper(servicePath, "A_ChangeMasterCharc");
    }

    @Override
    @Nonnull
    public
        ChangeMasterCharcByKeyFluentHelper
        getChangeMasterCharcByKey( final String changeNumber, final String charcInternalID, final String classType )
    {
        return new ChangeMasterCharcByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterCharc",
            changeNumber,
            charcInternalID,
            classType);
    }

    @Override
    @Nonnull
    public ChangeMasterCharcValueFluentHelper getAllChangeMasterCharcValue()
    {
        return new ChangeMasterCharcValueFluentHelper(servicePath, "A_ChangeMasterCharcValue");
    }

    @Override
    @Nonnull
    public ChangeMasterCharcValueByKeyFluentHelper getChangeMasterCharcValueByKey(
        final String changeNumber,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new ChangeMasterCharcValueByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterCharcValue",
            changeNumber,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public ChangeMasterClassFluentHelper getAllChangeMasterClass()
    {
        return new ChangeMasterClassFluentHelper(servicePath, "A_ChangeMasterClass");
    }

    @Override
    @Nonnull
    public
        ChangeMasterClassByKeyFluentHelper
        getChangeMasterClassByKey( final String changeNumber, final String classInternalID )
    {
        return new ChangeMasterClassByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterClass",
            changeNumber,
            classInternalID);
    }

    @Override
    @Nonnull
    public ChangeMasterClassCharcFluentHelper getAllChangeMasterClassCharc()
    {
        return new ChangeMasterClassCharcFluentHelper(servicePath, "A_ChangeMasterClassCharc");
    }

    @Override
    @Nonnull
    public ChangeMasterClassCharcByKeyFluentHelper getChangeMasterClassCharcByKey(
        final String changeNumber,
        final String classInternalID,
        final String charcInternalID )
    {
        return new ChangeMasterClassCharcByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterClassCharc",
            changeNumber,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public ChangeMasterObjTypeAssgmtFluentHelper getAllChangeMasterObjTypeAssgmt()
    {
        return new ChangeMasterObjTypeAssgmtFluentHelper(servicePath, "A_ChangeMasterObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public
        ChangeMasterObjTypeAssgmtByKeyFluentHelper
        getChangeMasterObjTypeAssgmtByKey( final String changeNumber, final String sAPObjectType )
    {
        return new ChangeMasterObjTypeAssgmtByKeyFluentHelper(
            servicePath,
            "A_ChangeMasterObjTypeAssgmt",
            changeNumber,
            sAPObjectType);
    }

    @Override
    @Nonnull
    public ChangeMasterObjTypeAssgmtCreateFluentHelper createChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return new ChangeMasterObjTypeAssgmtCreateFluentHelper(
            servicePath,
            changeMasterObjTypeAssgmt,
            "A_ChangeMasterObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public ChangeMasterObjTypeAssgmtUpdateFluentHelper updateChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return new ChangeMasterObjTypeAssgmtUpdateFluentHelper(
            servicePath,
            changeMasterObjTypeAssgmt,
            "A_ChangeMasterObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public ChangeMasterObjTypeAssgmtDeleteFluentHelper deleteChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return new ChangeMasterObjTypeAssgmtDeleteFluentHelper(
            servicePath,
            changeMasterObjTypeAssgmt,
            "A_ChangeMasterObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public ChangeMasterFluentHelper getAllChangeMaster()
    {
        return new ChangeMasterFluentHelper(servicePath, "A_ChangeMaster");
    }

    @Override
    @Nonnull
    public ChangeMasterByKeyFluentHelper getChangeMasterByKey( final String changeNumber )
    {
        return new ChangeMasterByKeyFluentHelper(servicePath, "A_ChangeMaster", changeNumber);
    }

    @Override
    @Nonnull
    public ChangeMasterCreateFluentHelper createChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return new ChangeMasterCreateFluentHelper(servicePath, changeMaster, "A_ChangeMaster");
    }

    @Override
    @Nonnull
    public ChangeMasterUpdateFluentHelper updateChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return new ChangeMasterUpdateFluentHelper(servicePath, changeMaster, "A_ChangeMaster");
    }

    @Override
    @Nonnull
    public ChangeMasterDeleteFluentHelper deleteChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return new ChangeMasterDeleteFluentHelper(servicePath, changeMaster, "A_ChangeMaster");
    }

    @Override
    @Nonnull
    public ChangeMstrObjectMgmtRecordFluentHelper getAllChangeMstrObjectMgmtRecord()
    {
        return new ChangeMstrObjectMgmtRecordFluentHelper(servicePath, "A_ChangeMstrObjectMgmtRecord");
    }

    @Override
    @Nonnull
    public ChangeMstrObjectMgmtRecordByKeyFluentHelper getChangeMstrObjectMgmtRecordByKey(
        final String changeNumber,
        final String sAPObjectType,
        final String sAPObjectTechnicalID )
    {
        return new ChangeMstrObjectMgmtRecordByKeyFluentHelper(
            servicePath,
            "A_ChangeMstrObjectMgmtRecord",
            changeNumber,
            sAPObjectType,
            sAPObjectTechnicalID);
    }

    @Override
    @Nonnull
    public ChangeMstrObjectMgmtRecordUpdateFluentHelper updateChangeMstrObjectMgmtRecord(
        @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord )
    {
        return new ChangeMstrObjectMgmtRecordUpdateFluentHelper(
            servicePath,
            changeMstrObjectMgmtRecord,
            "A_ChangeMstrObjectMgmtRecord");
    }

    @Override
    @Nonnull
    public ChangeMstrObjectMgmtRecordDeleteFluentHelper deleteChangeMstrObjectMgmtRecord(
        @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord )
    {
        return new ChangeMstrObjectMgmtRecordDeleteFluentHelper(
            servicePath,
            changeMstrObjectMgmtRecord,
            "A_ChangeMstrObjectMgmtRecord");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReDocInfoRecdFluentHelper getAllChangeMstrObMgReDocInfoRecd()
    {
        return new ChangeMstrObMgReDocInfoRecdFluentHelper(servicePath, "A_ChangeMstrObMgReDocInfoRecd");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReDocInfoRecdByKeyFluentHelper getChangeMstrObMgReDocInfoRecdByKey(
        final String changeNumber,
        final String documentType,
        final String documentInfoRecord,
        final String documentPart,
        final String documentVersion )
    {
        return new ChangeMstrObMgReDocInfoRecdByKeyFluentHelper(
            servicePath,
            "A_ChangeMstrObMgReDocInfoRecd",
            changeNumber,
            documentType,
            documentInfoRecord,
            documentPart,
            documentVersion);
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReDocInfoRecdCreateFluentHelper createChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return new ChangeMstrObMgReDocInfoRecdCreateFluentHelper(
            servicePath,
            changeMstrObMgReDocInfoRecd,
            "A_ChangeMstrObMgReDocInfoRecd");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReDocInfoRecdUpdateFluentHelper updateChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return new ChangeMstrObMgReDocInfoRecdUpdateFluentHelper(
            servicePath,
            changeMstrObMgReDocInfoRecd,
            "A_ChangeMstrObMgReDocInfoRecd");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReDocInfoRecdDeleteFluentHelper deleteChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return new ChangeMstrObMgReDocInfoRecdDeleteFluentHelper(
            servicePath,
            changeMstrObMgReDocInfoRecd,
            "A_ChangeMstrObMgReDocInfoRecd");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMaterialFluentHelper getAllChangeMstrObMgReMaterial()
    {
        return new ChangeMstrObMgReMaterialFluentHelper(servicePath, "A_ChangeMstrObMgReMaterial");
    }

    @Override
    @Nonnull
    public
        ChangeMstrObMgReMaterialByKeyFluentHelper
        getChangeMstrObMgReMaterialByKey( final String changeNumber, final String material )
    {
        return new ChangeMstrObMgReMaterialByKeyFluentHelper(
            servicePath,
            "A_ChangeMstrObMgReMaterial",
            changeNumber,
            material);
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMaterialCreateFluentHelper createChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return new ChangeMstrObMgReMaterialCreateFluentHelper(
            servicePath,
            changeMstrObMgReMaterial,
            "A_ChangeMstrObMgReMaterial");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMaterialUpdateFluentHelper updateChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return new ChangeMstrObMgReMaterialUpdateFluentHelper(
            servicePath,
            changeMstrObMgReMaterial,
            "A_ChangeMstrObMgReMaterial");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMaterialDeleteFluentHelper deleteChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return new ChangeMstrObMgReMaterialDeleteFluentHelper(
            servicePath,
            changeMstrObMgReMaterial,
            "A_ChangeMstrObMgReMaterial");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMatlBOMFluentHelper getAllChangeMstrObMgReMatlBOM()
    {
        return new ChangeMstrObMgReMatlBOMFluentHelper(servicePath, "A_ChangeMstrObMgReMatlBOM");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMatlBOMByKeyFluentHelper getChangeMstrObMgReMatlBOMByKey(
        final String changeNumber,
        final String material,
        final String plant,
        final String billOfMaterialVariantUsage )
    {
        return new ChangeMstrObMgReMatlBOMByKeyFluentHelper(
            servicePath,
            "A_ChangeMstrObMgReMatlBOM",
            changeNumber,
            material,
            plant,
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMatlBOMCreateFluentHelper createChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return new ChangeMstrObMgReMatlBOMCreateFluentHelper(
            servicePath,
            changeMstrObMgReMatlBOM,
            "A_ChangeMstrObMgReMatlBOM");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMatlBOMUpdateFluentHelper updateChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return new ChangeMstrObMgReMatlBOMUpdateFluentHelper(
            servicePath,
            changeMstrObMgReMatlBOM,
            "A_ChangeMstrObMgReMatlBOM");
    }

    @Override
    @Nonnull
    public ChangeMstrObMgReMatlBOMDeleteFluentHelper deleteChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return new ChangeMstrObMgReMatlBOMDeleteFluentHelper(
            servicePath,
            changeMstrObMgReMatlBOM,
            "A_ChangeMstrObMgReMatlBOM");
    }

    @Override
    @Nonnull
    public ShiftValidityStartDateOfChangeMasterFluentHelper shiftValidityStartDateOfChangeMaster(
        @Nonnull final String changeNumber,
        @Nullable final LocalDateTime validityStartDate )
    {
        return new ShiftValidityStartDateOfChangeMasterFluentHelper(servicePath, changeNumber, validityStartDate);
    }

    @Override
    @Nonnull
    public AssignAlternativeDateToObjectMgmtRecordFluentHelper assignAlternativeDateToObjectMgmtRecord(
        @Nonnull final String changeNumber,
        @Nonnull final String sAPObjectType,
        @Nonnull final String sAPObjectTechnicalID,
        @Nullable final String chgNmbrAlternativeDateID )
    {
        return new AssignAlternativeDateToObjectMgmtRecordFluentHelper(
            servicePath,
            changeNumber,
            sAPObjectType,
            sAPObjectTechnicalID,
            chgNmbrAlternativeDateID);
    }

    @Override
    @Nonnull
    public UnassignAlternativeDateFromObjMgmtRecordFluentHelper unassignAlternativeDateFromObjMgmtRecord(
        @Nonnull final String changeNumber,
        @Nonnull final String sAPObjectType,
        @Nonnull final String sAPObjectTechnicalID )
    {
        return new UnassignAlternativeDateFromObjMgmtRecordFluentHelper(
            servicePath,
            changeNumber,
            sAPObjectType,
            sAPObjectTechnicalID);
    }

    @Override
    @Nonnull
    public AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper assignAltDateToDocInfoRecdObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String documentType,
        @Nonnull final String documentInfoRecord,
        @Nonnull final String documentPart,
        @Nonnull final String documentVersion,
        @Nullable final String chgNmbrAlternativeDateID )
    {
        return new AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper(
            servicePath,
            changeNumber,
            documentType,
            documentInfoRecord,
            documentPart,
            documentVersion,
            chgNmbrAlternativeDateID);
    }

    @Override
    @Nonnull
    public UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper unassignAltDateFromDocInfoRecdObjMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String documentType,
        @Nonnull final String documentInfoRecord,
        @Nonnull final String documentPart,
        @Nonnull final String documentVersion )
    {
        return new UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper(
            servicePath,
            changeNumber,
            documentType,
            documentInfoRecord,
            documentPart,
            documentVersion);
    }

    @Override
    @Nonnull
    public AssignAltDateToMaterialObjectMgmtRecFluentHelper assignAltDateToMaterialObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nullable final String chgNmbrAlternativeDateID )
    {
        return new AssignAltDateToMaterialObjectMgmtRecFluentHelper(
            servicePath,
            changeNumber,
            material,
            chgNmbrAlternativeDateID);
    }

    @Override
    @Nonnull
    public
        UnassignAltDateFromMaterialObjMgmtRecFluentHelper
        unassignAltDateFromMaterialObjMgmtRec( @Nonnull final String changeNumber, @Nonnull final String material )
    {
        return new UnassignAltDateFromMaterialObjMgmtRecFluentHelper(servicePath, changeNumber, material);
    }

    @Override
    @Nonnull
    public AssignAltDateToMatlBOMObjectMgmtRecFluentHelper assignAltDateToMatlBOMObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nullable final String chgNmbrAlternativeDateID )
    {
        return new AssignAltDateToMatlBOMObjectMgmtRecFluentHelper(
            servicePath,
            changeNumber,
            material,
            plant,
            billOfMaterialVariantUsage,
            chgNmbrAlternativeDateID);
    }

    @Override
    @Nonnull
    public UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper unassignAltDateFromMatlBOMObjMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialVariantUsage )
    {
        return new UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper(
            servicePath,
            changeNumber,
            material,
            plant,
            billOfMaterialVariantUsage);
    }

}
