/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.batch.DefaultChangeRecordServiceBatch;

/**
 * <p>
 *
 * You can create, read, and delete change records as header objects. You can also assign (write), read, and delete the
 * following objects belonging to change records: - BOM - BOM item - Characteristic - Class - Document info record -
 * Equipment BOM - Equipment Task List - Functional Location BOM - Functional Location Task List - Maintenance Task List
 * - Master Recipes - Material - Product structure variant - Production Routings - Standard BOM - Variant BOM -
 * Collaboration - Engineering BOM - Manufacturing BOM.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/55/c67e37571043f6824dd3f8aaa48b1b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHANGE_RECORD?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHANGE_RECORD</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Change Record Integration(SAP_COM_0339)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NF'>Engineering Change Management with Change Records(1NF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/64E'>Product Change Mgmt with Change Records - Discrete
 * Industries(64E)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/5QC'>Product Change Management with Change
 * Records - Process Industries(5QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Change Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultChangeRecordService" )
@Deprecated
public class DefaultChangeRecordService implements ChangeRecordService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ChangeRecordService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultChangeRecordService()
    {
        servicePath = ChangeRecordService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultChangeRecordService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultChangeRecordService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultChangeRecordService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultChangeRecordServiceBatch batch()
    {
        return new DefaultChangeRecordServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ChangeRecordFluentHelper getAllChangeRecord()
    {
        return new ChangeRecordFluentHelper(servicePath, "A_ChangeRecord");
    }

    @Override
    @Nonnull
    public ChangeRecordByKeyFluentHelper getChangeRecordByKey( final UUID changeRecordUUID )
    {
        return new ChangeRecordByKeyFluentHelper(servicePath, "A_ChangeRecord", changeRecordUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordCreateFluentHelper createChangeRecord( @Nonnull final ChangeRecord changeRecord )
    {
        return new ChangeRecordCreateFluentHelper(servicePath, changeRecord, "A_ChangeRecord");
    }

    @Override
    @Nonnull
    public ChangeRecordUpdateFluentHelper updateChangeRecord( @Nonnull final ChangeRecord changeRecord )
    {
        return new ChangeRecordUpdateFluentHelper(servicePath, changeRecord, "A_ChangeRecord");
    }

    @Override
    @Nonnull
    public ChangeRecordRefCharcFluentHelper getAllChangeRecordRefCharc()
    {
        return new ChangeRecordRefCharcFluentHelper(servicePath, "A_ChangeRecordRefCharc");
    }

    @Override
    @Nonnull
    public ChangeRecordRefCharcByKeyFluentHelper getChangeRecordRefCharcByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordRefCharcByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordRefCharc",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordRefCharcCreateFluentHelper createChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return new ChangeRecordRefCharcCreateFluentHelper(servicePath, changeRecordRefCharc, "A_ChangeRecordRefCharc");
    }

    @Override
    @Nonnull
    public ChangeRecordRefCharcUpdateFluentHelper updateChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return new ChangeRecordRefCharcUpdateFluentHelper(servicePath, changeRecordRefCharc, "A_ChangeRecordRefCharc");
    }

    @Override
    @Nonnull
    public ChangeRecordRefCharcDeleteFluentHelper deleteChangeRecordRefCharc(
        @Nonnull final ChangeRecordRefCharc changeRecordRefCharc )
    {
        return new ChangeRecordRefCharcDeleteFluentHelper(servicePath, changeRecordRefCharc, "A_ChangeRecordRefCharc");
    }

    @Override
    @Nonnull
    public ChangeRecordRefClassFluentHelper getAllChangeRecordRefClass()
    {
        return new ChangeRecordRefClassFluentHelper(servicePath, "A_ChangeRecordRefClass");
    }

    @Override
    @Nonnull
    public ChangeRecordRefClassByKeyFluentHelper getChangeRecordRefClassByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordRefClassByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordRefClass",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordRefClassCreateFluentHelper createChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return new ChangeRecordRefClassCreateFluentHelper(servicePath, changeRecordRefClass, "A_ChangeRecordRefClass");
    }

    @Override
    @Nonnull
    public ChangeRecordRefClassUpdateFluentHelper updateChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return new ChangeRecordRefClassUpdateFluentHelper(servicePath, changeRecordRefClass, "A_ChangeRecordRefClass");
    }

    @Override
    @Nonnull
    public ChangeRecordRefClassDeleteFluentHelper deleteChangeRecordRefClass(
        @Nonnull final ChangeRecordRefClass changeRecordRefClass )
    {
        return new ChangeRecordRefClassDeleteFluentHelper(servicePath, changeRecordRefClass, "A_ChangeRecordRefClass");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBitFluentHelper getAllChangeRecordReferenceBit()
    {
        return new ChangeRecordReferenceBitFluentHelper(servicePath, "A_ChangeRecordReferenceBit");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBitByKeyFluentHelper getChangeRecordReferenceBitByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordReferenceBitByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordReferenceBit",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBitCreateFluentHelper createChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return new ChangeRecordReferenceBitCreateFluentHelper(
            servicePath,
            changeRecordReferenceBit,
            "A_ChangeRecordReferenceBit");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBitUpdateFluentHelper updateChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return new ChangeRecordReferenceBitUpdateFluentHelper(
            servicePath,
            changeRecordReferenceBit,
            "A_ChangeRecordReferenceBit");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBitDeleteFluentHelper deleteChangeRecordReferenceBit(
        @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit )
    {
        return new ChangeRecordReferenceBitDeleteFluentHelper(
            servicePath,
            changeRecordReferenceBit,
            "A_ChangeRecordReferenceBit");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBOMFluentHelper getAllChangeRecordReferenceBOM()
    {
        return new ChangeRecordReferenceBOMFluentHelper(servicePath, "A_ChangeRecordReferenceBOM");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBOMByKeyFluentHelper getChangeRecordReferenceBOMByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordReferenceBOMByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordReferenceBOM",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBOMCreateFluentHelper createChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return new ChangeRecordReferenceBOMCreateFluentHelper(
            servicePath,
            changeRecordReferenceBOM,
            "A_ChangeRecordReferenceBOM");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBOMUpdateFluentHelper updateChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return new ChangeRecordReferenceBOMUpdateFluentHelper(
            servicePath,
            changeRecordReferenceBOM,
            "A_ChangeRecordReferenceBOM");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceBOMDeleteFluentHelper deleteChangeRecordReferenceBOM(
        @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM )
    {
        return new ChangeRecordReferenceBOMDeleteFluentHelper(
            servicePath,
            changeRecordReferenceBOM,
            "A_ChangeRecordReferenceBOM");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceDocFluentHelper getAllChangeRecordReferenceDoc()
    {
        return new ChangeRecordReferenceDocFluentHelper(servicePath, "A_ChangeRecordReferenceDoc");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceDocByKeyFluentHelper getChangeRecordReferenceDocByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordReferenceDocByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordReferenceDoc",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceDocCreateFluentHelper createChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return new ChangeRecordReferenceDocCreateFluentHelper(
            servicePath,
            changeRecordReferenceDoc,
            "A_ChangeRecordReferenceDoc");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceDocUpdateFluentHelper updateChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return new ChangeRecordReferenceDocUpdateFluentHelper(
            servicePath,
            changeRecordReferenceDoc,
            "A_ChangeRecordReferenceDoc");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceDocDeleteFluentHelper deleteChangeRecordReferenceDoc(
        @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc )
    {
        return new ChangeRecordReferenceDocDeleteFluentHelper(
            servicePath,
            changeRecordReferenceDoc,
            "A_ChangeRecordReferenceDoc");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceMatFluentHelper getAllChangeRecordReferenceMat()
    {
        return new ChangeRecordReferenceMatFluentHelper(servicePath, "A_ChangeRecordReferenceMat");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceMatByKeyFluentHelper getChangeRecordReferenceMatByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordReferenceMatByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordReferenceMat",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceMatCreateFluentHelper createChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return new ChangeRecordReferenceMatCreateFluentHelper(
            servicePath,
            changeRecordReferenceMat,
            "A_ChangeRecordReferenceMat");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceMatUpdateFluentHelper updateChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return new ChangeRecordReferenceMatUpdateFluentHelper(
            servicePath,
            changeRecordReferenceMat,
            "A_ChangeRecordReferenceMat");
    }

    @Override
    @Nonnull
    public ChangeRecordReferenceMatDeleteFluentHelper deleteChangeRecordReferenceMat(
        @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat )
    {
        return new ChangeRecordReferenceMatDeleteFluentHelper(
            servicePath,
            changeRecordReferenceMat,
            "A_ChangeRecordReferenceMat");
    }

    @Override
    @Nonnull
    public ChangeRecordReferencePSVFluentHelper getAllChangeRecordReferencePSV()
    {
        return new ChangeRecordReferencePSVFluentHelper(servicePath, "A_ChangeRecordReferencePSV");
    }

    @Override
    @Nonnull
    public ChangeRecordReferencePSVByKeyFluentHelper getChangeRecordReferencePSVByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordReferencePSVByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordReferencePSV",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordReferencePSVCreateFluentHelper createChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return new ChangeRecordReferencePSVCreateFluentHelper(
            servicePath,
            changeRecordReferencePSV,
            "A_ChangeRecordReferencePSV");
    }

    @Override
    @Nonnull
    public ChangeRecordReferencePSVUpdateFluentHelper updateChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return new ChangeRecordReferencePSVUpdateFluentHelper(
            servicePath,
            changeRecordReferencePSV,
            "A_ChangeRecordReferencePSV");
    }

    @Override
    @Nonnull
    public ChangeRecordReferencePSVDeleteFluentHelper deleteChangeRecordReferencePSV(
        @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV )
    {
        return new ChangeRecordReferencePSVDeleteFluentHelper(
            servicePath,
            changeRecordReferencePSV,
            "A_ChangeRecordReferencePSV");
    }

    @Override
    @Nonnull
    public ChangeRecordRefMasterRecipeFluentHelper getAllChangeRecordRefMasterRecipe()
    {
        return new ChangeRecordRefMasterRecipeFluentHelper(servicePath, "A_ChangeRecordRefMasterRecipe");
    }

    @Override
    @Nonnull
    public ChangeRecordRefMasterRecipeByKeyFluentHelper getChangeRecordRefMasterRecipeByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordRefMasterRecipeByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordRefMasterRecipe",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordRefMasterRecipeCreateFluentHelper createChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return new ChangeRecordRefMasterRecipeCreateFluentHelper(
            servicePath,
            changeRecordRefMasterRecipe,
            "A_ChangeRecordRefMasterRecipe");
    }

    @Override
    @Nonnull
    public ChangeRecordRefMasterRecipeUpdateFluentHelper updateChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return new ChangeRecordRefMasterRecipeUpdateFluentHelper(
            servicePath,
            changeRecordRefMasterRecipe,
            "A_ChangeRecordRefMasterRecipe");
    }

    @Override
    @Nonnull
    public ChangeRecordRefMasterRecipeDeleteFluentHelper deleteChangeRecordRefMasterRecipe(
        @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe )
    {
        return new ChangeRecordRefMasterRecipeDeleteFluentHelper(
            servicePath,
            changeRecordRefMasterRecipe,
            "A_ChangeRecordRefMasterRecipe");
    }

    @Override
    @Nonnull
    public ChangeRecordRefProdnRoutingFluentHelper getAllChangeRecordRefProdnRouting()
    {
        return new ChangeRecordRefProdnRoutingFluentHelper(servicePath, "A_ChangeRecordRefProdnRouting");
    }

    @Override
    @Nonnull
    public ChangeRecordRefProdnRoutingByKeyFluentHelper getChangeRecordRefProdnRoutingByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChangeRecordRefProdnRoutingByKeyFluentHelper(
            servicePath,
            "A_ChangeRecordRefProdnRouting",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChangeRecordRefProdnRoutingCreateFluentHelper createChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return new ChangeRecordRefProdnRoutingCreateFluentHelper(
            servicePath,
            changeRecordRefProdnRouting,
            "A_ChangeRecordRefProdnRouting");
    }

    @Override
    @Nonnull
    public ChangeRecordRefProdnRoutingUpdateFluentHelper updateChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return new ChangeRecordRefProdnRoutingUpdateFluentHelper(
            servicePath,
            changeRecordRefProdnRouting,
            "A_ChangeRecordRefProdnRouting");
    }

    @Override
    @Nonnull
    public ChangeRecordRefProdnRoutingDeleteFluentHelper deleteChangeRecordRefProdnRouting(
        @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting )
    {
        return new ChangeRecordRefProdnRoutingDeleteFluentHelper(
            servicePath,
            changeRecordRefProdnRouting,
            "A_ChangeRecordRefProdnRouting");
    }

    @Override
    @Nonnull
    public ChgRecdEquipBOMFluentHelper getAllChgRecdEquipBOM()
    {
        return new ChgRecdEquipBOMFluentHelper(servicePath, "A_ChgRecdEquipBOM");
    }

    @Override
    @Nonnull
    public ChgRecdEquipBOMByKeyFluentHelper getChgRecdEquipBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdEquipBOMByKeyFluentHelper(servicePath, "A_ChgRecdEquipBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdEquipBOMCreateFluentHelper createChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return new ChgRecdEquipBOMCreateFluentHelper(servicePath, chgRecdEquipBOM, "A_ChgRecdEquipBOM");
    }

    @Override
    @Nonnull
    public ChgRecdEquipBOMUpdateFluentHelper updateChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return new ChgRecdEquipBOMUpdateFluentHelper(servicePath, chgRecdEquipBOM, "A_ChgRecdEquipBOM");
    }

    @Override
    @Nonnull
    public ChgRecdEquipBOMDeleteFluentHelper deleteChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM )
    {
        return new ChgRecdEquipBOMDeleteFluentHelper(servicePath, chgRecdEquipBOM, "A_ChgRecdEquipBOM");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocBOMFluentHelper getAllChgRecdFuncLocBOM()
    {
        return new ChgRecdFuncLocBOMFluentHelper(servicePath, "A_ChgRecdFuncLocBOM");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocBOMByKeyFluentHelper getChgRecdFuncLocBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdFuncLocBOMByKeyFluentHelper(servicePath, "A_ChgRecdFuncLocBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocBOMCreateFluentHelper createChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return new ChgRecdFuncLocBOMCreateFluentHelper(servicePath, chgRecdFuncLocBOM, "A_ChgRecdFuncLocBOM");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocBOMUpdateFluentHelper updateChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return new ChgRecdFuncLocBOMUpdateFluentHelper(servicePath, chgRecdFuncLocBOM, "A_ChgRecdFuncLocBOM");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocBOMDeleteFluentHelper deleteChgRecdFuncLocBOM(
        @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM )
    {
        return new ChgRecdFuncLocBOMDeleteFluentHelper(servicePath, chgRecdFuncLocBOM, "A_ChgRecdFuncLocBOM");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocTskListFluentHelper getAllChgRecdFuncLocTskList()
    {
        return new ChgRecdFuncLocTskListFluentHelper(servicePath, "A_ChgRecdFuncLocTskList");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocTskListByKeyFluentHelper getChgRecdFuncLocTskListByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdFuncLocTskListByKeyFluentHelper(
            servicePath,
            "A_ChgRecdFuncLocTskList",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocTskListCreateFluentHelper createChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return new ChgRecdFuncLocTskListCreateFluentHelper(
            servicePath,
            chgRecdFuncLocTskList,
            "A_ChgRecdFuncLocTskList");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocTskListUpdateFluentHelper updateChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return new ChgRecdFuncLocTskListUpdateFluentHelper(
            servicePath,
            chgRecdFuncLocTskList,
            "A_ChgRecdFuncLocTskList");
    }

    @Override
    @Nonnull
    public ChgRecdFuncLocTskListDeleteFluentHelper deleteChgRecdFuncLocTskList(
        @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList )
    {
        return new ChgRecdFuncLocTskListDeleteFluentHelper(
            servicePath,
            chgRecdFuncLocTskList,
            "A_ChgRecdFuncLocTskList");
    }

    @Override
    @Nonnull
    public ChgRecdObjPgMaintTskListFluentHelper getAllChgRecdObjPgMaintTskList()
    {
        return new ChgRecdObjPgMaintTskListFluentHelper(servicePath, "A_ChgRecdObjPgMaintTskList");
    }

    @Override
    @Nonnull
    public ChgRecdObjPgMaintTskListByKeyFluentHelper getChgRecdObjPgMaintTskListByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdObjPgMaintTskListByKeyFluentHelper(
            servicePath,
            "A_ChgRecdObjPgMaintTskList",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdObjPgMaintTskListCreateFluentHelper createChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return new ChgRecdObjPgMaintTskListCreateFluentHelper(
            servicePath,
            chgRecdObjPgMaintTskList,
            "A_ChgRecdObjPgMaintTskList");
    }

    @Override
    @Nonnull
    public ChgRecdObjPgMaintTskListUpdateFluentHelper updateChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return new ChgRecdObjPgMaintTskListUpdateFluentHelper(
            servicePath,
            chgRecdObjPgMaintTskList,
            "A_ChgRecdObjPgMaintTskList");
    }

    @Override
    @Nonnull
    public ChgRecdObjPgMaintTskListDeleteFluentHelper deleteChgRecdObjPgMaintTskList(
        @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList )
    {
        return new ChgRecdObjPgMaintTskListDeleteFluentHelper(
            servicePath,
            chgRecdObjPgMaintTskList,
            "A_ChgRecdObjPgMaintTskList");
    }

    @Override
    @Nonnull
    public ChgRecdPLMEPDCollabnFluentHelper getAllChgRecdPLMEPDCollabn()
    {
        return new ChgRecdPLMEPDCollabnFluentHelper(servicePath, "A_ChgRecdPLMEPDCollabn");
    }

    @Override
    @Nonnull
    public
        ChgRecdPLMEPDCollabnByKeyFluentHelper
        getChgRecdPLMEPDCollabnByKey( final UUID chgRecdPLMEPDCollabnUUID, final UUID changeRecordUUID )
    {
        return new ChgRecdPLMEPDCollabnByKeyFluentHelper(
            servicePath,
            "A_ChgRecdPLMEPDCollabn",
            chgRecdPLMEPDCollabnUUID,
            changeRecordUUID);
    }

    @Override
    @Nonnull
    public ChgRecdPLMEPDCollabnCreateFluentHelper createChgRecdPLMEPDCollabn(
        @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn )
    {
        return new ChgRecdPLMEPDCollabnCreateFluentHelper(servicePath, chgRecdPLMEPDCollabn, "A_ChgRecdPLMEPDCollabn");
    }

    @Override
    @Nonnull
    public ChgRecdPLMEPDCollabnDeleteFluentHelper deleteChgRecdPLMEPDCollabn(
        @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn )
    {
        return new ChgRecdPLMEPDCollabnDeleteFluentHelper(servicePath, chgRecdPLMEPDCollabn, "A_ChgRecdPLMEPDCollabn");
    }

    @Override
    @Nonnull
    public ChgRecdRefEngBOMFluentHelper getAllChgRecdRefEngBOM()
    {
        return new ChgRecdRefEngBOMFluentHelper(servicePath, "A_ChgRecdRefEngBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefEngBOMByKeyFluentHelper getChgRecdRefEngBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdRefEngBOMByKeyFluentHelper(servicePath, "A_ChgRecdRefEngBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdRefEngBOMCreateFluentHelper createChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return new ChgRecdRefEngBOMCreateFluentHelper(servicePath, chgRecdRefEngBOM, "A_ChgRecdRefEngBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefEngBOMUpdateFluentHelper updateChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return new ChgRecdRefEngBOMUpdateFluentHelper(servicePath, chgRecdRefEngBOM, "A_ChgRecdRefEngBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefEngBOMDeleteFluentHelper deleteChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM )
    {
        return new ChgRecdRefEngBOMDeleteFluentHelper(servicePath, chgRecdRefEngBOM, "A_ChgRecdRefEngBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefEquipTskListFluentHelper getAllChgRecdRefEquipTskList()
    {
        return new ChgRecdRefEquipTskListFluentHelper(servicePath, "A_ChgRecdRefEquipTskList");
    }

    @Override
    @Nonnull
    public ChgRecdRefEquipTskListByKeyFluentHelper getChgRecdRefEquipTskListByKey(
        final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdRefEquipTskListByKeyFluentHelper(
            servicePath,
            "A_ChgRecdRefEquipTskList",
            changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdRefEquipTskListCreateFluentHelper createChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return new ChgRecdRefEquipTskListCreateFluentHelper(
            servicePath,
            chgRecdRefEquipTskList,
            "A_ChgRecdRefEquipTskList");
    }

    @Override
    @Nonnull
    public ChgRecdRefEquipTskListUpdateFluentHelper updateChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return new ChgRecdRefEquipTskListUpdateFluentHelper(
            servicePath,
            chgRecdRefEquipTskList,
            "A_ChgRecdRefEquipTskList");
    }

    @Override
    @Nonnull
    public ChgRecdRefEquipTskListDeleteFluentHelper deleteChgRecdRefEquipTskList(
        @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList )
    {
        return new ChgRecdRefEquipTskListDeleteFluentHelper(
            servicePath,
            chgRecdRefEquipTskList,
            "A_ChgRecdRefEquipTskList");
    }

    @Override
    @Nonnull
    public ChgRecdRefMfgBOMFluentHelper getAllChgRecdRefMfgBOM()
    {
        return new ChgRecdRefMfgBOMFluentHelper(servicePath, "A_ChgRecdRefMfgBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefMfgBOMByKeyFluentHelper getChgRecdRefMfgBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdRefMfgBOMByKeyFluentHelper(servicePath, "A_ChgRecdRefMfgBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdRefMfgBOMCreateFluentHelper createChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return new ChgRecdRefMfgBOMCreateFluentHelper(servicePath, chgRecdRefMfgBOM, "A_ChgRecdRefMfgBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefMfgBOMUpdateFluentHelper updateChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return new ChgRecdRefMfgBOMUpdateFluentHelper(servicePath, chgRecdRefMfgBOM, "A_ChgRecdRefMfgBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefMfgBOMDeleteFluentHelper deleteChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM )
    {
        return new ChgRecdRefMfgBOMDeleteFluentHelper(servicePath, chgRecdRefMfgBOM, "A_ChgRecdRefMfgBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefStdBOMFluentHelper getAllChgRecdRefStdBOM()
    {
        return new ChgRecdRefStdBOMFluentHelper(servicePath, "A_ChgRecdRefStdBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefStdBOMByKeyFluentHelper getChgRecdRefStdBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdRefStdBOMByKeyFluentHelper(servicePath, "A_ChgRecdRefStdBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdRefStdBOMCreateFluentHelper createChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return new ChgRecdRefStdBOMCreateFluentHelper(servicePath, chgRecdRefStdBOM, "A_ChgRecdRefStdBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefStdBOMUpdateFluentHelper updateChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return new ChgRecdRefStdBOMUpdateFluentHelper(servicePath, chgRecdRefStdBOM, "A_ChgRecdRefStdBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefStdBOMDeleteFluentHelper deleteChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM )
    {
        return new ChgRecdRefStdBOMDeleteFluentHelper(servicePath, chgRecdRefStdBOM, "A_ChgRecdRefStdBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefVarBOMFluentHelper getAllChgRecdRefVarBOM()
    {
        return new ChgRecdRefVarBOMFluentHelper(servicePath, "A_ChgRecdRefVarBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefVarBOMByKeyFluentHelper getChgRecdRefVarBOMByKey( final UUID changeRecordReferenceUUID )
    {
        return new ChgRecdRefVarBOMByKeyFluentHelper(servicePath, "A_ChgRecdRefVarBOM", changeRecordReferenceUUID);
    }

    @Override
    @Nonnull
    public ChgRecdRefVarBOMCreateFluentHelper createChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return new ChgRecdRefVarBOMCreateFluentHelper(servicePath, chgRecdRefVarBOM, "A_ChgRecdRefVarBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefVarBOMUpdateFluentHelper updateChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return new ChgRecdRefVarBOMUpdateFluentHelper(servicePath, chgRecdRefVarBOM, "A_ChgRecdRefVarBOM");
    }

    @Override
    @Nonnull
    public ChgRecdRefVarBOMDeleteFluentHelper deleteChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM )
    {
        return new ChgRecdRefVarBOMDeleteFluentHelper(servicePath, chgRecdRefVarBOM, "A_ChgRecdRefVarBOM");
    }

}
