/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.batch.DefaultCharacteristicAttributeCatalogServiceBatch;

/**
 * <p>
 *
 * The catalog data that is read with this service consists of plant-specific selected sets with their codes that are
 * used to record inspection results for qualitative characteristics, for example, the codes 01 (Smooth) and 02 (Rough)
 * for the characteristic ***Surface***..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/92/9751669aeb40f083215bf16c284c1a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHARCATTRIBUTECATALOG_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHARCATTRIBUTECATALOG_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Characteristic Attribute Selected Code Set</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCharacteristicAttributeCatalogService" )
@Deprecated
public class DefaultCharacteristicAttributeCatalogService implements CharacteristicAttributeCatalogService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CharacteristicAttributeCatalogService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCharacteristicAttributeCatalogService()
    {
        servicePath = CharacteristicAttributeCatalogService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCharacteristicAttributeCatalogService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCharacteristicAttributeCatalogService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCharacteristicAttributeCatalogService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCharacteristicAttributeCatalogServiceBatch batch()
    {
        return new DefaultCharacteristicAttributeCatalogServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CharcAttribSeldCodeSetFluentHelper getAllCharcAttribSeldCodeSet()
    {
        return new CharcAttribSeldCodeSetFluentHelper(servicePath, "A_CharcAttribSeldCodeSet");
    }

    @Override
    @Nonnull
    public
        CharcAttribSeldCodeSetByKeyFluentHelper
        getCharcAttribSeldCodeSetByKey( final String selectedCodeSetPlant, final String selectedCodeSet )
    {
        return new CharcAttribSeldCodeSetByKeyFluentHelper(
            servicePath,
            "A_CharcAttribSeldCodeSet",
            selectedCodeSetPlant,
            selectedCodeSet);
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetCodeFluentHelper getAllCharcAttribSeldSetCode()
    {
        return new CharcAttribSeldSetCodeFluentHelper(servicePath, "A_CharcAttribSeldSetCode");
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetCodeByKeyFluentHelper getCharcAttribSeldSetCodeByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode )
    {
        return new CharcAttribSeldSetCodeByKeyFluentHelper(
            servicePath,
            "A_CharcAttribSeldSetCode",
            selectedCodeSetPlant,
            selectedCodeSet,
            characteristicAttributeCodeGrp,
            characteristicAttributeCode);
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetCodeTFluentHelper getAllCharcAttribSeldSetCodeT()
    {
        return new CharcAttribSeldSetCodeTFluentHelper(servicePath, "A_CharcAttribSeldSetCodeT");
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetCodeTByKeyFluentHelper getCharcAttribSeldSetCodeTByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode,
        final String language )
    {
        return new CharcAttribSeldSetCodeTByKeyFluentHelper(
            servicePath,
            "A_CharcAttribSeldSetCodeT",
            selectedCodeSetPlant,
            selectedCodeSet,
            characteristicAttributeCodeGrp,
            characteristicAttributeCode,
            language);
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetTFluentHelper getAllCharcAttribSeldSetT()
    {
        return new CharcAttribSeldSetTFluentHelper(servicePath, "A_CharcAttribSeldSetT");
    }

    @Override
    @Nonnull
    public CharcAttribSeldSetTByKeyFluentHelper getCharcAttribSeldSetTByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String language )
    {
        return new CharcAttribSeldSetTByKeyFluentHelper(
            servicePath,
            "A_CharcAttribSeldSetT",
            selectedCodeSetPlant,
            selectedCodeSet,
            language);
    }

}
