/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.batch.DefaultCharacteristicDataForClassificationServiceBatch;

/**
 * <p>
 * Characteristics describe attributes of the objects to be classified. Using the API you can maintain characteristic
 * header data, descriptions, references, restrictions and values.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5c/3fb6b558b1482491fd786ec7fa0c26/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_CHARACTERISTIC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_CHARACTERISTIC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Classification Systems OData/SOAP Integration(SAP_COM_0163), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Classification Characteristic</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCharacteristicDataForClassificationService" )
@Deprecated
public class DefaultCharacteristicDataForClassificationService implements CharacteristicDataForClassificationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CharacteristicDataForClassificationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultCharacteristicDataForClassificationService()
    {
        servicePath = CharacteristicDataForClassificationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCharacteristicDataForClassificationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCharacteristicDataForClassificationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCharacteristicDataForClassificationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCharacteristicDataForClassificationServiceBatch batch()
    {
        return new DefaultCharacteristicDataForClassificationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ClfnCharacteristicForKeyDateFluentHelper getAllClfnCharacteristicForKeyDate()
    {
        return new ClfnCharacteristicForKeyDateFluentHelper(servicePath, "A_ClfnCharacteristicForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharacteristicForKeyDateByKeyFluentHelper getClfnCharacteristicForKeyDateByKey(
        final String charcInternalID )
    {
        return new ClfnCharacteristicForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharacteristicForKeyDate",
            charcInternalID);
    }

    @Override
    @Nonnull
    public ClfnCharacteristicForKeyDateCreateFluentHelper createClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return new ClfnCharacteristicForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharacteristicForKeyDate,
            "A_ClfnCharacteristicForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharacteristicForKeyDateUpdateFluentHelper updateClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return new ClfnCharacteristicForKeyDateUpdateFluentHelper(
            servicePath,
            clfnCharacteristicForKeyDate,
            "A_ClfnCharacteristicForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharacteristicForKeyDateDeleteFluentHelper deleteClfnCharacteristicForKeyDate(
        @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate )
    {
        return new ClfnCharacteristicForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharacteristicForKeyDate,
            "A_ClfnCharacteristicForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcDescForKeyDateFluentHelper getAllClfnCharcDescForKeyDate()
    {
        return new ClfnCharcDescForKeyDateFluentHelper(servicePath, "A_ClfnCharcDescForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnCharcDescForKeyDateByKeyFluentHelper
        getClfnCharcDescForKeyDateByKey( final String charcInternalID, final String language )
    {
        return new ClfnCharcDescForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharcDescForKeyDate",
            charcInternalID,
            language);
    }

    @Override
    @Nonnull
    public ClfnCharcDescForKeyDateCreateFluentHelper createClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return new ClfnCharcDescForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharcDescForKeyDate,
            "A_ClfnCharcDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcDescForKeyDateUpdateFluentHelper updateClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return new ClfnCharcDescForKeyDateUpdateFluentHelper(
            servicePath,
            clfnCharcDescForKeyDate,
            "A_ClfnCharcDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcDescForKeyDateDeleteFluentHelper deleteClfnCharcDescForKeyDate(
        @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate )
    {
        return new ClfnCharcDescForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharcDescForKeyDate,
            "A_ClfnCharcDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcRefForKeyDateFluentHelper getAllClfnCharcRefForKeyDate()
    {
        return new ClfnCharcRefForKeyDateFluentHelper(servicePath, "A_ClfnCharcRefForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcRefForKeyDateByKeyFluentHelper getClfnCharcRefForKeyDateByKey(
        final String charcInternalID,
        final String charcReferenceTable,
        final String charcReferenceTableField )
    {
        return new ClfnCharcRefForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharcRefForKeyDate",
            charcInternalID,
            charcReferenceTable,
            charcReferenceTableField);
    }

    @Override
    @Nonnull
    public ClfnCharcRefForKeyDateCreateFluentHelper createClfnCharcRefForKeyDate(
        @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate )
    {
        return new ClfnCharcRefForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharcRefForKeyDate,
            "A_ClfnCharcRefForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcRefForKeyDateDeleteFluentHelper deleteClfnCharcRefForKeyDate(
        @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate )
    {
        return new ClfnCharcRefForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharcRefForKeyDate,
            "A_ClfnCharcRefForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcRstrcnForKeyDateFluentHelper getAllClfnCharcRstrcnForKeyDate()
    {
        return new ClfnCharcRstrcnForKeyDateFluentHelper(servicePath, "A_ClfnCharcRstrcnForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnCharcRstrcnForKeyDateByKeyFluentHelper
        getClfnCharcRstrcnForKeyDateByKey( final String charcInternalID, final String classType )
    {
        return new ClfnCharcRstrcnForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharcRstrcnForKeyDate",
            charcInternalID,
            classType);
    }

    @Override
    @Nonnull
    public ClfnCharcRstrcnForKeyDateCreateFluentHelper createClfnCharcRstrcnForKeyDate(
        @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate )
    {
        return new ClfnCharcRstrcnForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharcRstrcnForKeyDate,
            "A_ClfnCharcRstrcnForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcRstrcnForKeyDateDeleteFluentHelper deleteClfnCharcRstrcnForKeyDate(
        @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate )
    {
        return new ClfnCharcRstrcnForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharcRstrcnForKeyDate,
            "A_ClfnCharcRstrcnForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueDescForKeyDateFluentHelper getAllClfnCharcValueDescForKeyDate()
    {
        return new ClfnCharcValueDescForKeyDateFluentHelper(servicePath, "A_ClfnCharcValueDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueDescForKeyDateByKeyFluentHelper getClfnCharcValueDescForKeyDateByKey(
        final String charcInternalID,
        final String charcValuePositionNumber,
        final String language )
    {
        return new ClfnCharcValueDescForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharcValueDescForKeyDate",
            charcInternalID,
            charcValuePositionNumber,
            language);
    }

    @Override
    @Nonnull
    public ClfnCharcValueDescForKeyDateCreateFluentHelper createClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return new ClfnCharcValueDescForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharcValueDescForKeyDate,
            "A_ClfnCharcValueDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueDescForKeyDateUpdateFluentHelper updateClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return new ClfnCharcValueDescForKeyDateUpdateFluentHelper(
            servicePath,
            clfnCharcValueDescForKeyDate,
            "A_ClfnCharcValueDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueDescForKeyDateDeleteFluentHelper deleteClfnCharcValueDescForKeyDate(
        @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate )
    {
        return new ClfnCharcValueDescForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharcValueDescForKeyDate,
            "A_ClfnCharcValueDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueForKeyDateFluentHelper getAllClfnCharcValueForKeyDate()
    {
        return new ClfnCharcValueForKeyDateFluentHelper(servicePath, "A_ClfnCharcValueForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnCharcValueForKeyDateByKeyFluentHelper
        getClfnCharcValueForKeyDateByKey( final String charcInternalID, final String charcValuePositionNumber )
    {
        return new ClfnCharcValueForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnCharcValueForKeyDate",
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public ClfnCharcValueForKeyDateCreateFluentHelper createClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return new ClfnCharcValueForKeyDateCreateFluentHelper(
            servicePath,
            clfnCharcValueForKeyDate,
            "A_ClfnCharcValueForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueForKeyDateUpdateFluentHelper updateClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return new ClfnCharcValueForKeyDateUpdateFluentHelper(
            servicePath,
            clfnCharcValueForKeyDate,
            "A_ClfnCharcValueForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnCharcValueForKeyDateDeleteFluentHelper deleteClfnCharcValueForKeyDate(
        @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate )
    {
        return new ClfnCharcValueForKeyDateDeleteFluentHelper(
            servicePath,
            clfnCharcValueForKeyDate,
            "A_ClfnCharcValueForKeyDate");
    }

}
