/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.batch.DefaultChartOfAccountsServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve chart of accounts and their names in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/50/e66ad51f064c23aceb9513891663ef/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHARTOFACCOUNTS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHARTOFACCOUNTS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax
 * Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultChartOfAccountsService" )
@Deprecated
public class DefaultChartOfAccountsService implements ChartOfAccountsService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ChartOfAccountsService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultChartOfAccountsService()
    {
        servicePath = ChartOfAccountsService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultChartOfAccountsService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultChartOfAccountsService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultChartOfAccountsService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultChartOfAccountsServiceBatch batch()
    {
        return new DefaultChartOfAccountsServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ChartOfAccountsFluentHelper getAllChartOfAccounts()
    {
        return new ChartOfAccountsFluentHelper(servicePath, "A_ChartOfAccounts");
    }

    @Override
    @Nonnull
    public ChartOfAccountsByKeyFluentHelper getChartOfAccountsByKey( final String chartOfAccounts )
    {
        return new ChartOfAccountsByKeyFluentHelper(servicePath, "A_ChartOfAccounts", chartOfAccounts);
    }

    @Override
    @Nonnull
    public ChartOfAccountsTextFluentHelper getAllChartOfAccountsText()
    {
        return new ChartOfAccountsTextFluentHelper(servicePath, "A_ChartOfAccountsText");
    }

    @Override
    @Nonnull
    public
        ChartOfAccountsTextByKeyFluentHelper
        getChartOfAccountsTextByKey( final String chartOfAccounts, final String language )
    {
        return new ChartOfAccountsTextByKeyFluentHelper(
            servicePath,
            "A_ChartOfAccountsText",
            chartOfAccounts,
            language);
    }

}
