/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.batch.DefaultClassDataForClassificationServiceBatch;

/**
 * <p>
 * Classes allow you to group objects together according to criteria that you define. Using the API you can maintain
 * class header data, descriptions, keywords, texts and characteristic assignments.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b4/14e320706a4071adec31121ef1f3c1/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_CLASS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_CLASS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Classification Systems OData/SOAP Integration(SAP_COM_0163), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Classification Class</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultClassDataForClassificationService" )
@Deprecated
public class DefaultClassDataForClassificationService implements ClassDataForClassificationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ClassDataForClassificationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultClassDataForClassificationService()
    {
        servicePath = ClassDataForClassificationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultClassDataForClassificationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultClassDataForClassificationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultClassDataForClassificationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultClassDataForClassificationServiceBatch batch()
    {
        return new DefaultClassDataForClassificationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ClfnClassCharcForKeyDateFluentHelper getAllClfnClassCharcForKeyDate()
    {
        return new ClfnClassCharcForKeyDateFluentHelper(servicePath, "A_ClfnClassCharcForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnClassCharcForKeyDateByKeyFluentHelper
        getClfnClassCharcForKeyDateByKey( final String classInternalID, final String charcInternalID )
    {
        return new ClfnClassCharcForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnClassCharcForKeyDate",
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public ClfnClassCharcForKeyDateCreateFluentHelper createClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return new ClfnClassCharcForKeyDateCreateFluentHelper(
            servicePath,
            clfnClassCharcForKeyDate,
            "A_ClfnClassCharcForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassCharcForKeyDateUpdateFluentHelper updateClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return new ClfnClassCharcForKeyDateUpdateFluentHelper(
            servicePath,
            clfnClassCharcForKeyDate,
            "A_ClfnClassCharcForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassCharcForKeyDateDeleteFluentHelper deleteClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return new ClfnClassCharcForKeyDateDeleteFluentHelper(
            servicePath,
            clfnClassCharcForKeyDate,
            "A_ClfnClassCharcForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassDescForKeyDateFluentHelper getAllClfnClassDescForKeyDate()
    {
        return new ClfnClassDescForKeyDateFluentHelper(servicePath, "A_ClfnClassDescForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnClassDescForKeyDateByKeyFluentHelper
        getClfnClassDescForKeyDateByKey( final String classInternalID, final String language )
    {
        return new ClfnClassDescForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnClassDescForKeyDate",
            classInternalID,
            language);
    }

    @Override
    @Nonnull
    public ClfnClassDescForKeyDateCreateFluentHelper createClfnClassDescForKeyDate(
        @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate )
    {
        return new ClfnClassDescForKeyDateCreateFluentHelper(
            servicePath,
            clfnClassDescForKeyDate,
            "A_ClfnClassDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassDescForKeyDateUpdateFluentHelper updateClfnClassDescForKeyDate(
        @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate )
    {
        return new ClfnClassDescForKeyDateUpdateFluentHelper(
            servicePath,
            clfnClassDescForKeyDate,
            "A_ClfnClassDescForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateFluentHelper getAllClfnClassForKeyDate()
    {
        return new ClfnClassForKeyDateFluentHelper(servicePath, "A_ClfnClassForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateByKeyFluentHelper getClfnClassForKeyDateByKey( final String classInternalID )
    {
        return new ClfnClassForKeyDateByKeyFluentHelper(servicePath, "A_ClfnClassForKeyDate", classInternalID);
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateCreateFluentHelper createClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return new ClfnClassForKeyDateCreateFluentHelper(servicePath, clfnClassForKeyDate, "A_ClfnClassForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateUpdateFluentHelper updateClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return new ClfnClassForKeyDateUpdateFluentHelper(servicePath, clfnClassForKeyDate, "A_ClfnClassForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateDeleteFluentHelper deleteClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return new ClfnClassForKeyDateDeleteFluentHelper(servicePath, clfnClassForKeyDate, "A_ClfnClassForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassKeywordForKeyDateFluentHelper getAllClfnClassKeywordForKeyDate()
    {
        return new ClfnClassKeywordForKeyDateFluentHelper(servicePath, "A_ClfnClassKeywordForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassKeywordForKeyDateByKeyFluentHelper getClfnClassKeywordForKeyDateByKey(
        final String classInternalID,
        final String language,
        final String classKeywordPositionNumber )
    {
        return new ClfnClassKeywordForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnClassKeywordForKeyDate",
            classInternalID,
            language,
            classKeywordPositionNumber);
    }

    @Override
    @Nonnull
    public ClfnClassKeywordForKeyDateCreateFluentHelper createClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return new ClfnClassKeywordForKeyDateCreateFluentHelper(
            servicePath,
            clfnClassKeywordForKeyDate,
            "A_ClfnClassKeywordForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassKeywordForKeyDateUpdateFluentHelper updateClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return new ClfnClassKeywordForKeyDateUpdateFluentHelper(
            servicePath,
            clfnClassKeywordForKeyDate,
            "A_ClfnClassKeywordForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassKeywordForKeyDateDeleteFluentHelper deleteClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return new ClfnClassKeywordForKeyDateDeleteFluentHelper(
            servicePath,
            clfnClassKeywordForKeyDate,
            "A_ClfnClassKeywordForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassTextForKeyDateFluentHelper getAllClfnClassTextForKeyDate()
    {
        return new ClfnClassTextForKeyDateFluentHelper(servicePath, "A_ClfnClassTextForKeyDate");
    }

    @Override
    @Nonnull
    public
        ClfnClassTextForKeyDateByKeyFluentHelper
        getClfnClassTextForKeyDateByKey( final String classInternalID, final String language, final String longTextID )
    {
        return new ClfnClassTextForKeyDateByKeyFluentHelper(
            servicePath,
            "A_ClfnClassTextForKeyDate",
            classInternalID,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public ClfnClassTextForKeyDateCreateFluentHelper createClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return new ClfnClassTextForKeyDateCreateFluentHelper(
            servicePath,
            clfnClassTextForKeyDate,
            "A_ClfnClassTextForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassTextForKeyDateUpdateFluentHelper updateClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return new ClfnClassTextForKeyDateUpdateFluentHelper(
            servicePath,
            clfnClassTextForKeyDate,
            "A_ClfnClassTextForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassTextForKeyDateDeleteFluentHelper deleteClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return new ClfnClassTextForKeyDateDeleteFluentHelper(
            servicePath,
            clfnClassTextForKeyDate,
            "A_ClfnClassTextForKeyDate");
    }

}
