/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.batch.DefaultCommercialProjectDetailServiceBatch;

/**
 * <p>
 *
 * The service provides header and detail-level information about customer and internal projects. It can be used as a
 * data provider to integrate third-party tools or applications for business processes such as resource management,
 * staffing, or time recording..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2b/23f2577840bd12e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/_CPD_SC_EXTERNAL_SERVICES_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>_CPD_SC_EXTERNAL_SERVICES_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Commercial Project Integration(SAP_COM_0054)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based
 * Services(J11)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Commercial Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCommercialProjectDetailService" )
@Deprecated
public class DefaultCommercialProjectDetailService implements CommercialProjectDetailService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CommercialProjectDetailService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCommercialProjectDetailService()
    {
        servicePath = CommercialProjectDetailService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCommercialProjectDetailService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCommercialProjectDetailService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCommercialProjectDetailService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCommercialProjectDetailServiceBatch batch()
    {
        return new DefaultCommercialProjectDetailServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProjectFluentHelper getAllProject()
    {
        return new ProjectFluentHelper(servicePath, "ProjectSet");
    }

    @Override
    @Nonnull
    public ProjectByKeyFluentHelper getProjectByKey( final String projectID )
    {
        return new ProjectByKeyFluentHelper(servicePath, "ProjectSet", projectID);
    }

    @Override
    @Nonnull
    public WorkpackageFluentHelper getAllWorkpackage()
    {
        return new WorkpackageFluentHelper(servicePath, "WorkpackageSet");
    }

    @Override
    @Nonnull
    public WorkpackageByKeyFluentHelper getWorkpackageByKey( final String workPackageID )
    {
        return new WorkpackageByKeyFluentHelper(servicePath, "WorkpackageSet", workPackageID);
    }

    @Override
    @Nonnull
    public PlanDataFluentHelper getAllPlanData()
    {
        return new PlanDataFluentHelper(servicePath, "PlanDataSet");
    }

    @Override
    @Nonnull
    public PlanDataByKeyFluentHelper getPlanDataByKey(
        final String projectID,
        final String resType,
        final String workPackageID,
        final String resourceId,
        final String version,
        final String employee,
        final String confirmed,
        final String workitemId,
        final String delvryServOrg )
    {
        return new PlanDataByKeyFluentHelper(
            servicePath,
            "PlanDataSet",
            projectID,
            resType,
            workPackageID,
            resourceId,
            version,
            employee,
            confirmed,
            workitemId,
            delvryServOrg);
    }

    @Override
    @Nonnull
    public WorkItemFluentHelper getAllWorkItem()
    {
        return new WorkItemFluentHelper(servicePath, "WorkItemSet");
    }

    @Override
    @Nonnull
    public WorkItemByKeyFluentHelper getWorkItemByKey( final String workitem, final String workpackageID )
    {
        return new WorkItemByKeyFluentHelper(servicePath, "WorkItemSet", workitem, workpackageID);
    }

    @Override
    @Nonnull
    public ProjectRoleFluentHelper getAllProjectRole()
    {
        return new ProjectRoleFluentHelper(servicePath, "ProjectRoleSet");
    }

    @Override
    @Nonnull
    public ProjectRoleByKeyFluentHelper getProjectRoleByKey( final String projectID, final String projectRoleID )
    {
        return new ProjectRoleByKeyFluentHelper(servicePath, "ProjectRoleSet", projectID, projectRoleID);
    }

    @Override
    @Nonnull
    public StaffingDataFluentHelper getAllStaffingData()
    {
        return new StaffingDataFluentHelper(servicePath, "StaffingDataSet");
    }

    @Override
    @Nonnull
    public StaffingDataByKeyFluentHelper getStaffingDataByKey(
        final String projectID,
        final String workPackageID,
        final String resType,
        final String resourceId,
        final String workitemId )
    {
        return new StaffingDataByKeyFluentHelper(
            servicePath,
            "StaffingDataSet",
            projectID,
            workPackageID,
            resType,
            resourceId,
            workitemId);
    }

    @Override
    @Nonnull
    public WorkPackageFunctionFluentHelper getAllWorkPackageFunction()
    {
        return new WorkPackageFunctionFluentHelper(servicePath, "WorkPackageFunctionSet");
    }

    @Override
    @Nonnull
    public WorkPackageFunctionByKeyFluentHelper getWorkPackageFunctionByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageFunctionId )
    {
        return new WorkPackageFunctionByKeyFluentHelper(
            servicePath,
            "WorkPackageFunctionSet",
            projectID,
            workPackageID,
            workPackageFunctionId);
    }

}
