/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.UpdateCustProjSlsOrdItemMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.batch.DefaultCommercialProjectServiceBatch;

/**
 * <p>
 *
 * The service enables you to do the following: - Create and manage customer and internal projects - Manage work
 * packages and work items - Plan resources and expenses in work packages - Staff resources to work packages - Create,
 * read, and update sales orders for your customer projects.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/6dc4ab5f854c92863a2f8a248b061b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/_CPD_SC_PROJ_ENGMT_CREATE_UPD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>_CPD_SC_PROJ_ENGMT_CREATE_UPD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Commercial Project Integration(SAP_COM_0054)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based
 * Services(J11)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Commercial Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCommercialProjectService" )
@Deprecated
public class DefaultCommercialProjectService implements CommercialProjectService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CommercialProjectService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCommercialProjectService()
    {
        servicePath = CommercialProjectService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCommercialProjectService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCommercialProjectService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCommercialProjectService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCommercialProjectServiceBatch batch()
    {
        return new DefaultCommercialProjectServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdFluentHelper getAllCustProjSlsOrd()
    {
        return new CustProjSlsOrdFluentHelper(servicePath, "A_CustProjSlsOrd");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdByKeyFluentHelper getCustProjSlsOrdByKey( final String customerProject )
    {
        return new CustProjSlsOrdByKeyFluentHelper(servicePath, "A_CustProjSlsOrd", customerProject);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdCreateFluentHelper createCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd )
    {
        return new CustProjSlsOrdCreateFluentHelper(servicePath, custProjSlsOrd, "A_CustProjSlsOrd");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdUpdateFluentHelper updateCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd )
    {
        return new CustProjSlsOrdUpdateFluentHelper(servicePath, custProjSlsOrd, "A_CustProjSlsOrd");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemFluentHelper getAllCustProjSlsOrdItem()
    {
        return new CustProjSlsOrdItemFluentHelper(servicePath, "A_CustProjSlsOrdItem");
    }

    @Override
    @Nonnull
    public
        CustProjSlsOrdItemByKeyFluentHelper
        getCustProjSlsOrdItemByKey( final String customerProject, final String salesOrderItem )
    {
        return new CustProjSlsOrdItemByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItem",
            customerProject,
            salesOrderItem);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemCreateFluentHelper createCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return new CustProjSlsOrdItemCreateFluentHelper(servicePath, custProjSlsOrdItem, "A_CustProjSlsOrdItem");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemUpdateFluentHelper updateCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return new CustProjSlsOrdItemUpdateFluentHelper(servicePath, custProjSlsOrdItem, "A_CustProjSlsOrdItem");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemDeleteFluentHelper deleteCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return new CustProjSlsOrdItemDeleteFluentHelper(servicePath, custProjSlsOrdItem, "A_CustProjSlsOrdItem");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemPartnerFluentHelper getAllCustProjSlsOrdItemPartner()
    {
        return new CustProjSlsOrdItemPartnerFluentHelper(servicePath, "A_CustProjSlsOrdItemPartner");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemPartnerByKeyFluentHelper getCustProjSlsOrdItemPartnerByKey(
        final String customerProject,
        final String partnerFunction,
        final String salesOrderItem )
    {
        return new CustProjSlsOrdItemPartnerByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItemPartner",
            customerProject,
            partnerFunction,
            salesOrderItem);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemPartnerCreateFluentHelper createCustProjSlsOrdItemPartner(
        @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner )
    {
        return new CustProjSlsOrdItemPartnerCreateFluentHelper(
            servicePath,
            custProjSlsOrdItemPartner,
            "A_CustProjSlsOrdItemPartner");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemPartnerUpdateFluentHelper updateCustProjSlsOrdItemPartner(
        @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner )
    {
        return new CustProjSlsOrdItemPartnerUpdateFluentHelper(
            servicePath,
            custProjSlsOrdItemPartner,
            "A_CustProjSlsOrdItemPartner");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemTextFluentHelper getAllCustProjSlsOrdItemText()
    {
        return new CustProjSlsOrdItemTextFluentHelper(servicePath, "A_CustProjSlsOrdItemText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemTextByKeyFluentHelper getCustProjSlsOrdItemTextByKey(
        final String customerProject,
        final String salesOrderItem,
        final String language,
        final String longTextID )
    {
        return new CustProjSlsOrdItemTextByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItemText",
            customerProject,
            salesOrderItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemTextCreateFluentHelper createCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return new CustProjSlsOrdItemTextCreateFluentHelper(
            servicePath,
            custProjSlsOrdItemText,
            "A_CustProjSlsOrdItemText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemTextUpdateFluentHelper updateCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return new CustProjSlsOrdItemTextUpdateFluentHelper(
            servicePath,
            custProjSlsOrdItemText,
            "A_CustProjSlsOrdItemText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemTextDeleteFluentHelper deleteCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return new CustProjSlsOrdItemTextDeleteFluentHelper(
            servicePath,
            custProjSlsOrdItemText,
            "A_CustProjSlsOrdItemText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemWorkPckgFluentHelper getAllCustProjSlsOrdItemWorkPckg()
    {
        return new CustProjSlsOrdItemWorkPckgFluentHelper(servicePath, "A_CustProjSlsOrdItemWorkPckg");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemWorkPckgByKeyFluentHelper getCustProjSlsOrdItemWorkPckgByKey(
        final String customerProject,
        final String salesOrderItem,
        final String workPackage )
    {
        return new CustProjSlsOrdItemWorkPckgByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItemWorkPckg",
            customerProject,
            salesOrderItem,
            workPackage);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemWorkPckgCreateFluentHelper createCustProjSlsOrdItemWorkPckg(
        @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg )
    {
        return new CustProjSlsOrdItemWorkPckgCreateFluentHelper(
            servicePath,
            custProjSlsOrdItemWorkPckg,
            "A_CustProjSlsOrdItemWorkPckg");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItemWorkPckgDeleteFluentHelper deleteCustProjSlsOrdItemWorkPckg(
        @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg )
    {
        return new CustProjSlsOrdItemWorkPckgDeleteFluentHelper(
            servicePath,
            custProjSlsOrdItemWorkPckg,
            "A_CustProjSlsOrdItemWorkPckg");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmBillgPlnItmFluentHelper getAllCustProjSlsOrdItmBillgPlnItm()
    {
        return new CustProjSlsOrdItmBillgPlnItmFluentHelper(servicePath, "A_CustProjSlsOrdItmBillgPlnItm");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper getCustProjSlsOrdItmBillgPlnItmByKey(
        final String customerProject,
        final String salesOrderItem,
        final String billingPlanItem )
    {
        return new CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItmBillgPlnItm",
            customerProject,
            salesOrderItem,
            billingPlanItem);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmBillgPlnItmCreateFluentHelper createCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return new CustProjSlsOrdItmBillgPlnItmCreateFluentHelper(
            servicePath,
            custProjSlsOrdItmBillgPlnItm,
            "A_CustProjSlsOrdItmBillgPlnItm");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper updateCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return new CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper(
            servicePath,
            custProjSlsOrdItmBillgPlnItm,
            "A_CustProjSlsOrdItmBillgPlnItm");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper deleteCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return new CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper(
            servicePath,
            custProjSlsOrdItmBillgPlnItm,
            "A_CustProjSlsOrdItmBillgPlnItm");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmPrcgElementFluentHelper getAllCustProjSlsOrdItmPrcgElement()
    {
        return new CustProjSlsOrdItmPrcgElementFluentHelper(servicePath, "A_CustProjSlsOrdItmPrcgElement");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdItmPrcgElementByKeyFluentHelper getCustProjSlsOrdItmPrcgElementByKey(
        final String customerProject,
        final String salesOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new CustProjSlsOrdItmPrcgElementByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdItmPrcgElement",
            customerProject,
            salesOrderItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdPartnerFluentHelper getAllCustProjSlsOrdPartner()
    {
        return new CustProjSlsOrdPartnerFluentHelper(servicePath, "A_CustProjSlsOrdPartner");
    }

    @Override
    @Nonnull
    public
        CustProjSlsOrdPartnerByKeyFluentHelper
        getCustProjSlsOrdPartnerByKey( final String customerProject, final String partnerFunction )
    {
        return new CustProjSlsOrdPartnerByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdPartner",
            customerProject,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdPartnerCreateFluentHelper createCustProjSlsOrdPartner(
        @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner )
    {
        return new CustProjSlsOrdPartnerCreateFluentHelper(
            servicePath,
            custProjSlsOrdPartner,
            "A_CustProjSlsOrdPartner");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdPartnerUpdateFluentHelper updateCustProjSlsOrdPartner(
        @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner )
    {
        return new CustProjSlsOrdPartnerUpdateFluentHelper(
            servicePath,
            custProjSlsOrdPartner,
            "A_CustProjSlsOrdPartner");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdTextFluentHelper getAllCustProjSlsOrdText()
    {
        return new CustProjSlsOrdTextFluentHelper(servicePath, "A_CustProjSlsOrdText");
    }

    @Override
    @Nonnull
    public
        CustProjSlsOrdTextByKeyFluentHelper
        getCustProjSlsOrdTextByKey( final String customerProject, final String language, final String longTextID )
    {
        return new CustProjSlsOrdTextByKeyFluentHelper(
            servicePath,
            "A_CustProjSlsOrdText",
            customerProject,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustProjSlsOrdTextCreateFluentHelper createCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return new CustProjSlsOrdTextCreateFluentHelper(servicePath, custProjSlsOrdText, "A_CustProjSlsOrdText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdTextUpdateFluentHelper updateCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return new CustProjSlsOrdTextUpdateFluentHelper(servicePath, custProjSlsOrdText, "A_CustProjSlsOrdText");
    }

    @Override
    @Nonnull
    public CustProjSlsOrdTextDeleteFluentHelper deleteCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return new CustProjSlsOrdTextDeleteFluentHelper(servicePath, custProjSlsOrdText, "A_CustProjSlsOrdText");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndFluentHelper getAllEngmntProjRsceDmnd()
    {
        return new EngmntProjRsceDmndFluentHelper(servicePath, "A_EngmntProjRsceDmnd");
    }

    @Override
    @Nonnull
    public
        EngmntProjRsceDmndByKeyFluentHelper
        getEngmntProjRsceDmndByKey( final String workPackage, final String resourceDemand, final String version )
    {
        return new EngmntProjRsceDmndByKeyFluentHelper(
            servicePath,
            "A_EngmntProjRsceDmnd",
            workPackage,
            resourceDemand,
            version);
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndCreateFluentHelper createEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return new EngmntProjRsceDmndCreateFluentHelper(servicePath, engmntProjRsceDmnd, "A_EngmntProjRsceDmnd");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndUpdateFluentHelper updateEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return new EngmntProjRsceDmndUpdateFluentHelper(servicePath, engmntProjRsceDmnd, "A_EngmntProjRsceDmnd");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDeleteFluentHelper deleteEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return new EngmntProjRsceDmndDeleteFluentHelper(servicePath, engmntProjRsceDmnd, "A_EngmntProjRsceDmnd");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDistrFluentHelper getAllEngmntProjRsceDmndDistr()
    {
        return new EngmntProjRsceDmndDistrFluentHelper(servicePath, "A_EngmntProjRsceDmndDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDistrByKeyFluentHelper getEngmntProjRsceDmndDistrByKey(
        final String workPackage,
        final String resourceDemand,
        final String version,
        final String calendarMonth,
        final String calendarYear )
    {
        return new EngmntProjRsceDmndDistrByKeyFluentHelper(
            servicePath,
            "A_EngmntProjRsceDmndDistr",
            workPackage,
            resourceDemand,
            version,
            calendarMonth,
            calendarYear);
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDistrCreateFluentHelper createEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return new EngmntProjRsceDmndDistrCreateFluentHelper(
            servicePath,
            engmntProjRsceDmndDistr,
            "A_EngmntProjRsceDmndDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDistrUpdateFluentHelper updateEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return new EngmntProjRsceDmndDistrUpdateFluentHelper(
            servicePath,
            engmntProjRsceDmndDistr,
            "A_EngmntProjRsceDmndDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndDistrDeleteFluentHelper deleteEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return new EngmntProjRsceDmndDistrDeleteFluentHelper(
            servicePath,
            engmntProjRsceDmndDistr,
            "A_EngmntProjRsceDmndDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceDmndSkillFluentHelper getAllEngmntProjRsceDmndSkill()
    {
        return new EngmntProjRsceDmndSkillFluentHelper(servicePath, "A_EngmntProjRsceDmndSkill");
    }

    @Override
    @Nonnull
    public
        EngmntProjRsceDmndSkillByKeyFluentHelper
        getEngmntProjRsceDmndSkillByKey( final String workPackage, final String resourceDemand, final String version )
    {
        return new EngmntProjRsceDmndSkillByKeyFluentHelper(
            servicePath,
            "A_EngmntProjRsceDmndSkill",
            workPackage,
            resourceDemand,
            version);
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupFluentHelper getAllEngmntProjRsceSup()
    {
        return new EngmntProjRsceSupFluentHelper(servicePath, "A_EngmntProjRsceSup");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupByKeyFluentHelper getEngmntProjRsceSupByKey(
        final String workPackage,
        final String resourceDemand,
        final String resourceSupply,
        final String version )
    {
        return new EngmntProjRsceSupByKeyFluentHelper(
            servicePath,
            "A_EngmntProjRsceSup",
            workPackage,
            resourceDemand,
            resourceSupply,
            version);
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupCreateFluentHelper createEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return new EngmntProjRsceSupCreateFluentHelper(servicePath, engmntProjRsceSup, "A_EngmntProjRsceSup");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupUpdateFluentHelper updateEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return new EngmntProjRsceSupUpdateFluentHelper(servicePath, engmntProjRsceSup, "A_EngmntProjRsceSup");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDeleteFluentHelper deleteEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return new EngmntProjRsceSupDeleteFluentHelper(servicePath, engmntProjRsceSup, "A_EngmntProjRsceSup");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDistrFluentHelper getAllEngmntProjRsceSupDistr()
    {
        return new EngmntProjRsceSupDistrFluentHelper(servicePath, "A_EngmntProjRsceSupDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDistrByKeyFluentHelper getEngmntProjRsceSupDistrByKey(
        final String workPackage,
        final String resourceDemand,
        final String resourceSupply,
        final String version,
        final String calendarMonth,
        final String calendarYear )
    {
        return new EngmntProjRsceSupDistrByKeyFluentHelper(
            servicePath,
            "A_EngmntProjRsceSupDistr",
            workPackage,
            resourceDemand,
            resourceSupply,
            version,
            calendarMonth,
            calendarYear);
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDistrCreateFluentHelper createEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return new EngmntProjRsceSupDistrCreateFluentHelper(
            servicePath,
            engmntProjRsceSupDistr,
            "A_EngmntProjRsceSupDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDistrUpdateFluentHelper updateEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return new EngmntProjRsceSupDistrUpdateFluentHelper(
            servicePath,
            engmntProjRsceSupDistr,
            "A_EngmntProjRsceSupDistr");
    }

    @Override
    @Nonnull
    public EngmntProjRsceSupDistrDeleteFluentHelper deleteEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return new EngmntProjRsceSupDistrDeleteFluentHelper(
            servicePath,
            engmntProjRsceSupDistr,
            "A_EngmntProjRsceSupDistr");
    }

    @Override
    @Nonnull
    public WorkPackageFunctionFluentHelper getAllWorkPackageFunction()
    {
        return new WorkPackageFunctionFluentHelper(servicePath, "WorkPackageFunctionSet");
    }

    @Override
    @Nonnull
    public WorkPackageFunctionByKeyFluentHelper getWorkPackageFunctionByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String workPackageFunctionId )
    {
        return new WorkPackageFunctionByKeyFluentHelper(
            servicePath,
            "WorkPackageFunctionSet",
            projectID,
            workPackageID,
            workPackageName,
            workPackageFunctionId);
    }

    @Override
    @Nonnull
    public WorkPackageFunctionCreateFluentHelper createWorkPackageFunction(
        @Nonnull final WorkPackageFunction workPackageFunction )
    {
        return new WorkPackageFunctionCreateFluentHelper(servicePath, workPackageFunction, "WorkPackageFunctionSet");
    }

    @Override
    @Nonnull
    public WorkPackageFunctionUpdateFluentHelper updateWorkPackageFunction(
        @Nonnull final WorkPackageFunction workPackageFunction )
    {
        return new WorkPackageFunctionUpdateFluentHelper(servicePath, workPackageFunction, "WorkPackageFunctionSet");
    }

    @Override
    @Nonnull
    public ProjectFluentHelper getAllProject()
    {
        return new ProjectFluentHelper(servicePath, "ProjectSet");
    }

    @Override
    @Nonnull
    public ProjectByKeyFluentHelper getProjectByKey( final String projectID )
    {
        return new ProjectByKeyFluentHelper(servicePath, "ProjectSet", projectID);
    }

    @Override
    @Nonnull
    public ProjectCreateFluentHelper createProject( @Nonnull final Project project )
    {
        return new ProjectCreateFluentHelper(servicePath, project, "ProjectSet");
    }

    @Override
    @Nonnull
    public ProjectUpdateFluentHelper updateProject( @Nonnull final Project project )
    {
        return new ProjectUpdateFluentHelper(servicePath, project, "ProjectSet");
    }

    @Override
    @Nonnull
    public WorkPackageFluentHelper getAllWorkPackage()
    {
        return new WorkPackageFluentHelper(servicePath, "WorkPackageSet");
    }

    @Override
    @Nonnull
    public
        WorkPackageByKeyFluentHelper
        getWorkPackageByKey( final String projectID, final String workPackageID, final String workPackageName )
    {
        return new WorkPackageByKeyFluentHelper(
            servicePath,
            "WorkPackageSet",
            projectID,
            workPackageID,
            workPackageName);
    }

    @Override
    @Nonnull
    public WorkPackageCreateFluentHelper createWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return new WorkPackageCreateFluentHelper(servicePath, workPackage, "WorkPackageSet");
    }

    @Override
    @Nonnull
    public WorkPackageUpdateFluentHelper updateWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return new WorkPackageUpdateFluentHelper(servicePath, workPackage, "WorkPackageSet");
    }

    @Override
    @Nonnull
    public WorkPackageDeleteFluentHelper deleteWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return new WorkPackageDeleteFluentHelper(servicePath, workPackage, "WorkPackageSet");
    }

    @Override
    @Nonnull
    public WorkItemFluentHelper getAllWorkItem()
    {
        return new WorkItemFluentHelper(servicePath, "WorkItemSet");
    }

    @Override
    @Nonnull
    public WorkItemByKeyFluentHelper getWorkItemByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String workitem )
    {
        return new WorkItemByKeyFluentHelper(
            servicePath,
            "WorkItemSet",
            projectID,
            workPackageID,
            workPackageName,
            workitem);
    }

    @Override
    @Nonnull
    public WorkItemCreateFluentHelper createWorkItem( @Nonnull final WorkItem workItem )
    {
        return new WorkItemCreateFluentHelper(servicePath, workItem, "WorkItemSet");
    }

    @Override
    @Nonnull
    public WorkItemDeleteFluentHelper deleteWorkItem( @Nonnull final WorkItem workItem )
    {
        return new WorkItemDeleteFluentHelper(servicePath, workItem, "WorkItemSet");
    }

    @Override
    @Nonnull
    public DemandFluentHelper getAllDemand()
    {
        return new DemandFluentHelper(servicePath, "DemandSet");
    }

    @Override
    @Nonnull
    public DemandByKeyFluentHelper getDemandByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String resType,
        final String resourceId,
        final String workitem,
        final String delvryServOrg )
    {
        return new DemandByKeyFluentHelper(
            servicePath,
            "DemandSet",
            projectID,
            workPackageID,
            workPackageName,
            resType,
            resourceId,
            workitem,
            delvryServOrg);
    }

    @Override
    @Nonnull
    public DemandCreateFluentHelper createDemand( @Nonnull final Demand demand )
    {
        return new DemandCreateFluentHelper(servicePath, demand, "DemandSet");
    }

    @Override
    @Nonnull
    public DemandUpdateFluentHelper updateDemand( @Nonnull final Demand demand )
    {
        return new DemandUpdateFluentHelper(servicePath, demand, "DemandSet");
    }

    @Override
    @Nonnull
    public DemandDeleteFluentHelper deleteDemand( @Nonnull final Demand demand )
    {
        return new DemandDeleteFluentHelper(servicePath, demand, "DemandSet");
    }

    @Override
    @Nonnull
    public ProjectRoleFluentHelper getAllProjectRole()
    {
        return new ProjectRoleFluentHelper(servicePath, "ProjectRoleSet");
    }

    @Override
    @Nonnull
    public ProjectRoleByKeyFluentHelper getProjectRoleByKey( final String projectID, final String projectRoleID )
    {
        return new ProjectRoleByKeyFluentHelper(servicePath, "ProjectRoleSet", projectID, projectRoleID);
    }

    @Override
    @Nonnull
    public ProjectRoleCreateFluentHelper createProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return new ProjectRoleCreateFluentHelper(servicePath, projectRole, "ProjectRoleSet");
    }

    @Override
    @Nonnull
    public ProjectRoleUpdateFluentHelper updateProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return new ProjectRoleUpdateFluentHelper(servicePath, projectRole, "ProjectRoleSet");
    }

    @Override
    @Nonnull
    public ProjectRoleDeleteFluentHelper deleteProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return new ProjectRoleDeleteFluentHelper(servicePath, projectRole, "ProjectRoleSet");
    }

    @Override
    @Nonnull
    public UpdateCustProjSlsOrdItemMaterialFluentHelper updateCustProjSlsOrdItemMaterial(
        @Nonnull final String customerProject,
        @Nonnull final String salesOrderItem,
        @Nonnull final String material )
    {
        return new UpdateCustProjSlsOrdItemMaterialFluentHelper(servicePath, customerProject, salesOrderItem, material);
    }

}
