/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.batch.DefaultCommitmentAndActualItemServiceBatch;

/**
 * <p>
 *
 * This service enables you to read the commitment and actual items transactional data from SAP S/4HANA Cloud system.
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c5/32f4b91f5849f09beaf5cc3920a2a9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PUBSECCMTMTACTLITEM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PUBSECCMTMTACTLITEM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Fund</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCommitmentAndActualItemService" )
@Deprecated
public class DefaultCommitmentAndActualItemService implements CommitmentAndActualItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CommitmentAndActualItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCommitmentAndActualItemService()
    {
        servicePath = CommitmentAndActualItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCommitmentAndActualItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCommitmentAndActualItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCommitmentAndActualItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCommitmentAndActualItemServiceBatch batch()
    {
        return new DefaultCommitmentAndActualItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PublicSectorCommitmentActualItemFluentHelper getAllPublicSectorCommitmentActualItem()
    {
        return new PublicSectorCommitmentActualItemFluentHelper(servicePath, "PubSecCmtmtActlItem");
    }

    @Override
    @Nonnull
    public PublicSectorCommitmentActualItemByKeyFluentHelper getPublicSectorCommitmentActualItemByKey(
        final String ledger,
        final String sourceLedger,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String ledgerGLLineItem )
    {
        return new PublicSectorCommitmentActualItemByKeyFluentHelper(
            servicePath,
            "PubSecCmtmtActlItem",
            ledger,
            sourceLedger,
            companyCode,
            fiscalYear,
            accountingDocument,
            ledgerGLLineItem);
    }

}
