/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.companycode.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.companycode.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.companycode.batch.DefaultCompanyCodeServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve company codes and their properties like name, country and currency. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b5/2aac521dc0441aba00d65c859ad9c6/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COMPANYCODE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COMPANYCODE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241), Employee Central Financial Master Data Integration(SAP_COM_0441), SAP Analytics Cloud for
 * Liquidity Planning Integration(SAP_COM_0443), Excise Tax Integration(SAP_COM_0568), Procurement - Supplier Quotation
 * Management Integration(SAP_COM_0760), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee
 * Central(JB1)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors
 * Employee Central(4AJ)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3L5'>Liquidity Planning(3L5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Company Code</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCompanyCodeService" )
@Deprecated
public class DefaultCompanyCodeService implements CompanyCodeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CompanyCodeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCompanyCodeService()
    {
        servicePath = CompanyCodeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCompanyCodeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCompanyCodeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCompanyCodeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCompanyCodeServiceBatch batch()
    {
        return new DefaultCompanyCodeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CompanyCodeFluentHelper getAllCompanyCode()
    {
        return new CompanyCodeFluentHelper(servicePath, "A_CompanyCode");
    }

    @Override
    @Nonnull
    public CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode )
    {
        return new CompanyCodeByKeyFluentHelper(servicePath, "A_CompanyCode", companyCode);
    }

}
