/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.batch.DefaultConditionContractTypeServiceBatch;

/**
 * <p>
 *
 * The service is based on the OData protocol and can be consumed in SAP Fiori apps and in other user interfaces.
 *
 * In every API call, you can make use of the following operations: - You can retrieve condition contract types. - You
 * can retrieve business volume field combinations based on a contract type. - You can retrieve field name assignments
 * to business volume field combination types used in condition contract settlement processes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9f/a139d692dd43e7af01343a1e5ff9ec/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONDITION_CONTRACT_TYPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONDITION_CONTRACT_TYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Condition Contract Type Integration(SAP_COM_0335)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing(1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing(2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative(2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/55I'>Royalties Settlement for Sales(55I)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Condition Contract Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultConditionContractTypeService" )
@Deprecated
public class DefaultConditionContractTypeService implements ConditionContractTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ConditionContractTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultConditionContractTypeService()
    {
        servicePath = ConditionContractTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultConditionContractTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultConditionContractTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultConditionContractTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultConditionContractTypeServiceBatch batch()
    {
        return new DefaultConditionContractTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusVolFldCombnSetTypeAssgmtFluentHelper getAllBusVolFldCombnSetTypeAssgmt()
    {
        return new BusVolFldCombnSetTypeAssgmtFluentHelper(servicePath, "A_BusVolFldCombnSetTypeAssgmt");
    }

    @Override
    @Nonnull
    public BusVolFldCombnSetTypeAssgmtByKeyFluentHelper getBusVolFldCombnSetTypeAssgmtByKey(
        final String cndnContrType,
        final String busVolFldCombnSet,
        final String busVolFieldCombnType )
    {
        return new BusVolFldCombnSetTypeAssgmtByKeyFluentHelper(
            servicePath,
            "A_BusVolFldCombnSetTypeAssgmt",
            cndnContrType,
            busVolFldCombnSet,
            busVolFieldCombnType);
    }

    @Override
    @Nonnull
    public CndnContrTypeFluentHelper getAllCndnContrType()
    {
        return new CndnContrTypeFluentHelper(servicePath, "A_CndnContrType");
    }

    @Override
    @Nonnull
    public CndnContrTypeByKeyFluentHelper getCndnContrTypeByKey( final String cndnContrType )
    {
        return new CndnContrTypeByKeyFluentHelper(servicePath, "A_CndnContrType", cndnContrType);
    }

}
