/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.batch.DefaultConsolidationUnitServiceBatch;

/**
 * <p>
 * A consolidation unit is the smallest entity of the corporate group structure that can be used as the basis for
 * performing a consolidation. Consolidation units belong to the master data of group reporting.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ea/fd484b398443cb96ed33c8a123f4de/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONSOLIDATIONUNIT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONSOLIDATIONUNIT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Cloud Consolidation Data Collection Integration(SAP_COM_0241), Finance - Cloud Consolidation Master
 * Data for Group Reporting Integration(SAP_COM_0336)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2U6'>Group Reporting - Data from External
 * Systems(2U6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Consolidation Unit</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultConsolidationUnitService" )
@Deprecated
public class DefaultConsolidationUnitService implements ConsolidationUnitService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ConsolidationUnitService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultConsolidationUnitService()
    {
        servicePath = ConsolidationUnitService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultConsolidationUnitService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultConsolidationUnitService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultConsolidationUnitService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultConsolidationUnitServiceBatch batch()
    {
        return new DefaultConsolidationUnitServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ConsolidationUnitByTimeFluentHelper getAllConsolidationUnitByTime()
    {
        return new ConsolidationUnitByTimeFluentHelper(servicePath, "ConsolidationUnitByTime");
    }

    @Override
    @Nonnull
    public
        ConsolidationUnitByTimeByKeyFluentHelper
        getConsolidationUnitByTimeByKey( final String consolidationUnit, final String fromFiscalYearPeriod )
    {
        return new ConsolidationUnitByTimeByKeyFluentHelper(
            servicePath,
            "ConsolidationUnitByTime",
            consolidationUnit,
            fromFiscalYearPeriod);
    }

    @Override
    @Nonnull
    public ConsolidationUnitByTimeVersionFluentHelper getAllConsolidationUnitByTimeVersion()
    {
        return new ConsolidationUnitByTimeVersionFluentHelper(servicePath, "ConsolidationUnitByTimeVersion");
    }

    @Override
    @Nonnull
    public ConsolidationUnitByTimeVersionByKeyFluentHelper getConsolidationUnitByTimeVersionByKey(
        final String consolidationUnit,
        final String consolidationVersion,
        final String fromFiscalYearPeriod )
    {
        return new ConsolidationUnitByTimeVersionByKeyFluentHelper(
            servicePath,
            "ConsolidationUnitByTimeVersion",
            consolidationUnit,
            consolidationVersion,
            fromFiscalYearPeriod);
    }

    @Override
    @Nonnull
    public ConsolidationUnitTextFluentHelper getAllConsolidationUnitText()
    {
        return new ConsolidationUnitTextFluentHelper(servicePath, "ConsolidationUnitText");
    }

    @Override
    @Nonnull
    public
        ConsolidationUnitTextByKeyFluentHelper
        getConsolidationUnitTextByKey( final String language, final String consolidationUnit )
    {
        return new ConsolidationUnitTextByKeyFluentHelper(
            servicePath,
            "ConsolidationUnitText",
            language,
            consolidationUnit);
    }

    @Override
    @Nonnull
    public ConsolidationUnitFluentHelper getAllConsolidationUnit()
    {
        return new ConsolidationUnitFluentHelper(servicePath, "ConsolidationUnit");
    }

    @Override
    @Nonnull
    public ConsolidationUnitByKeyFluentHelper getConsolidationUnitByKey( final String consolidationUnit )
    {
        return new ConsolidationUnitByKeyFluentHelper(servicePath, "ConsolidationUnit", consolidationUnit);
    }

}
