/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.batch.DefaultContractAccountingSEPAMandateServiceBatch;

/**
 * <p>
 *
 * With this service you can create, read and update SEPA Mandates for Contract Accounting (FI-CA). You can also create
 * and read the usage of SEPA mandates..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c1/1dbbdc5b454ad5814c981f2ac9aeab/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_O2C_FICA_SEPA_MANDATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_O2C_FICA_SEPA_MANDATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting SEPA Mandate Integration(SAP_COM_0458)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2AR'>Contract Accounting - Master Data and Basic
 * Functions(2AR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OAR'>Contract Accounting - Master Data and Basic
 * Functions(OAR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SEPA Mandate</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultContractAccountingSEPAMandateService" )
@Deprecated
public class DefaultContractAccountingSEPAMandateService implements ContractAccountingSEPAMandateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ContractAccountingSEPAMandateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultContractAccountingSEPAMandateService()
    {
        servicePath = ContractAccountingSEPAMandateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultContractAccountingSEPAMandateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultContractAccountingSEPAMandateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultContractAccountingSEPAMandateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultContractAccountingSEPAMandateServiceBatch batch()
    {
        return new DefaultContractAccountingSEPAMandateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SEPAMandateFluentHelper getAllSEPAMandate()
    {
        return new SEPAMandateFluentHelper(servicePath, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateByKeyFluentHelper getSEPAMandateByKey( final String creditor, final String sEPAMandate )
    {
        return new SEPAMandateByKeyFluentHelper(servicePath, "SEPAMandateSet", creditor, sEPAMandate);
    }

    @Override
    @Nonnull
    public SEPAMandateCreateFluentHelper createSEPAMandate( @Nonnull final SEPAMandate sEPAMandate )
    {
        return new SEPAMandateCreateFluentHelper(servicePath, sEPAMandate, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUpdateFluentHelper updateSEPAMandate( @Nonnull final SEPAMandate sEPAMandate )
    {
        return new SEPAMandateUpdateFluentHelper(servicePath, sEPAMandate, "SEPAMandateSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUsageFluentHelper getAllSEPAMandateUsage()
    {
        return new SEPAMandateUsageFluentHelper(servicePath, "SEPAMandateUsageSet");
    }

    @Override
    @Nonnull
    public SEPAMandateUsageByKeyFluentHelper getSEPAMandateUsageByKey(
        final String creditor,
        final String sEPAMandate,
        final LocalDateTime sEPAMandateUseDate,
        final String sEPAMandateUseObjectType,
        final String sEPAMandateUsePaymentDoc )
    {
        return new SEPAMandateUsageByKeyFluentHelper(
            servicePath,
            "SEPAMandateUsageSet",
            creditor,
            sEPAMandate,
            sEPAMandateUseDate,
            sEPAMandateUseObjectType,
            sEPAMandateUsePaymentDoc);
    }

    @Override
    @Nonnull
    public SEPAMandateUsageCreateFluentHelper createSEPAMandateUsage( @Nonnull final SEPAMandateUsage sEPAMandateUsage )
    {
        return new SEPAMandateUsageCreateFluentHelper(servicePath, sEPAMandateUsage, "SEPAMandateUsageSet");
    }

}
