/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.batch.DefaultControllingAreaServiceBatch;

/**
 * <p>
 * The service contains the controlling area node.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/36/1a2707d8834d4e8bd865642bf115a5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONTROLLINGAREA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONTROLLINGAREA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ControllingArea</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultControllingAreaService" )
@Deprecated
public class DefaultControllingAreaService implements ControllingAreaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ControllingAreaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultControllingAreaService()
    {
        servicePath = ControllingAreaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultControllingAreaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultControllingAreaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultControllingAreaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultControllingAreaServiceBatch batch()
    {
        return new DefaultControllingAreaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ControllingAreaFluentHelper getAllControllingArea()
    {
        return new ControllingAreaFluentHelper(servicePath, "A_ControllingArea");
    }

    @Override
    @Nonnull
    public ControllingAreaByKeyFluentHelper getControllingAreaByKey( final String controllingArea )
    {
        return new ControllingAreaByKeyFluentHelper(servicePath, "A_ControllingArea", controllingArea);
    }

}
