/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.batch.DefaultCostCenterActivityTypeServiceBatch;

/**
 * <p>
 *
 * You can use this inbound synchronous service to create, read, update, and delete master data of activity types used
 * by one or multiple cost centers. It is based on the OData protocol and can be consumed in SAP Fiori apps and other
 * user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/66/9215d2b94341b1bce120413d9c3ab2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTCNTRACTIVITYTYPE_CRUD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTCNTRACTIVITYTYPE_CRUD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Cost Center Activity Type Integration(SAP_COM_0357)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O54'>Overhead Cost Accounting(O54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Cost Center Activity Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCostCenterActivityTypeService" )
@Deprecated
public class DefaultCostCenterActivityTypeService implements CostCenterActivityTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CostCenterActivityTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCostCenterActivityTypeService()
    {
        servicePath = CostCenterActivityTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCostCenterActivityTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCostCenterActivityTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCostCenterActivityTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCostCenterActivityTypeServiceBatch batch()
    {
        return new DefaultCostCenterActivityTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeFluentHelper getAllCostCenterActivityType()
    {
        return new CostCenterActivityTypeFluentHelper(servicePath, "A_CostCenterActivityType");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeByKeyFluentHelper getCostCenterActivityTypeByKey(
        final String controllingArea,
        final String costCtrActivityType,
        final LocalDateTime validityEndDate )
    {
        return new CostCenterActivityTypeByKeyFluentHelper(
            servicePath,
            "A_CostCenterActivityType",
            controllingArea,
            costCtrActivityType,
            validityEndDate);
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeCreateFluentHelper createCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return new CostCenterActivityTypeCreateFluentHelper(
            servicePath,
            costCenterActivityType,
            "A_CostCenterActivityType");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeUpdateFluentHelper updateCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return new CostCenterActivityTypeUpdateFluentHelper(
            servicePath,
            costCenterActivityType,
            "A_CostCenterActivityType");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeDeleteFluentHelper deleteCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return new CostCenterActivityTypeDeleteFluentHelper(
            servicePath,
            costCenterActivityType,
            "A_CostCenterActivityType");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextFluentHelper getAllCostCenterActivityTypeText()
    {
        return new CostCenterActivityTypeTextFluentHelper(servicePath, "A_CostCenterActivityTypeText");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextByKeyFluentHelper getCostCenterActivityTypeTextByKey(
        final LocalDateTime validityEndDate,
        final String controllingArea,
        final String costCtrActivityType,
        final String language )
    {
        return new CostCenterActivityTypeTextByKeyFluentHelper(
            servicePath,
            "A_CostCenterActivityTypeText",
            validityEndDate,
            controllingArea,
            costCtrActivityType,
            language);
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextCreateFluentHelper createCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return new CostCenterActivityTypeTextCreateFluentHelper(
            servicePath,
            costCenterActivityTypeText,
            "A_CostCenterActivityTypeText");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextUpdateFluentHelper updateCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return new CostCenterActivityTypeTextUpdateFluentHelper(
            servicePath,
            costCenterActivityTypeText,
            "A_CostCenterActivityTypeText");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextDeleteFluentHelper deleteCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return new CostCenterActivityTypeTextDeleteFluentHelper(
            servicePath,
            costCenterActivityTypeText,
            "A_CostCenterActivityTypeText");
    }

}
