/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.batch.DefaultCostCenterServiceBatch;

/**
 * <p>
 * This service enables you to read cost center master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/37/310ccbc01943d98e7d84dff3802537/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTCENTER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTCENTER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Cost Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCostCenterService" )
@Deprecated
public class DefaultCostCenterService implements CostCenterService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CostCenterService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCostCenterService()
    {
        servicePath = CostCenterService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCostCenterService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCostCenterService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCostCenterService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCostCenterServiceBatch batch()
    {
        return new DefaultCostCenterServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CostCenterFluentHelper getAllCostCenter()
    {
        return new CostCenterFluentHelper(servicePath, "A_CostCenter");
    }

    @Override
    @Nonnull
    public
        CostCenterByKeyFluentHelper
        getCostCenterByKey( final String controllingArea, final String costCenter, final LocalDateTime validityEndDate )
    {
        return new CostCenterByKeyFluentHelper(
            servicePath,
            "A_CostCenter",
            controllingArea,
            costCenter,
            validityEndDate);
    }

    @Override
    @Nonnull
    public CostCenterTextFluentHelper getAllCostCenterText()
    {
        return new CostCenterTextFluentHelper(servicePath, "A_CostCenterText");
    }

    @Override
    @Nonnull
    public CostCenterTextByKeyFluentHelper getCostCenterTextByKey(
        final String costCenter,
        final String controllingArea,
        final String language,
        final LocalDateTime validityEndDate )
    {
        return new CostCenterTextByKeyFluentHelper(
            servicePath,
            "A_CostCenterText",
            costCenter,
            controllingArea,
            language,
            validityEndDate);
    }

}
