/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.batch.DefaultCostCenterTestServiceBatch;

/**
 * <p>
 *
 * This service enables you to read cost center master data. Please note that this service uses a data model where the
 * cost center is defined per company code. This data model has been replaced with a data model where the cost center is
 * defined per controlling area. With this change also a new service reflecting the new data model has been created and
 * this service is deprecated. It is highly recommended to use the new service instead of this one..
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/FCO_PI_COST_CENTER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>FCO_PI_COST_CENTER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Employee Integration (SAP_COM_0001)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central
 * (JB1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2002 (FEB-2020). Please use the
 *             <a href="https://api.sap.com/api/API_COSTCENTER_SRV"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCostCenterTestService" )
@Deprecated
public class DefaultCostCenterTestService implements CostCenterTestService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CostCenterTestService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCostCenterTestService()
    {
        servicePath = CostCenterTestService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCostCenterTestService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCostCenterTestService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCostCenterTestService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCostCenterTestServiceBatch batch()
    {
        return new DefaultCostCenterTestServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CostCenterFluentHelper getAllCostCenter()
    {
        return new CostCenterFluentHelper(servicePath, "CostCenterCollection");
    }

    @Override
    @Nonnull
    public
        CostCenterByKeyFluentHelper
        getCostCenterByKey( final String companyCode, final String costCenterID, final LocalDateTime validityEndDate )
    {
        return new CostCenterByKeyFluentHelper(
            servicePath,
            "CostCenterCollection",
            companyCode,
            costCenterID,
            validityEndDate);
    }

    @Override
    @Nonnull
    public CostCenterCreateFluentHelper createCostCenter( @Nonnull final CostCenter costCenter )
    {
        return new CostCenterCreateFluentHelper(servicePath, costCenter, "CostCenterCollection");
    }

    @Override
    @Nonnull
    public CostCenterUpdateFluentHelper updateCostCenter( @Nonnull final CostCenter costCenter )
    {
        return new CostCenterUpdateFluentHelper(servicePath, costCenter, "CostCenterCollection");
    }

    @Override
    @Nonnull
    public CostCenterDeleteFluentHelper deleteCostCenter( @Nonnull final CostCenter costCenter )
    {
        return new CostCenterDeleteFluentHelper(servicePath, costCenter, "CostCenterCollection");
    }

    @Override
    @Nonnull
    public CostCenterTextFluentHelper getAllCostCenterText()
    {
        return new CostCenterTextFluentHelper(servicePath, "CostCenterTextCollection");
    }

    @Override
    @Nonnull
    public CostCenterTextByKeyFluentHelper getCostCenterTextByKey(
        final String companyCode,
        final String costCenterID,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new CostCenterTextByKeyFluentHelper(
            servicePath,
            "CostCenterTextCollection",
            companyCode,
            costCenterID,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public CostCenterTextCreateFluentHelper createCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return new CostCenterTextCreateFluentHelper(servicePath, costCenterText, "CostCenterTextCollection");
    }

    @Override
    @Nonnull
    public CostCenterTextUpdateFluentHelper updateCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return new CostCenterTextUpdateFluentHelper(servicePath, costCenterText, "CostCenterTextCollection");
    }

    @Override
    @Nonnull
    public CostCenterTextDeleteFluentHelper deleteCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return new CostCenterTextDeleteFluentHelper(servicePath, costCenterText, "CostCenterTextCollection");
    }

}
