/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.ReverseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.batch.DefaultCostControllingJournalEntryServiceBatch;

/**
 * <p>
 *
 * This service enables you to read, create, and reverse journal entries related to cost controlling. You can reassign a
 * high volume of primary and secondary costs and revenues when the allocation is incorrect..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0a/13edf5bb9d4b9ea7dd89fe6cd5309c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTREVNREASSIGNMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTREVNREASSIGNMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Reassign Costs and Revenues Integration(SAP_COM_0754)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O54'>Overhead Cost Accounting(O54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCostControllingJournalEntryService" )
@Deprecated
public class DefaultCostControllingJournalEntryService implements CostControllingJournalEntryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CostControllingJournalEntryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCostControllingJournalEntryService()
    {
        servicePath = CostControllingJournalEntryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCostControllingJournalEntryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCostControllingJournalEntryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCostControllingJournalEntryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCostControllingJournalEntryServiceBatch batch()
    {
        return new DefaultCostControllingJournalEntryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CostRevenueReassignmentFluentHelper getAllCostRevenueReassignment()
    {
        return new CostRevenueReassignmentFluentHelper(servicePath, "A_CostRevenueReassignment");
    }

    @Override
    @Nonnull
    public CostRevenueReassignmentByKeyFluentHelper getCostRevenueReassignmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea )
    {
        return new CostRevenueReassignmentByKeyFluentHelper(
            servicePath,
            "A_CostRevenueReassignment",
            fiscalYear,
            referenceDocument,
            controllingArea);
    }

    @Override
    @Nonnull
    public CostRevenueReassignmentCreateFluentHelper createCostRevenueReassignment(
        @Nonnull final CostRevenueReassignment costRevenueReassignment )
    {
        return new CostRevenueReassignmentCreateFluentHelper(
            servicePath,
            costRevenueReassignment,
            "A_CostRevenueReassignment");
    }

    @Override
    @Nonnull
    public CostRevenueReassignmentItemFluentHelper getAllCostRevenueReassignmentItem()
    {
        return new CostRevenueReassignmentItemFluentHelper(servicePath, "A_CostRevenueReassignmentItem");
    }

    @Override
    @Nonnull
    public CostRevenueReassignmentItemByKeyFluentHelper getCostRevenueReassignmentItemByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String companyCode,
        final String ledgerGLLineItem,
        final String referenceDocumentItem )
    {
        return new CostRevenueReassignmentItemByKeyFluentHelper(
            servicePath,
            "A_CostRevenueReassignmentItem",
            fiscalYear,
            referenceDocument,
            controllingArea,
            companyCode,
            ledgerGLLineItem,
            referenceDocumentItem);
    }

    @Override
    @Nonnull
    public CostRevnRcvrPrftbltySegmentFluentHelper getAllCostRevnRcvrPrftbltySegment()
    {
        return new CostRevnRcvrPrftbltySegmentFluentHelper(servicePath, "A_CostRevnRcvrPrftbltySegment");
    }

    @Override
    @Nonnull
    public CostRevnRcvrPrftbltySegmentByKeyFluentHelper getCostRevnRcvrPrftbltySegmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String ledgerGLLineItem,
        final String referenceDocumentItem )
    {
        return new CostRevnRcvrPrftbltySegmentByKeyFluentHelper(
            servicePath,
            "A_CostRevnRcvrPrftbltySegment",
            fiscalYear,
            referenceDocument,
            controllingArea,
            ledgerGLLineItem,
            referenceDocumentItem);
    }

    @Override
    @Nonnull
    public CostRevnSndrPrftbltySegmentFluentHelper getAllCostRevnSndrPrftbltySegment()
    {
        return new CostRevnSndrPrftbltySegmentFluentHelper(servicePath, "A_CostRevnSndrPrftbltySegment");
    }

    @Override
    @Nonnull
    public CostRevnSndrPrftbltySegmentByKeyFluentHelper getCostRevnSndrPrftbltySegmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String ledgerGLLineItem,
        final String referenceDocumentItem )
    {
        return new CostRevnSndrPrftbltySegmentByKeyFluentHelper(
            servicePath,
            "A_CostRevnSndrPrftbltySegment",
            fiscalYear,
            referenceDocument,
            controllingArea,
            ledgerGLLineItem,
            referenceDocumentItem);
    }

    @Override
    @Nonnull
    public ReverseFluentHelper reverse(
        @Nonnull final String fiscalYear,
        @Nonnull final String referenceDocument,
        @Nonnull final String controllingArea,
        @Nullable final LocalDateTime documentDate,
        @Nullable final LocalDateTime postingDate,
        @Nullable final String fiscalPeriod,
        @Nullable final String accountingDocumentHeaderText,
        @Nullable final String warningsAreIgnored )
    {
        return new ReverseFluentHelper(
            servicePath,
            fiscalYear,
            referenceDocument,
            controllingArea,
            documentDate,
            postingDate,
            fiscalPeriod,
            accountingDocumentHeaderText,
            warningsAreIgnored);
    }

}
