/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.batch.DefaultCostRateServiceBatch;

/**
 * <p>
 *
 * This service contains plan cost rate, actual cost rate and service cost rate.
 *
 * For each type you can read a list of existing cost rates, create a new one, update or delete an existing one.
 *
 * During creation or update, the information is used to create a new cost rate or to update an existing one - including
 * all necessary checks for restricted values and authorizations.
 *
 * Created or updated cost rates are included in the response. An existing cost rate that needs to be modified or
 * deleted is identified by the mandatory parameter - AccountingCostRateUUID.
 *
 * If there are any issues, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/59/9a4093d9614191bbd357e97fa558eb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FCO_COST_RATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FCO_COST_RATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Activity Type Integration(SAP_COM_0129)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Accounting Cost Rate</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCostRateService" )
@Deprecated
public class DefaultCostRateService implements CostRateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CostRateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCostRateService()
    {
        servicePath = CostRateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCostRateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCostRateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCostRateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCostRateServiceBatch batch()
    {
        return new DefaultCostRateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ActualCostRateFluentHelper getAllActualCostRate()
    {
        return new ActualCostRateFluentHelper(servicePath, "A_ActualCostRate");
    }

    @Override
    @Nonnull
    public ActualCostRateByKeyFluentHelper getActualCostRateByKey( final UUID accountingCostRateUUID )
    {
        return new ActualCostRateByKeyFluentHelper(servicePath, "A_ActualCostRate", accountingCostRateUUID);
    }

    @Override
    @Nonnull
    public ActualCostRateCreateFluentHelper createActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return new ActualCostRateCreateFluentHelper(servicePath, actualCostRate, "A_ActualCostRate");
    }

    @Override
    @Nonnull
    public ActualCostRateUpdateFluentHelper updateActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return new ActualCostRateUpdateFluentHelper(servicePath, actualCostRate, "A_ActualCostRate");
    }

    @Override
    @Nonnull
    public ActualCostRateDeleteFluentHelper deleteActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return new ActualCostRateDeleteFluentHelper(servicePath, actualCostRate, "A_ActualCostRate");
    }

    @Override
    @Nonnull
    public PlanCostRateFluentHelper getAllPlanCostRate()
    {
        return new PlanCostRateFluentHelper(servicePath, "A_PlanCostRate");
    }

    @Override
    @Nonnull
    public PlanCostRateByKeyFluentHelper getPlanCostRateByKey( final UUID accountingCostRateUUID )
    {
        return new PlanCostRateByKeyFluentHelper(servicePath, "A_PlanCostRate", accountingCostRateUUID);
    }

    @Override
    @Nonnull
    public PlanCostRateCreateFluentHelper createPlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return new PlanCostRateCreateFluentHelper(servicePath, planCostRate, "A_PlanCostRate");
    }

    @Override
    @Nonnull
    public PlanCostRateUpdateFluentHelper updatePlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return new PlanCostRateUpdateFluentHelper(servicePath, planCostRate, "A_PlanCostRate");
    }

    @Override
    @Nonnull
    public PlanCostRateDeleteFluentHelper deletePlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return new PlanCostRateDeleteFluentHelper(servicePath, planCostRate, "A_PlanCostRate");
    }

    @Override
    @Nonnull
    public ServiceCostRateFluentHelper getAllServiceCostRate()
    {
        return new ServiceCostRateFluentHelper(servicePath, "A_ServiceCostRate");
    }

    @Override
    @Nonnull
    public ServiceCostRateByKeyFluentHelper getServiceCostRateByKey( final UUID accountingCostRateUUID )
    {
        return new ServiceCostRateByKeyFluentHelper(servicePath, "A_ServiceCostRate", accountingCostRateUUID);
    }

    @Override
    @Nonnull
    public ServiceCostRateCreateFluentHelper createServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return new ServiceCostRateCreateFluentHelper(servicePath, serviceCostRate, "A_ServiceCostRate");
    }

    @Override
    @Nonnull
    public ServiceCostRateUpdateFluentHelper updateServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return new ServiceCostRateUpdateFluentHelper(servicePath, serviceCostRate, "A_ServiceCostRate");
    }

    @Override
    @Nonnull
    public ServiceCostRateDeleteFluentHelper deleteServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return new ServiceCostRateDeleteFluentHelper(servicePath, serviceCostRate, "A_ServiceCostRate");
    }

}
