/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.batch.DefaultCountryServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve country/region information like ISO codes, currencies and tax procedure..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/78/fb82519e564b14a659f8e029713b74/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COUNTRY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COUNTRY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Country</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCountryService" )
@Deprecated
public class DefaultCountryService implements CountryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CountryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCountryService()
    {
        servicePath = CountryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCountryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCountryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCountryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCountryServiceBatch batch()
    {
        return new DefaultCountryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CountryFluentHelper getAllCountry()
    {
        return new CountryFluentHelper(servicePath, "A_Country");
    }

    @Override
    @Nonnull
    public CountryByKeyFluentHelper getCountryByKey( final String country )
    {
        return new CountryByKeyFluentHelper(servicePath, "A_Country", country);
    }

    @Override
    @Nonnull
    public CountryTextFluentHelper getAllCountryText()
    {
        return new CountryTextFluentHelper(servicePath, "A_CountryText");
    }

    @Override
    @Nonnull
    public CountryTextByKeyFluentHelper getCountryTextByKey( final String country, final String language )
    {
        return new CountryTextByKeyFluentHelper(servicePath, "A_CountryText", country, language);
    }

}
