/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.batch.DefaultCreditManagementMasterDataServiceBatch;

/**
 * <p>
 *
 * This service uses the following nodes: Business Partners, Credit Mgmt: BP Collateral, Credit Mgmt: BP Credit
 * Insurance, Credit Mgmt: BP Negative Event, Credit Accounts, Credit Mgmt Account: Collateral and Credit Mgmt Account:
 * Credit Insurance.
 *
 * Use the Business Partner node to read, create and update data related to credit management for business partners in
 * the business partner role SAP Credit Management, such as risk class, limit rule, or check rule.
 *
 * Use the Credit Mgmt: BP Collateral node to read, create, change or delete the collateral in the general data of
 * business partners.
 *
 * Use the Credit Mgmt: BP Credit Insurance node to read, create, change or delete credit insurances in the general data
 * of business partners.
 *
 * Use the Credit Mgmt: BP Negative Event node to read, create, change or delete negative credit events in the general
 * data of business partners.
 *
 * Use the Credit Management Account node to read, create, update, and delete credit segment data, such as credit limit,
 * special attention flag, block reason, and others.
 *
 * Use the Credit Mgmt Account: Collateral subnode to read, create, change or delete the collateral for business
 * partners in a credit segment.
 *
 * Use the Credit Mgmt Account: Credit Insurance subnode to read, create, change or delete credit insurances for
 * business partners in a credit segment.
 *
 * If you want to create credit-management-related master data for an existing business partner, you send data for both
 * nodes in a post request as a payload. If it’s not already maintained, the SAP Credit Management role (UKM000) is
 * automatically added to the business partners.
 *
 * If you want to add or change credit-management-related master data, you may send requests addressing the related
 * entities directly.
 *
 * If there are any issues with the data passed, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/64/e8c928499341ffb0eaac517a882b7d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CRDTMBUSINESSPARTNER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CRDTMBUSINESSPARTNER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Credit Management Master Data Integration(SAP_COM_0740)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QM'>Advanced Credit Management(1QM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Credit Management Business Partner</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCreditManagementMasterDataService" )
@Deprecated
public class DefaultCreditManagementMasterDataService implements CreditManagementMasterDataService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CreditManagementMasterDataService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCreditManagementMasterDataService()
    {
        servicePath = CreditManagementMasterDataService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCreditManagementMasterDataService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCreditManagementMasterDataService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCreditManagementMasterDataService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCreditManagementMasterDataServiceBatch batch()
    {
        return new DefaultCreditManagementMasterDataServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CrdtMAcctCollateralFluentHelper getAllCrdtMAcctCollateral()
    {
        return new CrdtMAcctCollateralFluentHelper(servicePath, "CrdtMAcctCollateral");
    }

    @Override
    @Nonnull
    public CrdtMAcctCollateralByKeyFluentHelper getCrdtMAcctCollateralByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        return new CrdtMAcctCollateralByKeyFluentHelper(
            servicePath,
            "CrdtMAcctCollateral",
            businessPartner,
            creditSegment,
            crdtAcctInformationCategory,
            crdtAcctInformationType,
            additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    public CrdtMAcctCollateralUpdateFluentHelper updateCrdtMAcctCollateral(
        @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral )
    {
        return new CrdtMAcctCollateralUpdateFluentHelper(servicePath, crdtMAcctCollateral, "CrdtMAcctCollateral");
    }

    @Override
    @Nonnull
    public CrdtMAcctCollateralDeleteFluentHelper deleteCrdtMAcctCollateral(
        @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral )
    {
        return new CrdtMAcctCollateralDeleteFluentHelper(servicePath, crdtMAcctCollateral, "CrdtMAcctCollateral");
    }

    @Override
    @Nonnull
    public CrdtMAcctCrdtInsuranceFluentHelper getAllCrdtMAcctCrdtInsurance()
    {
        return new CrdtMAcctCrdtInsuranceFluentHelper(servicePath, "CrdtMAcctCrdtInsurance");
    }

    @Override
    @Nonnull
    public CrdtMAcctCrdtInsuranceByKeyFluentHelper getCrdtMAcctCrdtInsuranceByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        return new CrdtMAcctCrdtInsuranceByKeyFluentHelper(
            servicePath,
            "CrdtMAcctCrdtInsurance",
            businessPartner,
            creditSegment,
            crdtAcctInformationCategory,
            crdtAcctInformationType,
            additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    public CrdtMAcctCrdtInsuranceUpdateFluentHelper updateCrdtMAcctCrdtInsurance(
        @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance )
    {
        return new CrdtMAcctCrdtInsuranceUpdateFluentHelper(
            servicePath,
            crdtMAcctCrdtInsurance,
            "CrdtMAcctCrdtInsurance");
    }

    @Override
    @Nonnull
    public CrdtMAcctCrdtInsuranceDeleteFluentHelper deleteCrdtMAcctCrdtInsurance(
        @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance )
    {
        return new CrdtMAcctCrdtInsuranceDeleteFluentHelper(
            servicePath,
            crdtMAcctCrdtInsurance,
            "CrdtMAcctCrdtInsurance");
    }

    @Override
    @Nonnull
    public CreditMgmtBusinessPartnerFluentHelper getAllCreditMgmtBusinessPartner()
    {
        return new CreditMgmtBusinessPartnerFluentHelper(servicePath, "CreditMgmtBusinessPartner");
    }

    @Override
    @Nonnull
    public CreditMgmtBusinessPartnerByKeyFluentHelper getCreditMgmtBusinessPartnerByKey( final String businessPartner )
    {
        return new CreditMgmtBusinessPartnerByKeyFluentHelper(
            servicePath,
            "CreditMgmtBusinessPartner",
            businessPartner);
    }

    @Override
    @Nonnull
    public CreditMgmtBusinessPartnerCreateFluentHelper createCreditMgmtBusinessPartner(
        @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner )
    {
        return new CreditMgmtBusinessPartnerCreateFluentHelper(
            servicePath,
            creditMgmtBusinessPartner,
            "CreditMgmtBusinessPartner");
    }

    @Override
    @Nonnull
    public CreditMgmtBusinessPartnerUpdateFluentHelper updateCreditMgmtBusinessPartner(
        @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner )
    {
        return new CreditMgmtBusinessPartnerUpdateFluentHelper(
            servicePath,
            creditMgmtBusinessPartner,
            "CreditMgmtBusinessPartner");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCollateralFluentHelper getAllCrdtMgmtBPCollateral()
    {
        return new CrdtMgmtBPCollateralFluentHelper(servicePath, "CrdtMgmtBPCollateral");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCollateralByKeyFluentHelper getCrdtMgmtBPCollateralByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        return new CrdtMgmtBPCollateralByKeyFluentHelper(
            servicePath,
            "CrdtMgmtBPCollateral",
            businessPartner,
            creditSegment,
            crdtAcctInformationCategory,
            crdtAcctInformationType,
            additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCollateralUpdateFluentHelper updateCrdtMgmtBPCollateral(
        @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral )
    {
        return new CrdtMgmtBPCollateralUpdateFluentHelper(servicePath, crdtMgmtBPCollateral, "CrdtMgmtBPCollateral");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCollateralDeleteFluentHelper deleteCrdtMgmtBPCollateral(
        @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral )
    {
        return new CrdtMgmtBPCollateralDeleteFluentHelper(servicePath, crdtMgmtBPCollateral, "CrdtMgmtBPCollateral");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCreditInsuranceFluentHelper getAllCrdtMgmtBPCreditInsurance()
    {
        return new CrdtMgmtBPCreditInsuranceFluentHelper(servicePath, "CrdtMgmtBPCreditInsurance");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCreditInsuranceByKeyFluentHelper getCrdtMgmtBPCreditInsuranceByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        return new CrdtMgmtBPCreditInsuranceByKeyFluentHelper(
            servicePath,
            "CrdtMgmtBPCreditInsurance",
            businessPartner,
            creditSegment,
            crdtAcctInformationCategory,
            crdtAcctInformationType,
            additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCreditInsuranceUpdateFluentHelper updateCrdtMgmtBPCreditInsurance(
        @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance )
    {
        return new CrdtMgmtBPCreditInsuranceUpdateFluentHelper(
            servicePath,
            crdtMgmtBPCreditInsurance,
            "CrdtMgmtBPCreditInsurance");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPCreditInsuranceDeleteFluentHelper deleteCrdtMgmtBPCreditInsurance(
        @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance )
    {
        return new CrdtMgmtBPCreditInsuranceDeleteFluentHelper(
            servicePath,
            crdtMgmtBPCreditInsurance,
            "CrdtMgmtBPCreditInsurance");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPNegativeEventFluentHelper getAllCrdtMgmtBPNegativeEvent()
    {
        return new CrdtMgmtBPNegativeEventFluentHelper(servicePath, "CrdtMgmtBPNegativeEvent");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPNegativeEventByKeyFluentHelper getCrdtMgmtBPNegativeEventByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        return new CrdtMgmtBPNegativeEventByKeyFluentHelper(
            servicePath,
            "CrdtMgmtBPNegativeEvent",
            businessPartner,
            creditSegment,
            crdtAcctInformationCategory,
            crdtAcctInformationType,
            additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    public CrdtMgmtBPNegativeEventUpdateFluentHelper updateCrdtMgmtBPNegativeEvent(
        @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent )
    {
        return new CrdtMgmtBPNegativeEventUpdateFluentHelper(
            servicePath,
            crdtMgmtBPNegativeEvent,
            "CrdtMgmtBPNegativeEvent");
    }

    @Override
    @Nonnull
    public CrdtMgmtBPNegativeEventDeleteFluentHelper deleteCrdtMgmtBPNegativeEvent(
        @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent )
    {
        return new CrdtMgmtBPNegativeEventDeleteFluentHelper(
            servicePath,
            crdtMgmtBPNegativeEvent,
            "CrdtMgmtBPNegativeEvent");
    }

    @Override
    @Nonnull
    public CreditManagementAccountFluentHelper getAllCreditManagementAccount()
    {
        return new CreditManagementAccountFluentHelper(servicePath, "CreditManagementAccount");
    }

    @Override
    @Nonnull
    public
        CreditManagementAccountByKeyFluentHelper
        getCreditManagementAccountByKey( final String businessPartner, final String creditSegment )
    {
        return new CreditManagementAccountByKeyFluentHelper(
            servicePath,
            "CreditManagementAccount",
            businessPartner,
            creditSegment);
    }

    @Override
    @Nonnull
    public CreditManagementAccountCreateFluentHelper createCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return new CreditManagementAccountCreateFluentHelper(
            servicePath,
            creditManagementAccount,
            "CreditManagementAccount");
    }

    @Override
    @Nonnull
    public CreditManagementAccountUpdateFluentHelper updateCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return new CreditManagementAccountUpdateFluentHelper(
            servicePath,
            creditManagementAccount,
            "CreditManagementAccount");
    }

    @Override
    @Nonnull
    public CreditManagementAccountDeleteFluentHelper deleteCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return new CreditManagementAccountDeleteFluentHelper(
            servicePath,
            creditManagementAccount,
            "CreditManagementAccount");
    }

}
