/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.batch.DefaultCreditMemoRequestServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire credit memo requests or only
 * parts of the data, using the provided filters. - You can create credit memo requests. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, item, item partner,
 * and item pricing element). You cannot create entities without including any related entities. - For existing credit
 * memo requests, you can create new items. Note that you must use “deep insert” requests (with the following entities:
 * item partner and item pricing element). You cannot create entities without including any related entities. - For
 * existing credit memo requests, you can update the following entities (that is, you can change the content of their
 * properties): the header, header partner, header pricing element, item, item partner, and item pricing element. - For
 * existing credit memo requests, you can delete the header, header partner, header pricing element, item, item partner,
 * and item pricing element. - You can accept or deny approval requests for credit memo requests that cannot be
 * processed without the consent of an approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/19/1531b7e2e048d9bddffab772f1788b/frameset.htm?profile=20025561'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CREDIT_MEMO_REQUEST_SRV?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CREDIT_MEMO_REQUEST_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Credit Memo Request Integration(SAP_COM_0158)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1EZ'>Credit Memo Processing(1EZ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKL'>Invoice Correction Process with Credit Memo(BKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OKL'>Invoice Correction Process with Credit Memo(OKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PEZ'>Credit Memo Processing(PEZ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Credit Memo Request</td>
 * </tr>
 * </table>
 *
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCreditMemoRequestService" )
public class DefaultCreditMemoRequestService implements CreditMemoRequestService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CreditMemoRequestService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCreditMemoRequestService()
    {
        servicePath = CreditMemoRequestService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCreditMemoRequestService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCreditMemoRequestService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCreditMemoRequestService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCreditMemoRequestServiceBatch batch()
    {
        return new DefaultCreditMemoRequestServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CrdMmReqItemSubsqntProcFlowFluentHelper getAllCrdMmReqItemSubsqntProcFlow()
    {
        return new CrdMmReqItemSubsqntProcFlowFluentHelper(servicePath, "A_CrdMmReqItemSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public CrdMmReqItemSubsqntProcFlowByKeyFluentHelper getCrdMmReqItemSubsqntProcFlowByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final UUID docRelationshipUUID )
    {
        return new CrdMmReqItemSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_CrdMmReqItemSubsqntProcFlow",
            creditMemoRequest,
            creditMemoRequestItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPartnerFluentHelper getAllCreditMemoReqItemPartner()
    {
        return new CreditMemoReqItemPartnerFluentHelper(servicePath, "A_CreditMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPartnerByKeyFluentHelper getCreditMemoReqItemPartnerByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String partnerFunction )
    {
        return new CreditMemoReqItemPartnerByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqItemPartner",
            creditMemoRequest,
            creditMemoRequestItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPartnerUpdateFluentHelper updateCreditMemoReqItemPartner(
        @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner )
    {
        return new CreditMemoReqItemPartnerUpdateFluentHelper(
            servicePath,
            creditMemoReqItemPartner,
            "A_CreditMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPartnerDeleteFluentHelper deleteCreditMemoReqItemPartner(
        @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner )
    {
        return new CreditMemoReqItemPartnerDeleteFluentHelper(
            servicePath,
            creditMemoReqItemPartner,
            "A_CreditMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPrcgElmntFluentHelper getAllCreditMemoReqItemPrcgElmnt()
    {
        return new CreditMemoReqItemPrcgElmntFluentHelper(servicePath, "A_CreditMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPrcgElmntByKeyFluentHelper getCreditMemoReqItemPrcgElmntByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new CreditMemoReqItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqItemPrcgElmnt",
            creditMemoRequest,
            creditMemoRequestItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPrcgElmntUpdateFluentHelper updateCreditMemoReqItemPrcgElmnt(
        @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt )
    {
        return new CreditMemoReqItemPrcgElmntUpdateFluentHelper(
            servicePath,
            creditMemoReqItemPrcgElmnt,
            "A_CreditMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemPrcgElmntDeleteFluentHelper deleteCreditMemoReqItemPrcgElmnt(
        @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt )
    {
        return new CreditMemoReqItemPrcgElmntDeleteFluentHelper(
            servicePath,
            creditMemoReqItemPrcgElmnt,
            "A_CreditMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemTextFluentHelper getAllCreditMemoReqItemText()
    {
        return new CreditMemoReqItemTextFluentHelper(servicePath, "A_CreditMemoReqItemText");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemTextByKeyFluentHelper getCreditMemoReqItemTextByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String language,
        final String longTextID )
    {
        return new CreditMemoReqItemTextByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqItemText",
            creditMemoRequest,
            creditMemoRequestItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CreditMemoReqItemTextUpdateFluentHelper updateCreditMemoReqItemText(
        @Nonnull final CreditMemoReqItemText creditMemoReqItemText )
    {
        return new CreditMemoReqItemTextUpdateFluentHelper(
            servicePath,
            creditMemoReqItemText,
            "A_CreditMemoReqItemText");
    }

    @Override
    @Nonnull
    public CreditMemoReqItemTextDeleteFluentHelper deleteCreditMemoReqItemText(
        @Nonnull final CreditMemoReqItemText creditMemoReqItemText )
    {
        return new CreditMemoReqItemTextDeleteFluentHelper(
            servicePath,
            creditMemoReqItemText,
            "A_CreditMemoReqItemText");
    }

    @Override
    @Nonnull
    public CreditMemoReqPartnerFluentHelper getAllCreditMemoReqPartner()
    {
        return new CreditMemoReqPartnerFluentHelper(servicePath, "A_CreditMemoReqPartner");
    }

    @Override
    @Nonnull
    public
        CreditMemoReqPartnerByKeyFluentHelper
        getCreditMemoReqPartnerByKey( final String creditMemoRequest, final String partnerFunction )
    {
        return new CreditMemoReqPartnerByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqPartner",
            creditMemoRequest,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CreditMemoReqPartnerUpdateFluentHelper updateCreditMemoReqPartner(
        @Nonnull final CreditMemoReqPartner creditMemoReqPartner )
    {
        return new CreditMemoReqPartnerUpdateFluentHelper(servicePath, creditMemoReqPartner, "A_CreditMemoReqPartner");
    }

    @Override
    @Nonnull
    public CreditMemoReqPartnerDeleteFluentHelper deleteCreditMemoReqPartner(
        @Nonnull final CreditMemoReqPartner creditMemoReqPartner )
    {
        return new CreditMemoReqPartnerDeleteFluentHelper(servicePath, creditMemoReqPartner, "A_CreditMemoReqPartner");
    }

    @Override
    @Nonnull
    public CreditMemoReqPrcgElmntFluentHelper getAllCreditMemoReqPrcgElmnt()
    {
        return new CreditMemoReqPrcgElmntFluentHelper(servicePath, "A_CreditMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqPrcgElmntByKeyFluentHelper getCreditMemoReqPrcgElmntByKey(
        final String creditMemoRequest,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new CreditMemoReqPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqPrcgElmnt",
            creditMemoRequest,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public CreditMemoReqPrcgElmntUpdateFluentHelper updateCreditMemoReqPrcgElmnt(
        @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt )
    {
        return new CreditMemoReqPrcgElmntUpdateFluentHelper(
            servicePath,
            creditMemoReqPrcgElmnt,
            "A_CreditMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqPrcgElmntDeleteFluentHelper deleteCreditMemoReqPrcgElmnt(
        @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt )
    {
        return new CreditMemoReqPrcgElmntDeleteFluentHelper(
            servicePath,
            creditMemoReqPrcgElmnt,
            "A_CreditMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public CreditMemoReqSubsqntProcFlowFluentHelper getAllCreditMemoReqSubsqntProcFlow()
    {
        return new CreditMemoReqSubsqntProcFlowFluentHelper(servicePath, "A_CreditMemoReqSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public
        CreditMemoReqSubsqntProcFlowByKeyFluentHelper
        getCreditMemoReqSubsqntProcFlowByKey( final String creditMemoRequest, final String subsequentDocument )
    {
        return new CreditMemoReqSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqSubsqntProcFlow",
            creditMemoRequest,
            subsequentDocument);
    }

    @Override
    @Nonnull
    public CreditMemoReqTextFluentHelper getAllCreditMemoReqText()
    {
        return new CreditMemoReqTextFluentHelper(servicePath, "A_CreditMemoReqText");
    }

    @Override
    @Nonnull
    public
        CreditMemoReqTextByKeyFluentHelper
        getCreditMemoReqTextByKey( final String creditMemoRequest, final String language, final String longTextID )
    {
        return new CreditMemoReqTextByKeyFluentHelper(
            servicePath,
            "A_CreditMemoReqText",
            creditMemoRequest,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CreditMemoReqTextUpdateFluentHelper updateCreditMemoReqText(
        @Nonnull final CreditMemoReqText creditMemoReqText )
    {
        return new CreditMemoReqTextUpdateFluentHelper(servicePath, creditMemoReqText, "A_CreditMemoReqText");
    }

    @Override
    @Nonnull
    public CreditMemoReqTextDeleteFluentHelper deleteCreditMemoReqText(
        @Nonnull final CreditMemoReqText creditMemoReqText )
    {
        return new CreditMemoReqTextDeleteFluentHelper(servicePath, creditMemoReqText, "A_CreditMemoReqText");
    }

    @Override
    @Nonnull
    public CreditMemoRequestFluentHelper getAllCreditMemoRequest()
    {
        return new CreditMemoRequestFluentHelper(servicePath, "A_CreditMemoRequest");
    }

    @Override
    @Nonnull
    public CreditMemoRequestByKeyFluentHelper getCreditMemoRequestByKey( final String creditMemoRequest )
    {
        return new CreditMemoRequestByKeyFluentHelper(servicePath, "A_CreditMemoRequest", creditMemoRequest);
    }

    @Override
    @Nonnull
    public CreditMemoRequestCreateFluentHelper createCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return new CreditMemoRequestCreateFluentHelper(servicePath, creditMemoRequest, "A_CreditMemoRequest");
    }

    @Override
    @Nonnull
    public CreditMemoRequestUpdateFluentHelper updateCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return new CreditMemoRequestUpdateFluentHelper(servicePath, creditMemoRequest, "A_CreditMemoRequest");
    }

    @Override
    @Nonnull
    public CreditMemoRequestDeleteFluentHelper deleteCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return new CreditMemoRequestDeleteFluentHelper(servicePath, creditMemoRequest, "A_CreditMemoRequest");
    }

    @Override
    @Nonnull
    public CreditMemoRequestItemFluentHelper getAllCreditMemoRequestItem()
    {
        return new CreditMemoRequestItemFluentHelper(servicePath, "A_CreditMemoRequestItem");
    }

    @Override
    @Nonnull
    public
        CreditMemoRequestItemByKeyFluentHelper
        getCreditMemoRequestItemByKey( final String creditMemoRequest, final String creditMemoRequestItem )
    {
        return new CreditMemoRequestItemByKeyFluentHelper(
            servicePath,
            "A_CreditMemoRequestItem",
            creditMemoRequest,
            creditMemoRequestItem);
    }

    @Override
    @Nonnull
    public CreditMemoRequestItemCreateFluentHelper createCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return new CreditMemoRequestItemCreateFluentHelper(
            servicePath,
            creditMemoRequestItem,
            "A_CreditMemoRequestItem");
    }

    @Override
    @Nonnull
    public CreditMemoRequestItemUpdateFluentHelper updateCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return new CreditMemoRequestItemUpdateFluentHelper(
            servicePath,
            creditMemoRequestItem,
            "A_CreditMemoRequestItem");
    }

    @Override
    @Nonnull
    public CreditMemoRequestItemDeleteFluentHelper deleteCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return new CreditMemoRequestItemDeleteFluentHelper(
            servicePath,
            creditMemoRequestItem,
            "A_CreditMemoRequestItem");
    }

    @Override
    @Nonnull
    public BusinessAreaStdVHFluentHelper getAllBusinessAreaStdVH()
    {
        return new BusinessAreaStdVHFluentHelper(servicePath, "I_BusinessAreaStdVH");
    }

    @Override
    @Nonnull
    public BusinessAreaStdVHByKeyFluentHelper getBusinessAreaStdVHByKey( final String businessArea )
    {
        return new BusinessAreaStdVHByKeyFluentHelper(servicePath, "I_BusinessAreaStdVH", businessArea);
    }

    @Override
    @Nonnull
    public CompanyCodeStdVHFluentHelper getAllCompanyCodeStdVH()
    {
        return new CompanyCodeStdVHFluentHelper(servicePath, "I_CompanyCodeStdVH");
    }

    @Override
    @Nonnull
    public CompanyCodeStdVHByKeyFluentHelper getCompanyCodeStdVHByKey( final String companyCode )
    {
        return new CompanyCodeStdVHByKeyFluentHelper(servicePath, "I_CompanyCodeStdVH", companyCode);
    }

    @Override
    @Nonnull
    public ControllingAreaStdVHFluentHelper getAllControllingAreaStdVH()
    {
        return new ControllingAreaStdVHFluentHelper(servicePath, "I_ControllingAreaStdVH");
    }

    @Override
    @Nonnull
    public ControllingAreaStdVHByKeyFluentHelper getControllingAreaStdVHByKey( final String controllingArea )
    {
        return new ControllingAreaStdVHByKeyFluentHelper(servicePath, "I_ControllingAreaStdVH", controllingArea);
    }

    @Override
    @Nonnull
    public ControllingObjectStdVHFluentHelper getAllControllingObjectStdVH()
    {
        return new ControllingObjectStdVHFluentHelper(servicePath, "I_ControllingObjectStdVH");
    }

    @Override
    @Nonnull
    public ControllingObjectStdVHByKeyFluentHelper getControllingObjectStdVHByKey( final String controllingObject )
    {
        return new ControllingObjectStdVHByKeyFluentHelper(servicePath, "I_ControllingObjectStdVH", controllingObject);
    }

    @Override
    @Nonnull
    public CreditControlAreaStdVHFluentHelper getAllCreditControlAreaStdVH()
    {
        return new CreditControlAreaStdVHFluentHelper(servicePath, "I_CreditControlAreaStdVH");
    }

    @Override
    @Nonnull
    public CreditControlAreaStdVHByKeyFluentHelper getCreditControlAreaStdVHByKey( final String creditControlArea )
    {
        return new CreditControlAreaStdVHByKeyFluentHelper(servicePath, "I_CreditControlAreaStdVH", creditControlArea);
    }

    @Override
    @Nonnull
    public Customer_VHFluentHelper getAllCustomer_VH()
    {
        return new Customer_VHFluentHelper(servicePath, "I_Customer_VH");
    }

    @Override
    @Nonnull
    public Customer_VHByKeyFluentHelper getCustomer_VHByKey( final String customer )
    {
        return new Customer_VHByKeyFluentHelper(servicePath, "I_Customer_VH", customer);
    }

    @Override
    @Nonnull
    public MaterialStdVHFluentHelper getAllMaterialStdVH()
    {
        return new MaterialStdVHFluentHelper(servicePath, "I_MaterialStdVH");
    }

    @Override
    @Nonnull
    public MaterialStdVHByKeyFluentHelper getMaterialStdVHByKey( final String material )
    {
        return new MaterialStdVHByKeyFluentHelper(servicePath, "I_MaterialStdVH", material);
    }

    @Override
    @Nonnull
    public ProductStdVHFluentHelper getAllProductStdVH()
    {
        return new ProductStdVHFluentHelper(servicePath, "I_ProductStdVH");
    }

    @Override
    @Nonnull
    public ProductStdVHByKeyFluentHelper getProductStdVHByKey( final String product )
    {
        return new ProductStdVHByKeyFluentHelper(servicePath, "I_ProductStdVH", product);
    }

    @Override
    @Nonnull
    public SalesDealStdVHFluentHelper getAllSalesDealStdVH()
    {
        return new SalesDealStdVHFluentHelper(servicePath, "I_SalesDealStdVH");
    }

    @Override
    @Nonnull
    public SalesDealStdVHByKeyFluentHelper getSalesDealStdVHByKey( final String salesDeal )
    {
        return new SalesDealStdVHByKeyFluentHelper(servicePath, "I_SalesDealStdVH", salesDeal);
    }

    @Override
    @Nonnull
    public ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String creditMemoRequest )
    {
        return new ReleaseApprovalRequestFluentHelper(servicePath, creditMemoRequest);
    }

    @Override
    @Nonnull
    public RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String creditMemoRequest )
    {
        return new RejectApprovalRequestFluentHelper(servicePath, creditMemoRequest);
    }

}
