/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoRequestSimulation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoRequestSimulationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.batch.DefaultCreditMemoRequestSimulateServiceBatch;

/**
 * <p>
 * The API gives you information about credit memo request data, business partners, and pricing elements. The response
 * is provided synchronously. The simulated credit memo request is not saved.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c9/89713e57b2466dbbacde00ac7f82ae/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_CREDIT_MEMO_REQ_SIMLN_SRV_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_CREDIT_MEMO_REQ_SIMLN_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Credit Memo Request Integration(SAP_COM_0158)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1EZ'>Credit Memo Processing(1EZ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKL'>Invoice Correction Process with Credit Memo(BKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OKL'>Invoice Correction Process with Credit Memo(OKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PEZ'>Credit Memo Processing(PEZ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Credit Memo Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCreditMemoRequestSimulateService" )
@Deprecated
public class DefaultCreditMemoRequestSimulateService implements CreditMemoRequestSimulateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CreditMemoRequestSimulateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCreditMemoRequestSimulateService()
    {
        servicePath = CreditMemoRequestSimulateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCreditMemoRequestSimulateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCreditMemoRequestSimulateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCreditMemoRequestSimulateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCreditMemoRequestSimulateServiceBatch batch()
    {
        return new DefaultCreditMemoRequestSimulateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CreditMemoRequestSimulationCreateFluentHelper createCreditMemoRequestSimulation(
        @Nonnull final CreditMemoRequestSimulation creditMemoRequestSimulation )
    {
        return new CreditMemoRequestSimulationCreateFluentHelper(
            servicePath,
            creditMemoRequestSimulation,
            "A_CreditMemoRequestSimulation");
    }

}
