/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.batch.DefaultCustomerAndSupplierIndustryServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve customer/supplier industry master data. You can read information like key and
 * text in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/98/d64eac767f45ff95e6a19626d79701/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMERSUPPLIERINDUSTRY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMERSUPPLIERINDUSTRY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerAndSupplierIndustryService" )
@Deprecated
public class DefaultCustomerAndSupplierIndustryService implements CustomerAndSupplierIndustryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerAndSupplierIndustryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerAndSupplierIndustryService()
    {
        servicePath = CustomerAndSupplierIndustryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerAndSupplierIndustryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerAndSupplierIndustryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerAndSupplierIndustryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerAndSupplierIndustryServiceBatch batch()
    {
        return new DefaultCustomerAndSupplierIndustryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CustomerSupplierIndustryFluentHelper getAllCustomerSupplierIndustry()
    {
        return new CustomerSupplierIndustryFluentHelper(servicePath, "A_CustomerSupplierIndustry");
    }

    @Override
    @Nonnull
    public CustomerSupplierIndustryByKeyFluentHelper getCustomerSupplierIndustryByKey( final String industry )
    {
        return new CustomerSupplierIndustryByKeyFluentHelper(servicePath, "A_CustomerSupplierIndustry", industry);
    }

    @Override
    @Nonnull
    public CustomerSupplierIndustryTextFluentHelper getAllCustomerSupplierIndustryText()
    {
        return new CustomerSupplierIndustryTextFluentHelper(servicePath, "A_CustomerSupplierIndustryText");
    }

    @Override
    @Nonnull
    public
        CustomerSupplierIndustryTextByKeyFluentHelper
        getCustomerSupplierIndustryTextByKey( final String language, final String industry )
    {
        return new CustomerSupplierIndustryTextByKeyFluentHelper(
            servicePath,
            "A_CustomerSupplierIndustryText",
            language,
            industry);
    }

}
