/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFileByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFileFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.batch.DefaultCustomerDataReturnFileDownloadServiceBatch;

/**
 * <p>
 * This service can be consumed by external application to download all business data from SAP S/4HANA Cloud systems,
 * prepared using Customer Data Return - Extraction app, to a local machine or third party storage.
 *
 * You can use this service to: - Download prepared files in compressed format - Retrieve list of prepared files -
 * Retrieve download status details of files
 *
 * It returns an appropriate success or error response while performing the operations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/10/6c356af8a341a694596b864967f8a3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CDR_FILE_DOWNLOAD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CDR_FILE_DOWNLOAD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Data Return Integration(SAP_COM_0589)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/5I9'>Customer Data Return(5I9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerDataReturnFileDownloadService" )
@Deprecated
public class DefaultCustomerDataReturnFileDownloadService implements CustomerDataReturnFileDownloadService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerDataReturnFileDownloadService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerDataReturnFileDownloadService()
    {
        servicePath = CustomerDataReturnFileDownloadService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerDataReturnFileDownloadService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerDataReturnFileDownloadService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerDataReturnFileDownloadService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerDataReturnFileDownloadServiceBatch batch()
    {
        return new DefaultCustomerDataReturnFileDownloadServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ListFileFluentHelper getAllListFile()
    {
        return new ListFileFluentHelper(servicePath, "ListFiles");
    }

    @Override
    @Nonnull
    public DownloadFileByKeyFluentHelper getDownloadFileByKey( final String packageName, final String fileName )
    {
        return new DownloadFileByKeyFluentHelper(servicePath, "DownloadFile", packageName, fileName);
    }

    @Override
    @Nonnull
    public FileDownloadStatusFluentHelper getAllFileDownloadStatus()
    {
        return new FileDownloadStatusFluentHelper(servicePath, "FileDownloadStatusSet");
    }

}
