/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.batch.DefaultCustomerMaterialServiceBatch;

/**
 * <p>
 * The service contains one entity only for customer material. If there are any issues when creating, reading, updating,
 * or deleting the customer material, the system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/52/9318c3a0014f1bb1911541546569a2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Material Info Record Integration(SAP_COM_0134)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerMaterialService" )
@Deprecated
public class DefaultCustomerMaterialService implements CustomerMaterialService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerMaterialService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerMaterialService()
    {
        servicePath = CustomerMaterialService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerMaterialService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerMaterialService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerMaterialService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerMaterialServiceBatch batch()
    {
        return new DefaultCustomerMaterialServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CustomerMaterialFluentHelper getAllCustomerMaterial()
    {
        return new CustomerMaterialFluentHelper(servicePath, "A_CustomerMaterial");
    }

    @Override
    @Nonnull
    public CustomerMaterialByKeyFluentHelper getCustomerMaterialByKey(
        final String salesOrganization,
        final String distributionChannel,
        final String customer,
        final String material )
    {
        return new CustomerMaterialByKeyFluentHelper(
            servicePath,
            "A_CustomerMaterial",
            salesOrganization,
            distributionChannel,
            customer,
            material);
    }

    @Override
    @Nonnull
    public CustomerMaterialCreateFluentHelper createCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial )
    {
        return new CustomerMaterialCreateFluentHelper(servicePath, customerMaterial, "A_CustomerMaterial");
    }

    @Override
    @Nonnull
    public CustomerMaterialUpdateFluentHelper updateCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial )
    {
        return new CustomerMaterialUpdateFluentHelper(servicePath, customerMaterial, "A_CustomerMaterial");
    }

    @Override
    @Nonnull
    public CustomerMaterialDeleteFluentHelper deleteCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial )
    {
        return new CustomerMaterialDeleteFluentHelper(servicePath, customerMaterial, "A_CustomerMaterial");
    }

}
