/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.batch.DefaultCustomerReturnServiceBatch;

/**
 * <p>
 * You can use this service to integrate external applications with customer return processing in SAP S/4HANA Cloud. In
 * every API call, you can make use of the following operations: - You can retrieve customer returns. Apply any of the
 * filters provided or retrieve all existing data. - You can create customer returns. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, item, item partner,
 * and item pricing element). You cannot create entities without including any related entities. - For existing customer
 * returns, you can create new items. Note that you must use “deep insert” requests (with the following entities: item
 * partner and item pricing element). You cannot create entities without including any related entities. - For existing
 * customer returns, you can update the header, header partner, header pricing element, item, item partner, and item
 * pricing element. - For existing customer returns, you can delete the header, header partner, header pricing element,
 * item, item partner, and item pricing element..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/69/bd2e81cb394eb0b3d8eae85d6b4517/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_RETURN_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_RETURN_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Return Integration(SAP_COM_0157)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1Z3'>Customer Returns with Direct Shipment from Customer to
 * Supplier(1Z3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Return</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerReturnService" )
@Deprecated
public class DefaultCustomerReturnService implements CustomerReturnService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerReturnService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerReturnService()
    {
        servicePath = CustomerReturnService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerReturnService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerReturnService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnServiceBatch batch()
    {
        return new DefaultCustomerReturnServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CustomerReturnFluentHelper getAllCustomerReturn()
    {
        return new CustomerReturnFluentHelper(servicePath, "A_CustomerReturn");
    }

    @Override
    @Nonnull
    public CustomerReturnByKeyFluentHelper getCustomerReturnByKey( final String customerReturn )
    {
        return new CustomerReturnByKeyFluentHelper(servicePath, "A_CustomerReturn", customerReturn);
    }

    @Override
    @Nonnull
    public CustomerReturnCreateFluentHelper createCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return new CustomerReturnCreateFluentHelper(servicePath, customerReturn, "A_CustomerReturn");
    }

    @Override
    @Nonnull
    public CustomerReturnUpdateFluentHelper updateCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return new CustomerReturnUpdateFluentHelper(servicePath, customerReturn, "A_CustomerReturn");
    }

    @Override
    @Nonnull
    public CustomerReturnDeleteFluentHelper deleteCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return new CustomerReturnDeleteFluentHelper(servicePath, customerReturn, "A_CustomerReturn");
    }

    @Override
    @Nonnull
    public CustomerReturnItemFluentHelper getAllCustomerReturnItem()
    {
        return new CustomerReturnItemFluentHelper(servicePath, "A_CustomerReturnItem");
    }

    @Override
    @Nonnull
    public
        CustomerReturnItemByKeyFluentHelper
        getCustomerReturnItemByKey( final String customerReturn, final String customerReturnItem )
    {
        return new CustomerReturnItemByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnItem",
            customerReturn,
            customerReturnItem);
    }

    @Override
    @Nonnull
    public CustomerReturnItemCreateFluentHelper createCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return new CustomerReturnItemCreateFluentHelper(servicePath, customerReturnItem, "A_CustomerReturnItem");
    }

    @Override
    @Nonnull
    public CustomerReturnItemUpdateFluentHelper updateCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return new CustomerReturnItemUpdateFluentHelper(servicePath, customerReturnItem, "A_CustomerReturnItem");
    }

    @Override
    @Nonnull
    public CustomerReturnItemDeleteFluentHelper deleteCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return new CustomerReturnItemDeleteFluentHelper(servicePath, customerReturnItem, "A_CustomerReturnItem");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPartnerFluentHelper getAllCustomerReturnItemPartner()
    {
        return new CustomerReturnItemPartnerFluentHelper(servicePath, "A_CustomerReturnItemPartner");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPartnerByKeyFluentHelper getCustomerReturnItemPartnerByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String partnerFunction )
    {
        return new CustomerReturnItemPartnerByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnItemPartner",
            customerReturn,
            customerReturnItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CustomerReturnItemPartnerUpdateFluentHelper updateCustomerReturnItemPartner(
        @Nonnull final CustomerReturnItemPartner customerReturnItemPartner )
    {
        return new CustomerReturnItemPartnerUpdateFluentHelper(
            servicePath,
            customerReturnItemPartner,
            "A_CustomerReturnItemPartner");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPartnerDeleteFluentHelper deleteCustomerReturnItemPartner(
        @Nonnull final CustomerReturnItemPartner customerReturnItemPartner )
    {
        return new CustomerReturnItemPartnerDeleteFluentHelper(
            servicePath,
            customerReturnItemPartner,
            "A_CustomerReturnItemPartner");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPrcgElmntFluentHelper getAllCustomerReturnItemPrcgElmnt()
    {
        return new CustomerReturnItemPrcgElmntFluentHelper(servicePath, "A_CustomerReturnItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPrcgElmntByKeyFluentHelper getCustomerReturnItemPrcgElmntByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new CustomerReturnItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnItemPrcgElmnt",
            customerReturn,
            customerReturnItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public CustomerReturnItemPrcgElmntUpdateFluentHelper updateCustomerReturnItemPrcgElmnt(
        @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt )
    {
        return new CustomerReturnItemPrcgElmntUpdateFluentHelper(
            servicePath,
            customerReturnItemPrcgElmnt,
            "A_CustomerReturnItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnItemPrcgElmntDeleteFluentHelper deleteCustomerReturnItemPrcgElmnt(
        @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt )
    {
        return new CustomerReturnItemPrcgElmntDeleteFluentHelper(
            servicePath,
            customerReturnItemPrcgElmnt,
            "A_CustomerReturnItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnItemRelatedObjFluentHelper getAllCustomerReturnItemRelatedObj()
    {
        return new CustomerReturnItemRelatedObjFluentHelper(servicePath, "A_CustomerReturnItemRelatedObj");
    }

    @Override
    @Nonnull
    public CustomerReturnItemRelatedObjByKeyFluentHelper getCustomerReturnItemRelatedObjByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String sDDocRelatedObjectSequenceNmbr )
    {
        return new CustomerReturnItemRelatedObjByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnItemRelatedObj",
            customerReturn,
            customerReturnItem,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public CustomerReturnItemRelatedObjCreateFluentHelper createCustomerReturnItemRelatedObj(
        @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj )
    {
        return new CustomerReturnItemRelatedObjCreateFluentHelper(
            servicePath,
            customerReturnItemRelatedObj,
            "A_CustomerReturnItemRelatedObj");
    }

    @Override
    @Nonnull
    public CustomerReturnItemRelatedObjDeleteFluentHelper deleteCustomerReturnItemRelatedObj(
        @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj )
    {
        return new CustomerReturnItemRelatedObjDeleteFluentHelper(
            servicePath,
            customerReturnItemRelatedObj,
            "A_CustomerReturnItemRelatedObj");
    }

    @Override
    @Nonnull
    public CustomerReturnItemTextFluentHelper getAllCustomerReturnItemText()
    {
        return new CustomerReturnItemTextFluentHelper(servicePath, "A_CustomerReturnItemText");
    }

    @Override
    @Nonnull
    public CustomerReturnItemTextByKeyFluentHelper getCustomerReturnItemTextByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String language,
        final String longTextID )
    {
        return new CustomerReturnItemTextByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnItemText",
            customerReturn,
            customerReturnItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustomerReturnItemTextUpdateFluentHelper updateCustomerReturnItemText(
        @Nonnull final CustomerReturnItemText customerReturnItemText )
    {
        return new CustomerReturnItemTextUpdateFluentHelper(
            servicePath,
            customerReturnItemText,
            "A_CustomerReturnItemText");
    }

    @Override
    @Nonnull
    public CustomerReturnItemTextDeleteFluentHelper deleteCustomerReturnItemText(
        @Nonnull final CustomerReturnItemText customerReturnItemText )
    {
        return new CustomerReturnItemTextDeleteFluentHelper(
            servicePath,
            customerReturnItemText,
            "A_CustomerReturnItemText");
    }

    @Override
    @Nonnull
    public CustomerReturnOverviewStatusFluentHelper getAllCustomerReturnOverviewStatus()
    {
        return new CustomerReturnOverviewStatusFluentHelper(servicePath, "A_CustomerReturnOverviewStatus");
    }

    @Override
    @Nonnull
    public CustomerReturnOverviewStatusByKeyFluentHelper getCustomerReturnOverviewStatusByKey(
        final String retsMgmtProcess )
    {
        return new CustomerReturnOverviewStatusByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnOverviewStatus",
            retsMgmtProcess);
    }

    @Override
    @Nonnull
    public CustomerReturnPartnerFluentHelper getAllCustomerReturnPartner()
    {
        return new CustomerReturnPartnerFluentHelper(servicePath, "A_CustomerReturnPartner");
    }

    @Override
    @Nonnull
    public
        CustomerReturnPartnerByKeyFluentHelper
        getCustomerReturnPartnerByKey( final String customerReturn, final String partnerFunction )
    {
        return new CustomerReturnPartnerByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnPartner",
            customerReturn,
            partnerFunction);
    }

    @Override
    @Nonnull
    public CustomerReturnPartnerUpdateFluentHelper updateCustomerReturnPartner(
        @Nonnull final CustomerReturnPartner customerReturnPartner )
    {
        return new CustomerReturnPartnerUpdateFluentHelper(
            servicePath,
            customerReturnPartner,
            "A_CustomerReturnPartner");
    }

    @Override
    @Nonnull
    public CustomerReturnPartnerDeleteFluentHelper deleteCustomerReturnPartner(
        @Nonnull final CustomerReturnPartner customerReturnPartner )
    {
        return new CustomerReturnPartnerDeleteFluentHelper(
            servicePath,
            customerReturnPartner,
            "A_CustomerReturnPartner");
    }

    @Override
    @Nonnull
    public CustomerReturnPrcgElmntFluentHelper getAllCustomerReturnPrcgElmnt()
    {
        return new CustomerReturnPrcgElmntFluentHelper(servicePath, "A_CustomerReturnPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnPrcgElmntByKeyFluentHelper getCustomerReturnPrcgElmntByKey(
        final String customerReturn,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new CustomerReturnPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnPrcgElmnt",
            customerReturn,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public CustomerReturnPrcgElmntUpdateFluentHelper updateCustomerReturnPrcgElmnt(
        @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt )
    {
        return new CustomerReturnPrcgElmntUpdateFluentHelper(
            servicePath,
            customerReturnPrcgElmnt,
            "A_CustomerReturnPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnPrcgElmntDeleteFluentHelper deleteCustomerReturnPrcgElmnt(
        @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt )
    {
        return new CustomerReturnPrcgElmntDeleteFluentHelper(
            servicePath,
            customerReturnPrcgElmnt,
            "A_CustomerReturnPrcgElmnt");
    }

    @Override
    @Nonnull
    public CustomerReturnProcessStepFluentHelper getAllCustomerReturnProcessStep()
    {
        return new CustomerReturnProcessStepFluentHelper(servicePath, "A_CustomerReturnProcessStep");
    }

    @Override
    @Nonnull
    public CustomerReturnProcessStepByKeyFluentHelper getCustomerReturnProcessStepByKey(
        final String retsMgmtProcess,
        final String retsMgmtProcessItem,
        final String retsMgmtProcItmQtySplit,
        final String retsMgmtProcessStep,
        final String returnsDocumentType,
        final String returnsDocument,
        final String returnsDocumentItem )
    {
        return new CustomerReturnProcessStepByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnProcessStep",
            retsMgmtProcess,
            retsMgmtProcessItem,
            retsMgmtProcItmQtySplit,
            retsMgmtProcessStep,
            returnsDocumentType,
            returnsDocument,
            returnsDocumentItem);
    }

    @Override
    @Nonnull
    public CustomerReturnRelatedObjectFluentHelper getAllCustomerReturnRelatedObject()
    {
        return new CustomerReturnRelatedObjectFluentHelper(servicePath, "A_CustomerReturnRelatedObject");
    }

    @Override
    @Nonnull
    public
        CustomerReturnRelatedObjectByKeyFluentHelper
        getCustomerReturnRelatedObjectByKey( final String customerReturn, final String sDDocRelatedObjectSequenceNmbr )
    {
        return new CustomerReturnRelatedObjectByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnRelatedObject",
            customerReturn,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public CustomerReturnRelatedObjectCreateFluentHelper createCustomerReturnRelatedObject(
        @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject )
    {
        return new CustomerReturnRelatedObjectCreateFluentHelper(
            servicePath,
            customerReturnRelatedObject,
            "A_CustomerReturnRelatedObject");
    }

    @Override
    @Nonnull
    public CustomerReturnRelatedObjectDeleteFluentHelper deleteCustomerReturnRelatedObject(
        @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject )
    {
        return new CustomerReturnRelatedObjectDeleteFluentHelper(
            servicePath,
            customerReturnRelatedObject,
            "A_CustomerReturnRelatedObject");
    }

    @Override
    @Nonnull
    public CustomerReturnScheduleLineFluentHelper getAllCustomerReturnScheduleLine()
    {
        return new CustomerReturnScheduleLineFluentHelper(servicePath, "A_CustomerReturnScheduleLine");
    }

    @Override
    @Nonnull
    public CustomerReturnScheduleLineByKeyFluentHelper getCustomerReturnScheduleLineByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String scheduleLine )
    {
        return new CustomerReturnScheduleLineByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnScheduleLine",
            customerReturn,
            customerReturnItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public CustomerReturnSerialNumberFluentHelper getAllCustomerReturnSerialNumber()
    {
        return new CustomerReturnSerialNumberFluentHelper(servicePath, "A_CustomerReturnSerialNumber");
    }

    @Override
    @Nonnull
    public CustomerReturnSerialNumberByKeyFluentHelper getCustomerReturnSerialNumberByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String serialNumber )
    {
        return new CustomerReturnSerialNumberByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnSerialNumber",
            customerReturn,
            customerReturnItem,
            serialNumber);
    }

    @Override
    @Nonnull
    public CustomerReturnTextFluentHelper getAllCustomerReturnText()
    {
        return new CustomerReturnTextFluentHelper(servicePath, "A_CustomerReturnText");
    }

    @Override
    @Nonnull
    public
        CustomerReturnTextByKeyFluentHelper
        getCustomerReturnTextByKey( final String customerReturn, final String language, final String longTextID )
    {
        return new CustomerReturnTextByKeyFluentHelper(
            servicePath,
            "A_CustomerReturnText",
            customerReturn,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CustomerReturnTextUpdateFluentHelper updateCustomerReturnText(
        @Nonnull final CustomerReturnText customerReturnText )
    {
        return new CustomerReturnTextUpdateFluentHelper(servicePath, customerReturnText, "A_CustomerReturnText");
    }

    @Override
    @Nonnull
    public CustomerReturnTextDeleteFluentHelper deleteCustomerReturnText(
        @Nonnull final CustomerReturnText customerReturnText )
    {
        return new CustomerReturnTextDeleteFluentHelper(servicePath, customerReturnText, "A_CustomerReturnText");
    }

    @Override
    @Nonnull
    public RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String customerReturn )
    {
        return new RejectApprovalRequestFluentHelper(servicePath, customerReturn);
    }

    @Override
    @Nonnull
    public ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String customerReturn )
    {
        return new ReleaseApprovalRequestFluentHelper(servicePath, customerReturn);
    }

}
