/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.batch.DefaultCustomerReturnSimulateServiceBatch;

/**
 * <p>
 * The API gives you information about the simulated returns order, such as header and item data, pricing, and business
 * partners. The response is provided synchronously. The simulated returns order is not saved.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8b/21e92ee26b4da29f0ce9654a1d587e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_CUSTRET_SIMULATION_SRV_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_CUSTRET_SIMULATION_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Return Integration(SAP_COM_0157)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1Z3'>Customer Returns with Direct Shipment from Customer to
 * Supplier(1Z3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Return</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerReturnSimulateService" )
@Deprecated
public class DefaultCustomerReturnSimulateService implements CustomerReturnSimulateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerReturnSimulateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerReturnSimulateService()
    {
        servicePath = CustomerReturnSimulateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerReturnSimulateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnSimulateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerReturnSimulateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnSimulateServiceBatch batch()
    {
        return new DefaultCustomerReturnSimulateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CustomerReturnSimulationCreateFluentHelper createCustomerReturnSimulation(
        @Nonnull final CustomerReturnSimulation customerReturnSimulation )
    {
        return new CustomerReturnSimulationCreateFluentHelper(
            servicePath,
            customerReturnSimulation,
            "A_CustomerReturnSimulation");
    }

}
