/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliverySrlNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.batch.DefaultCustomerReturnsDeliveryServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete customer returns deliveries. It can be consumed in Fiori
 * apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/93/3de0f594524ddfa75f969a95656ef2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_RETURNS_DELIVERY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_RETURNS_DELIVERY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Returns Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/API_CUSTOMER_RETURNS_DELIVERY_SRV_0002"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerReturnsDeliveryService" )
@Deprecated
public class DefaultCustomerReturnsDeliveryService implements CustomerReturnsDeliveryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerReturnsDeliveryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerReturnsDeliveryService()
    {
        servicePath = CustomerReturnsDeliveryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerReturnsDeliveryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnsDeliveryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerReturnsDeliveryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnsDeliveryServiceBatch batch()
    {
        return new DefaultCustomerReturnsDeliveryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryDocFlowByKeyFluentHelper getReturnsDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new ReturnsDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryDocFlowUpdateFluentHelper updateReturnsDeliveryDocFlow(
        @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow )
    {
        return new ReturnsDeliveryDocFlowUpdateFluentHelper(
            servicePath,
            returnsDeliveryDocFlow,
            "A_ReturnsDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderFluentHelper getAllReturnsDeliveryHeader()
    {
        return new ReturnsDeliveryHeaderFluentHelper(servicePath, "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderByKeyFluentHelper getReturnsDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new ReturnsDeliveryHeaderByKeyFluentHelper(servicePath, "A_ReturnsDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderCreateFluentHelper createReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderCreateFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderUpdateFluentHelper updateReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderUpdateFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderDeleteFluentHelper deleteReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderDeleteFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemFluentHelper getAllReturnsDeliveryItem()
    {
        return new ReturnsDeliveryItemFluentHelper(servicePath, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public
        ReturnsDeliveryItemByKeyFluentHelper
        getReturnsDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new ReturnsDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemUpdateFluentHelper updateReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return new ReturnsDeliveryItemUpdateFluentHelper(servicePath, returnsDeliveryItem, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemDeleteFluentHelper deleteReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return new ReturnsDeliveryItemDeleteFluentHelper(servicePath, returnsDeliveryItem, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public
        ReturnsDeliveryPartnerByKeyFluentHelper
        getReturnsDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new ReturnsDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public ReturnsDeliverySrlNmbrByKeyFluentHelper getReturnsDeliverySrlNmbrByKey(
        final Integer maintenanceItemObjectList )
    {
        return new ReturnsDeliverySrlNmbrByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliverySrlNmbr",
            maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final LocalDateTime actualGoodsMovementDate,
        @Nonnull final String deliveryDocument )
    {
        return new ReverseGoodsReceiptFluentHelper(servicePath, actualGoodsMovementDate, deliveryDocument);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new ConfirmPutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new PutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new PutawayOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

}
