/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.CreateBatchSplitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliverySrlNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.batch.DefaultCustomerReturnsDeliveryV2ServiceBatch;

/**
 * <p>
 * This synchronous inbound service enables you to read, create, update, and delete customer returns deliveries. It can
 * be consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/80/7fa67fc625453bad4756e4832f42f5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_RETURNS_DELIVERY_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_RETURNS_DELIVERY_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Returns Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultCustomerReturnsDeliveryV2Service" )
@Deprecated
public class DefaultCustomerReturnsDeliveryV2Service implements CustomerReturnsDeliveryV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link CustomerReturnsDeliveryV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultCustomerReturnsDeliveryV2Service()
    {
        servicePath = CustomerReturnsDeliveryV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultCustomerReturnsDeliveryV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnsDeliveryV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultCustomerReturnsDeliveryV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultCustomerReturnsDeliveryV2ServiceBatch batch()
    {
        return new DefaultCustomerReturnsDeliveryV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryDocFlowByKeyFluentHelper getReturnsDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new ReturnsDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryDocFlowUpdateFluentHelper updateReturnsDeliveryDocFlow(
        @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow )
    {
        return new ReturnsDeliveryDocFlowUpdateFluentHelper(
            servicePath,
            returnsDeliveryDocFlow,
            "A_ReturnsDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderFluentHelper getAllReturnsDeliveryHeader()
    {
        return new ReturnsDeliveryHeaderFluentHelper(servicePath, "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderByKeyFluentHelper getReturnsDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new ReturnsDeliveryHeaderByKeyFluentHelper(servicePath, "A_ReturnsDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderCreateFluentHelper createReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderCreateFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderUpdateFluentHelper updateReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderUpdateFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryHeaderDeleteFluentHelper deleteReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return new ReturnsDeliveryHeaderDeleteFluentHelper(
            servicePath,
            returnsDeliveryHeader,
            "A_ReturnsDeliveryHeader");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemFluentHelper getAllReturnsDeliveryItem()
    {
        return new ReturnsDeliveryItemFluentHelper(servicePath, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public
        ReturnsDeliveryItemByKeyFluentHelper
        getReturnsDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new ReturnsDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemUpdateFluentHelper updateReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return new ReturnsDeliveryItemUpdateFluentHelper(servicePath, returnsDeliveryItem, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public ReturnsDeliveryItemDeleteFluentHelper deleteReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return new ReturnsDeliveryItemDeleteFluentHelper(servicePath, returnsDeliveryItem, "A_ReturnsDeliveryItem");
    }

    @Override
    @Nonnull
    public
        ReturnsDeliveryPartnerByKeyFluentHelper
        getReturnsDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new ReturnsDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public ReturnsDeliverySrlNmbrByKeyFluentHelper getReturnsDeliverySrlNmbrByKey(
        final Long maintenanceItemObjectList )
    {
        return new ReturnsDeliverySrlNmbrByKeyFluentHelper(
            servicePath,
            "A_ReturnsDeliverySrlNmbr",
            maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate )
    {
        return new ReverseGoodsReceiptFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public PostGoodsReceiptFluentHelper postGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nullable final LocalDateTime actualGoodsMovementDate )
    {
        return new PostGoodsReceiptFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

    @Override
    @Nonnull
    public ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument )
    {
        return new ConfirmPutawayOneItemFluentHelper(servicePath, deliveryDocumentItem, deliveryDocument);
    }

    @Override
    @Nonnull
    public PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument )
    {
        return new PutawayAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument )
    {
        return new PutawayOneItemFluentHelper(servicePath, deliveryDocumentItem, deliveryDocument);
    }

    @Override
    @Nonnull
    public CreateBatchSplitItemFluentHelper createBatchSplitItem(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String batch,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit,
        @Nullable final BigDecimal pickQuantityInSalesUOM,
        @Nullable final LocalDateTime manufactureDate,
        @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        return new CreateBatchSplitItemFluentHelper(
            servicePath,
            actualDeliveryQuantity,
            batch,
            deliveryDocument,
            deliveryDocumentItem,
            deliveryQuantityUnit,
            pickQuantityInSalesUOM,
            manufactureDate,
            shelfLifeExpirationDate);
    }

    @Override
    @Nonnull
    public SetPutawayQuantityWithBaseQuantityFluentHelper setPutawayQuantityWithBaseQuantity(
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument,
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit )
    {
        return new SetPutawayQuantityWithBaseQuantityFluentHelper(
            servicePath,
            deliveryDocumentItem,
            deliveryDocument,
            baseUnit,
            actualDeliveredQtyInBaseUnit);
    }

    @Override
    @Nonnull
    public PutawayOneItemWithBaseQuantityFluentHelper putawayOneItemWithBaseQuantity(
        @Nonnull final String deliveryDocument,
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String deliveryDocumentItem )
    {
        return new PutawayOneItemWithBaseQuantityFluentHelper(
            servicePath,
            deliveryDocument,
            baseUnit,
            actualDeliveredQtyInBaseUnit,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PutawayOneItemWithSalesQuantityFluentHelper putawayOneItemWithSalesQuantity(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String deliveryQuantityUnit,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new PutawayOneItemWithSalesQuantityFluentHelper(
            servicePath,
            actualDeliveryQuantity,
            deliveryQuantityUnit,
            deliveryDocumentItem,
            deliveryDocument);
    }

}
