/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.batch.DefaultDebitMemoRequestServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire debit memo requests or only
 * parts of the data, using the provided filters. - You can create debit memo requests. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, header text, item,
 * item partner, item pricing element, and item text). You cannot create entities without including any related
 * entities. - For existing debit memo requests, you can create new items. Note that you must use “deep insert” requests
 * (with the following entities: item partner, item pricing element, and item text). You cannot create entities without
 * including any related entities. - For existing debit memo requests, you can update the following entities (that is,
 * you can change the content of their properties): header, header partner, header pricing element, header text, item,
 * item partner, item pricing element, and item text. - For existing debit memo requests, you can delete the header,
 * header partner, header pricing element, header text, item, item partner, item pricing element, and item text. - You
 * can accept or deny approval requests for debit memo requests that cannot be processed without the consent of an
 * approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e7/f50d9ea49d49c7a428da494fce2c44/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEBIT_MEMO_REQUEST_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEBIT_MEMO_REQUEST_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Debit Memo Request Integration(SAP_COM_0159)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1F1'>Debit Memo Processing(1F1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDQ'>Invoice Correction Process with Debit Memo(BDQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ODQ'>Invoice Correction Process with Debit Memo(ODQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OF1'>Debit Memo Processing(OF1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Debit Memo Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDebitMemoRequestService" )
@Deprecated
public class DefaultDebitMemoRequestService implements DebitMemoRequestService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DebitMemoRequestService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDebitMemoRequestService()
    {
        servicePath = DebitMemoRequestService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDebitMemoRequestService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDebitMemoRequestService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDebitMemoRequestService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDebitMemoRequestServiceBatch batch()
    {
        return new DefaultDebitMemoRequestServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DbtMemoReqItmSubsqntProcFlowFluentHelper getAllDbtMemoReqItmSubsqntProcFlow()
    {
        return new DbtMemoReqItmSubsqntProcFlowFluentHelper(servicePath, "A_DbtMemoReqItmSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper getDbtMemoReqItmSubsqntProcFlowByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final UUID docRelationshipUUID )
    {
        return new DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_DbtMemoReqItmSubsqntProcFlow",
            debitMemoRequest,
            debitMemoRequestItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPartnerFluentHelper getAllDebitMemoReqItemPartner()
    {
        return new DebitMemoReqItemPartnerFluentHelper(servicePath, "A_DebitMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPartnerByKeyFluentHelper getDebitMemoReqItemPartnerByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String partnerFunction )
    {
        return new DebitMemoReqItemPartnerByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqItemPartner",
            debitMemoRequest,
            debitMemoRequestItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPartnerUpdateFluentHelper updateDebitMemoReqItemPartner(
        @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner )
    {
        return new DebitMemoReqItemPartnerUpdateFluentHelper(
            servicePath,
            debitMemoReqItemPartner,
            "A_DebitMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPartnerDeleteFluentHelper deleteDebitMemoReqItemPartner(
        @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner )
    {
        return new DebitMemoReqItemPartnerDeleteFluentHelper(
            servicePath,
            debitMemoReqItemPartner,
            "A_DebitMemoReqItemPartner");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPrcgElmntFluentHelper getAllDebitMemoReqItemPrcgElmnt()
    {
        return new DebitMemoReqItemPrcgElmntFluentHelper(servicePath, "A_DebitMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPrcgElmntByKeyFluentHelper getDebitMemoReqItemPrcgElmntByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new DebitMemoReqItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqItemPrcgElmnt",
            debitMemoRequest,
            debitMemoRequestItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPrcgElmntUpdateFluentHelper updateDebitMemoReqItemPrcgElmnt(
        @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt )
    {
        return new DebitMemoReqItemPrcgElmntUpdateFluentHelper(
            servicePath,
            debitMemoReqItemPrcgElmnt,
            "A_DebitMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemPrcgElmntDeleteFluentHelper deleteDebitMemoReqItemPrcgElmnt(
        @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt )
    {
        return new DebitMemoReqItemPrcgElmntDeleteFluentHelper(
            servicePath,
            debitMemoReqItemPrcgElmnt,
            "A_DebitMemoReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemTextFluentHelper getAllDebitMemoReqItemText()
    {
        return new DebitMemoReqItemTextFluentHelper(servicePath, "A_DebitMemoReqItemText");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemTextByKeyFluentHelper getDebitMemoReqItemTextByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String language,
        final String longTextID )
    {
        return new DebitMemoReqItemTextByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqItemText",
            debitMemoRequest,
            debitMemoRequestItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public DebitMemoReqItemTextUpdateFluentHelper updateDebitMemoReqItemText(
        @Nonnull final DebitMemoReqItemText debitMemoReqItemText )
    {
        return new DebitMemoReqItemTextUpdateFluentHelper(servicePath, debitMemoReqItemText, "A_DebitMemoReqItemText");
    }

    @Override
    @Nonnull
    public DebitMemoReqItemTextDeleteFluentHelper deleteDebitMemoReqItemText(
        @Nonnull final DebitMemoReqItemText debitMemoReqItemText )
    {
        return new DebitMemoReqItemTextDeleteFluentHelper(servicePath, debitMemoReqItemText, "A_DebitMemoReqItemText");
    }

    @Override
    @Nonnull
    public DebitMemoReqPartnerFluentHelper getAllDebitMemoReqPartner()
    {
        return new DebitMemoReqPartnerFluentHelper(servicePath, "A_DebitMemoReqPartner");
    }

    @Override
    @Nonnull
    public
        DebitMemoReqPartnerByKeyFluentHelper
        getDebitMemoReqPartnerByKey( final String debitMemoRequest, final String partnerFunction )
    {
        return new DebitMemoReqPartnerByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqPartner",
            debitMemoRequest,
            partnerFunction);
    }

    @Override
    @Nonnull
    public DebitMemoReqPartnerUpdateFluentHelper updateDebitMemoReqPartner(
        @Nonnull final DebitMemoReqPartner debitMemoReqPartner )
    {
        return new DebitMemoReqPartnerUpdateFluentHelper(servicePath, debitMemoReqPartner, "A_DebitMemoReqPartner");
    }

    @Override
    @Nonnull
    public DebitMemoReqPartnerDeleteFluentHelper deleteDebitMemoReqPartner(
        @Nonnull final DebitMemoReqPartner debitMemoReqPartner )
    {
        return new DebitMemoReqPartnerDeleteFluentHelper(servicePath, debitMemoReqPartner, "A_DebitMemoReqPartner");
    }

    @Override
    @Nonnull
    public DebitMemoReqPrcgElmntFluentHelper getAllDebitMemoReqPrcgElmnt()
    {
        return new DebitMemoReqPrcgElmntFluentHelper(servicePath, "A_DebitMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqPrcgElmntByKeyFluentHelper getDebitMemoReqPrcgElmntByKey(
        final String debitMemoRequest,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new DebitMemoReqPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqPrcgElmnt",
            debitMemoRequest,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public DebitMemoReqPrcgElmntUpdateFluentHelper updateDebitMemoReqPrcgElmnt(
        @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt )
    {
        return new DebitMemoReqPrcgElmntUpdateFluentHelper(
            servicePath,
            debitMemoReqPrcgElmnt,
            "A_DebitMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqPrcgElmntDeleteFluentHelper deleteDebitMemoReqPrcgElmnt(
        @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt )
    {
        return new DebitMemoReqPrcgElmntDeleteFluentHelper(
            servicePath,
            debitMemoReqPrcgElmnt,
            "A_DebitMemoReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public DebitMemoReqSubsqntProcFlowFluentHelper getAllDebitMemoReqSubsqntProcFlow()
    {
        return new DebitMemoReqSubsqntProcFlowFluentHelper(servicePath, "A_DebitMemoReqSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public
        DebitMemoReqSubsqntProcFlowByKeyFluentHelper
        getDebitMemoReqSubsqntProcFlowByKey( final String debitMemoRequest, final String subsequentDocument )
    {
        return new DebitMemoReqSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqSubsqntProcFlow",
            debitMemoRequest,
            subsequentDocument);
    }

    @Override
    @Nonnull
    public DebitMemoReqTextFluentHelper getAllDebitMemoReqText()
    {
        return new DebitMemoReqTextFluentHelper(servicePath, "A_DebitMemoReqText");
    }

    @Override
    @Nonnull
    public
        DebitMemoReqTextByKeyFluentHelper
        getDebitMemoReqTextByKey( final String debitMemoRequest, final String language, final String longTextID )
    {
        return new DebitMemoReqTextByKeyFluentHelper(
            servicePath,
            "A_DebitMemoReqText",
            debitMemoRequest,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public DebitMemoReqTextUpdateFluentHelper updateDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText )
    {
        return new DebitMemoReqTextUpdateFluentHelper(servicePath, debitMemoReqText, "A_DebitMemoReqText");
    }

    @Override
    @Nonnull
    public DebitMemoReqTextDeleteFluentHelper deleteDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText )
    {
        return new DebitMemoReqTextDeleteFluentHelper(servicePath, debitMemoReqText, "A_DebitMemoReqText");
    }

    @Override
    @Nonnull
    public DebitMemoRequestFluentHelper getAllDebitMemoRequest()
    {
        return new DebitMemoRequestFluentHelper(servicePath, "A_DebitMemoRequest");
    }

    @Override
    @Nonnull
    public DebitMemoRequestByKeyFluentHelper getDebitMemoRequestByKey( final String debitMemoRequest )
    {
        return new DebitMemoRequestByKeyFluentHelper(servicePath, "A_DebitMemoRequest", debitMemoRequest);
    }

    @Override
    @Nonnull
    public DebitMemoRequestCreateFluentHelper createDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return new DebitMemoRequestCreateFluentHelper(servicePath, debitMemoRequest, "A_DebitMemoRequest");
    }

    @Override
    @Nonnull
    public DebitMemoRequestUpdateFluentHelper updateDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return new DebitMemoRequestUpdateFluentHelper(servicePath, debitMemoRequest, "A_DebitMemoRequest");
    }

    @Override
    @Nonnull
    public DebitMemoRequestDeleteFluentHelper deleteDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return new DebitMemoRequestDeleteFluentHelper(servicePath, debitMemoRequest, "A_DebitMemoRequest");
    }

    @Override
    @Nonnull
    public DebitMemoRequestItemFluentHelper getAllDebitMemoRequestItem()
    {
        return new DebitMemoRequestItemFluentHelper(servicePath, "A_DebitMemoRequestItem");
    }

    @Override
    @Nonnull
    public
        DebitMemoRequestItemByKeyFluentHelper
        getDebitMemoRequestItemByKey( final String debitMemoRequest, final String debitMemoRequestItem )
    {
        return new DebitMemoRequestItemByKeyFluentHelper(
            servicePath,
            "A_DebitMemoRequestItem",
            debitMemoRequest,
            debitMemoRequestItem);
    }

    @Override
    @Nonnull
    public DebitMemoRequestItemCreateFluentHelper createDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return new DebitMemoRequestItemCreateFluentHelper(servicePath, debitMemoRequestItem, "A_DebitMemoRequestItem");
    }

    @Override
    @Nonnull
    public DebitMemoRequestItemUpdateFluentHelper updateDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return new DebitMemoRequestItemUpdateFluentHelper(servicePath, debitMemoRequestItem, "A_DebitMemoRequestItem");
    }

    @Override
    @Nonnull
    public DebitMemoRequestItemDeleteFluentHelper deleteDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return new DebitMemoRequestItemDeleteFluentHelper(servicePath, debitMemoRequestItem, "A_DebitMemoRequestItem");
    }

}
