/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.batch.DefaultDebitMemoRequestSimulateServiceBatch;

/**
 * <p>
 * The API gives you information about debit memo request data, business partners, and pricing elements. The response is
 * provided synchronously. The simulated debit memo request is not saved.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2b/5cfb29c8f14d63b8c8b9781a5c9da0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_DEBIT_MEMO_REQ_SIMLN_SRV_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_DEBIT_MEMO_REQ_SIMLN_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Debit Memo Request Integration(SAP_COM_0159)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1F1'>Debit Memo Processing(1F1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDQ'>Invoice Correction Process with Debit Memo(BDQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ODQ'>Invoice Correction Process with Debit Memo(ODQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OF1'>Debit Memo Processing(OF1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Debit Memo Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDebitMemoRequestSimulateService" )
@Deprecated
public class DefaultDebitMemoRequestSimulateService implements DebitMemoRequestSimulateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DebitMemoRequestSimulateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDebitMemoRequestSimulateService()
    {
        servicePath = DebitMemoRequestSimulateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDebitMemoRequestSimulateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDebitMemoRequestSimulateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDebitMemoRequestSimulateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDebitMemoRequestSimulateServiceBatch batch()
    {
        return new DefaultDebitMemoRequestSimulateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DebitMemoRequestSimulationCreateFluentHelper createDebitMemoRequestSimulation(
        @Nonnull final DebitMemoRequestSimulation debitMemoRequestSimulation )
    {
        return new DebitMemoRequestSimulationCreateFluentHelper(
            servicePath,
            debitMemoRequestSimulation,
            "A_DebitMemoRequestSimulation");
    }

}
