/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.DefectCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcategory.batch.DefaultDefectCategoryServiceBatch;

/**
 * <p>
 *
 * This service is related to the business object Defect. The defect category determines which main reference objects in
 * Quality Management a defect should have..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/cf/b65e02b31649c28bfd85dd348af659/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECTCATEGORY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECTCATEGORY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDefectCategoryService" )
@Deprecated
public class DefaultDefectCategoryService implements DefectCategoryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DefectCategoryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDefectCategoryService()
    {
        servicePath = DefectCategoryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDefectCategoryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDefectCategoryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDefectCategoryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDefectCategoryServiceBatch batch()
    {
        return new DefaultDefectCategoryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DefectCategoryFluentHelper getAllDefectCategory()
    {
        return new DefectCategoryFluentHelper(servicePath, "A_DefectCategory");
    }

    @Override
    @Nonnull
    public DefectCategoryByKeyFluentHelper getDefectCategoryByKey( final String defectCategory )
    {
        return new DefectCategoryByKeyFluentHelper(servicePath, "A_DefectCategory", defectCategory);
    }

    @Override
    @Nonnull
    public DefectCategoryTextFluentHelper getAllDefectCategoryText()
    {
        return new DefectCategoryTextFluentHelper(servicePath, "A_DefectCategoryText");
    }

    @Override
    @Nonnull
    public
        DefectCategoryTextByKeyFluentHelper
        getDefectCategoryTextByKey( final String defectCategory, final String language )
    {
        return new DefectCategoryTextByKeyFluentHelper(servicePath, "A_DefectCategoryText", defectCategory, language);
    }

}
