/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.DefectClassTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectclass.batch.DefaultDefectClassServiceBatch;

/**
 * <p>
 *
 * This service is related to the business object Defect. The defect class in Quality Management is based on a
 * qualitative defect valuation according to impact, for example, critical defect or minor defect..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/21/72622cd3054bd7adb6161b40e6c8bf/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECTCLASS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECTCLASS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect Class</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDefectClassService" )
@Deprecated
public class DefaultDefectClassService implements DefectClassService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DefectClassService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDefectClassService()
    {
        servicePath = DefectClassService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDefectClassService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDefectClassService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDefectClassService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDefectClassServiceBatch batch()
    {
        return new DefaultDefectClassServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DefectClassFluentHelper getAllDefectClass()
    {
        return new DefectClassFluentHelper(servicePath, "A_DefectClass");
    }

    @Override
    @Nonnull
    public DefectClassByKeyFluentHelper getDefectClassByKey( final String defectClass )
    {
        return new DefectClassByKeyFluentHelper(servicePath, "A_DefectClass", defectClass);
    }

    @Override
    @Nonnull
    public DefectClassTextFluentHelper getAllDefectClassText()
    {
        return new DefectClassTextFluentHelper(servicePath, "A_DefectClassText");
    }

    @Override
    @Nonnull
    public DefectClassTextByKeyFluentHelper getDefectClassTextByKey( final String defectClass, final String language )
    {
        return new DefectClassTextByKeyFluentHelper(servicePath, "A_DefectClassText", defectClass, language);
    }

}
