/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeGroupTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.DefectCodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectcodeandcodegroup.batch.DefaultDefectCodeAndCodeGroupServiceBatch;

/**
 * <p>
 *
 * This service is related to the business object Defect. The combination of defect code group and code uniquely
 * identifies the type of the defect in Quality Management in a coded format..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/74/a58fee8d5546c389ac5c52fc906da9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECTCODE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECTCODE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDefectCodeAndCodeGroupService" )
@Deprecated
public class DefaultDefectCodeAndCodeGroupService implements DefectCodeAndCodeGroupService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DefectCodeAndCodeGroupService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDefectCodeAndCodeGroupService()
    {
        servicePath = DefectCodeAndCodeGroupService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDefectCodeAndCodeGroupService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDefectCodeAndCodeGroupService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDefectCodeAndCodeGroupService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDefectCodeAndCodeGroupServiceBatch batch()
    {
        return new DefaultDefectCodeAndCodeGroupServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DefectCodeFluentHelper getAllDefectCode()
    {
        return new DefectCodeFluentHelper(servicePath, "A_DefectCode");
    }

    @Override
    @Nonnull
    public DefectCodeByKeyFluentHelper getDefectCodeByKey( final String defectCodeGroup, final String defectCode )
    {
        return new DefectCodeByKeyFluentHelper(servicePath, "A_DefectCode", defectCodeGroup, defectCode);
    }

    @Override
    @Nonnull
    public DefectCodeGroupFluentHelper getAllDefectCodeGroup()
    {
        return new DefectCodeGroupFluentHelper(servicePath, "A_DefectCodeGroup");
    }

    @Override
    @Nonnull
    public DefectCodeGroupByKeyFluentHelper getDefectCodeGroupByKey( final String defectCodeGroup )
    {
        return new DefectCodeGroupByKeyFluentHelper(servicePath, "A_DefectCodeGroup", defectCodeGroup);
    }

    @Override
    @Nonnull
    public DefectCodeGroupTextFluentHelper getAllDefectCodeGroupText()
    {
        return new DefectCodeGroupTextFluentHelper(servicePath, "A_DefectCodeGroupText");
    }

    @Override
    @Nonnull
    public
        DefectCodeGroupTextByKeyFluentHelper
        getDefectCodeGroupTextByKey( final String defectCodeGroup, final String language )
    {
        return new DefectCodeGroupTextByKeyFluentHelper(
            servicePath,
            "A_DefectCodeGroupText",
            defectCodeGroup,
            language);
    }

    @Override
    @Nonnull
    public DefectCodeTextFluentHelper getAllDefectCodeText()
    {
        return new DefectCodeTextFluentHelper(servicePath, "A_DefectCodeText");
    }

    @Override
    @Nonnull
    public
        DefectCodeTextByKeyFluentHelper
        getDefectCodeTextByKey( final String defectCodeGroup, final String defectCode, final String language )
    {
        return new DefectCodeTextByKeyFluentHelper(
            servicePath,
            "A_DefectCodeText",
            defectCodeGroup,
            defectCode,
            language);
    }

}
