/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.Defect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.DefectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.defectprocessing.batch.DefaultDefectProcessingServiceBatch;

/**
 * <p>
 *
 * A defect is a deviation due to which a quality requirement cannot be fulfilled.
 *
 * This service enables you to record or process defects of different defect categories. Depending on the defect
 * category different properties are mandatory for creating the defect. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1f/88e2e4ccfd4f50a6646284a6f51bc6/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEFECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEFECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Notification and Defect Processing Integration(SAP_COM_0153)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Defect</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/DEFECT_0001"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDefectProcessingService" )
@Deprecated
public class DefaultDefectProcessingService implements DefectProcessingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DefectProcessingService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDefectProcessingService()
    {
        servicePath = DefectProcessingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDefectProcessingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDefectProcessingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDefectProcessingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDefectProcessingServiceBatch batch()
    {
        return new DefaultDefectProcessingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DefectFluentHelper getAllDefect()
    {
        return new DefectFluentHelper(servicePath, "A_Defect");
    }

    @Override
    @Nonnull
    public DefectByKeyFluentHelper getDefectByKey( final String defectInternalID )
    {
        return new DefectByKeyFluentHelper(servicePath, "A_Defect", defectInternalID);
    }

    @Override
    @Nonnull
    public DefectCreateFluentHelper createDefect( @Nonnull final Defect defect )
    {
        return new DefectCreateFluentHelper(servicePath, defect, "A_Defect");
    }

    @Override
    @Nonnull
    public DefectUpdateFluentHelper updateDefect( @Nonnull final Defect defect )
    {
        return new DefectUpdateFluentHelper(servicePath, defect, "A_Defect");
    }

    @Override
    @Nonnull
    public DefectDeleteFluentHelper deleteDefect( @Nonnull final Defect defect )
    {
        return new DefectDeleteFluentHelper(servicePath, defect, "A_Defect");
    }

}
