/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CheckCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.CreditBlockedDeliveryDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.RejectCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.ReleaseCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.SalesDocumentRjcnReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.deliverydocumentwithcreditblocks.batch.DefaultDeliveryDocumentWithCreditBlocksServiceBatch;

/**
 * <p>
 * The service contains entities for credit blocked delivery document and reject reason. Once the delivery document has
 * been checked, released, or rejected, a success message containing the document number is sent in the response. Once
 * the credit blocked delivery document has been retrieved, the data is sent in the response. If there are any issues
 * when reading, checking, releasing, or rejecting the credit blocked delivery document, the system displays error
 * messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a5/8d43a7756649dbb7bb970be3bda38d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEL_DOC_WITH_CREDIT_BLOCK?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEL_DOC_WITH_CREDIT_BLOCK</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Credit Management Integration(SAP_COM_0325)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD6'>Basic Credit Management(BD6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Outbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDeliveryDocumentWithCreditBlocksService" )
@Deprecated
public class DefaultDeliveryDocumentWithCreditBlocksService implements DeliveryDocumentWithCreditBlocksService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DeliveryDocumentWithCreditBlocksService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultDeliveryDocumentWithCreditBlocksService()
    {
        servicePath = DeliveryDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDeliveryDocumentWithCreditBlocksService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDeliveryDocumentWithCreditBlocksService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDeliveryDocumentWithCreditBlocksService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDeliveryDocumentWithCreditBlocksServiceBatch batch()
    {
        return new DefaultDeliveryDocumentWithCreditBlocksServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CreditBlockedDeliveryDocFluentHelper getAllCreditBlockedDeliveryDoc()
    {
        return new CreditBlockedDeliveryDocFluentHelper(servicePath, "A_CreditBlockedDeliveryDoc");
    }

    @Override
    @Nonnull
    public CreditBlockedDeliveryDocByKeyFluentHelper getCreditBlockedDeliveryDocByKey( final String deliveryDocument )
    {
        return new CreditBlockedDeliveryDocByKeyFluentHelper(
            servicePath,
            "A_CreditBlockedDeliveryDoc",
            deliveryDocument);
    }

    @Override
    @Nonnull
    public SalesDocumentRjcnReasonFluentHelper getAllSalesDocumentRjcnReason()
    {
        return new SalesDocumentRjcnReasonFluentHelper(servicePath, "A_SalesDocumentRjcnReason");
    }

    @Override
    @Nonnull
    public SalesDocumentRjcnReasonByKeyFluentHelper getSalesDocumentRjcnReasonByKey(
        final String salesDocumentRjcnReason )
    {
        return new SalesDocumentRjcnReasonByKeyFluentHelper(
            servicePath,
            "A_SalesDocumentRjcnReason",
            salesDocumentRjcnReason);
    }

    @Override
    @Nonnull
    public
        CheckCreditBlockFluentHelper
        checkCreditBlock( @Nonnull final String deliveryDocument, @Nonnull final String sDDocumentCategory )
    {
        return new CheckCreditBlockFluentHelper(servicePath, deliveryDocument, sDDocumentCategory);
    }

    @Override
    @Nonnull
    public RejectCreditBlockFluentHelper rejectCreditBlock(
        @Nonnull final String deliveryDocument,
        @Nonnull final String salesDocumentRjcnReason,
        @Nonnull final String sDDocumentCategory )
    {
        return new RejectCreditBlockFluentHelper(
            servicePath,
            deliveryDocument,
            salesDocumentRjcnReason,
            sDDocumentCategory);
    }

    @Override
    @Nonnull
    public
        ReleaseCreditBlockFluentHelper
        releaseCreditBlock( @Nonnull final String sDDocumentCategory, @Nonnull final String deliveryDocument )
    {
        return new ReleaseCreditBlockFluentHelper(servicePath, sDDocumentCategory, deliveryDocument);
    }

}
