/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.batch.DefaultDistributionChannelServiceBatch;

/**
 * <p>
 * The service contains the distribution channel and distribution channel text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b2/40ab069b9542209ffdc3d3585adc9f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DISTRIBUTIONCHANNEL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DISTRIBUTIONCHANNEL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Distribution Channel</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDistributionChannelService" )
@Deprecated
public class DefaultDistributionChannelService implements DistributionChannelService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DistributionChannelService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDistributionChannelService()
    {
        servicePath = DistributionChannelService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDistributionChannelService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDistributionChannelService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDistributionChannelService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDistributionChannelServiceBatch batch()
    {
        return new DefaultDistributionChannelServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DistributionChannelFluentHelper getAllDistributionChannel()
    {
        return new DistributionChannelFluentHelper(servicePath, "A_DistributionChannel");
    }

    @Override
    @Nonnull
    public DistributionChannelByKeyFluentHelper getDistributionChannelByKey( final String distributionChannel )
    {
        return new DistributionChannelByKeyFluentHelper(servicePath, "A_DistributionChannel", distributionChannel);
    }

    @Override
    @Nonnull
    public DistributionChannelTextFluentHelper getAllDistributionChannelText()
    {
        return new DistributionChannelTextFluentHelper(servicePath, "A_DistributionChannelText");
    }

    @Override
    @Nonnull
    public
        DistributionChannelTextByKeyFluentHelper
        getDistributionChannelTextByKey( final String distributionChannel, final String language )
    {
        return new DistributionChannelTextByKeyFluentHelper(
            servicePath,
            "A_DistributionChannelText",
            distributionChannel,
            language);
    }

}
