/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDescUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.batch.DefaultDocumentManagementServiceBatch;

/**
 * <p>
 *
 * The service contains header data of the document info record (DIR), description, object link information for BOM,
 * product, and change record, classification details for class and characteristics, and value help for document status
 * as nodes.
 *
 * All the information can be sent as part of the request payload, which is then used to maintain the DIR, including
 * appropriate checks for restricted values and authorizations. The data associated to the document info record is sent
 * in the response. If there are any issues in the request such as wrong values or insufficient information, the system
 * displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e5/e3aa41c5924883a543c7d751693ab0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DMS_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DMS_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Document Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultDocumentManagementService" )
@Deprecated
public class DefaultDocumentManagementService implements DocumentManagementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link DocumentManagementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultDocumentManagementService()
    {
        servicePath = DocumentManagementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultDocumentManagementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDocumentManagementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultDocumentManagementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultDocumentManagementServiceBatch batch()
    {
        return new DefaultDocumentManagementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkBOMFluentHelper getAllDocInfoRecdObjLinkBOM()
    {
        return new DocInfoRecdObjLinkBOMFluentHelper(servicePath, "A_DocInfoRecdObjLinkBOM");
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkBOMByKeyFluentHelper getDocInfoRecdObjLinkBOMByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter )
    {
        return new DocInfoRecdObjLinkBOMByKeyFluentHelper(
            servicePath,
            "A_DocInfoRecdObjLinkBOM",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            linkedSAPObject,
            linkedSAPObjectKey,
            docObjectLinkCounter);
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkChgRecdFluentHelper getAllDocInfoRecdObjLinkChgRecd()
    {
        return new DocInfoRecdObjLinkChgRecdFluentHelper(servicePath, "A_DocInfoRecdObjLinkChgRecd");
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkChgRecdByKeyFluentHelper getDocInfoRecdObjLinkChgRecdByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter )
    {
        return new DocInfoRecdObjLinkChgRecdByKeyFluentHelper(
            servicePath,
            "A_DocInfoRecdObjLinkChgRecd",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            linkedSAPObject,
            linkedSAPObjectKey,
            docObjectLinkCounter);
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkProductFluentHelper getAllDocInfoRecdObjLinkProduct()
    {
        return new DocInfoRecdObjLinkProductFluentHelper(servicePath, "A_DocInfoRecdObjLinkProduct");
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkProductByKeyFluentHelper getDocInfoRecdObjLinkProductByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String linkedSAPObject,
        final String linkedSAPObjectKey,
        final String docObjectLinkCounter )
    {
        return new DocInfoRecdObjLinkProductByKeyFluentHelper(
            servicePath,
            "A_DocInfoRecdObjLinkProduct",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            linkedSAPObject,
            linkedSAPObjectKey,
            docObjectLinkCounter);
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkProductCreateFluentHelper createDocInfoRecdObjLinkProduct(
        @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct )
    {
        return new DocInfoRecdObjLinkProductCreateFluentHelper(
            servicePath,
            docInfoRecdObjLinkProduct,
            "A_DocInfoRecdObjLinkProduct");
    }

    @Override
    @Nonnull
    public DocInfoRecdObjLinkProductDeleteFluentHelper deleteDocInfoRecdObjLinkProduct(
        @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct )
    {
        return new DocInfoRecdObjLinkProductDeleteFluentHelper(
            servicePath,
            docInfoRecdObjLinkProduct,
            "A_DocInfoRecdObjLinkProduct");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordFluentHelper getAllDocumentInfoRecord()
    {
        return new DocumentInfoRecordFluentHelper(servicePath, "A_DocumentInfoRecord");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordByKeyFluentHelper getDocumentInfoRecordByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocPart )
    {
        return new DocumentInfoRecordByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecord",
            documentInfoRecordDocType,
            documentInfoRecordDocVersion,
            documentInfoRecordDocNumber,
            documentInfoRecordDocPart);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordCreateFluentHelper createDocumentInfoRecord(
        @Nonnull final DocumentInfoRecord documentInfoRecord )
    {
        return new DocumentInfoRecordCreateFluentHelper(servicePath, documentInfoRecord, "A_DocumentInfoRecord");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordUpdateFluentHelper updateDocumentInfoRecord(
        @Nonnull final DocumentInfoRecord documentInfoRecord )
    {
        return new DocumentInfoRecordUpdateFluentHelper(servicePath, documentInfoRecord, "A_DocumentInfoRecord");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordCharcFluentHelper getAllDocumentInfoRecordCharc()
    {
        return new DocumentInfoRecordCharcFluentHelper(servicePath, "A_DocumentInfoRecordCharc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordCharcByKeyFluentHelper getDocumentInfoRecordCharcByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String charcInternalID,
        final String classType )
    {
        return new DocumentInfoRecordCharcByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordCharc",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            charcInternalID,
            classType);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordCharcValueFluentHelper getAllDocumentInfoRecordCharcValue()
    {
        return new DocumentInfoRecordCharcValueFluentHelper(servicePath, "A_DocumentInfoRecordCharcValue");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordCharcValueByKeyFluentHelper getDocumentInfoRecordCharcValueByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new DocumentInfoRecordCharcValueByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordCharcValue",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordClassFluentHelper getAllDocumentInfoRecordClass()
    {
        return new DocumentInfoRecordClassFluentHelper(servicePath, "A_DocumentInfoRecordClass");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordClassByKeyFluentHelper getDocumentInfoRecordClassByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classInternalID )
    {
        return new DocumentInfoRecordClassByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordClass",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            classInternalID);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordClassCharcFluentHelper getAllDocumentInfoRecordClassCharc()
    {
        return new DocumentInfoRecordClassCharcFluentHelper(servicePath, "A_DocumentInfoRecordClassCharc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordClassCharcByKeyFluentHelper getDocumentInfoRecordClassCharcByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String classInternalID,
        final String charcInternalID )
    {
        return new DocumentInfoRecordClassCharcByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordClassCharc",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDescFluentHelper getAllDocumentInfoRecordDesc()
    {
        return new DocumentInfoRecordDescFluentHelper(servicePath, "A_DocumentInfoRecordDesc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDescByKeyFluentHelper getDocumentInfoRecordDescByKey(
        final String documentInfoRecordDocType,
        final String documentInfoRecordDocNumber,
        final String documentInfoRecordDocVersion,
        final String documentInfoRecordDocPart,
        final String language )
    {
        return new DocumentInfoRecordDescByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordDesc",
            documentInfoRecordDocType,
            documentInfoRecordDocNumber,
            documentInfoRecordDocVersion,
            documentInfoRecordDocPart,
            language);
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDescCreateFluentHelper createDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return new DocumentInfoRecordDescCreateFluentHelper(
            servicePath,
            documentInfoRecordDesc,
            "A_DocumentInfoRecordDesc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDescUpdateFluentHelper updateDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return new DocumentInfoRecordDescUpdateFluentHelper(
            servicePath,
            documentInfoRecordDesc,
            "A_DocumentInfoRecordDesc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDescDeleteFluentHelper deleteDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return new DocumentInfoRecordDescDeleteFluentHelper(
            servicePath,
            documentInfoRecordDesc,
            "A_DocumentInfoRecordDesc");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDocStsVHFluentHelper getAllDocumentInfoRecordDocStsVH()
    {
        return new DocumentInfoRecordDocStsVHFluentHelper(servicePath, "A_DocumentInfoRecordDocStsVH");
    }

    @Override
    @Nonnull
    public DocumentInfoRecordDocStsVHByKeyFluentHelper getDocumentInfoRecordDocStsVHByKey(
        final String documentInfoRecordDocType,
        final String language,
        final String externalDocumentStatus )
    {
        return new DocumentInfoRecordDocStsVHByKeyFluentHelper(
            servicePath,
            "A_DocumentInfoRecordDocStsVH",
            documentInfoRecordDocType,
            language,
            externalDocumentStatus);
    }

}
