/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.AttachmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSPersonValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.IncidentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.LocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.PersonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.batch.DefaultEHSIncidentCreateServiceBatch;

/**
 * <p>
 *
 * This service contains the basic information about an incident as the main entity, and persons involved, location, and
 * attachments as dependent entities. For create operations, the information is sent in the request as a payload, except
 * for attachment-related data. You can add attachments to the newly created incident in separate calls. Once the
 * incident has been created, the incident data and global identification are sent in the response. For read operations,
 * filter information can be sent according to the OData protocol. While creating an incident or retrieving incident
 * data, the system performs checks for restricted values and authorization. If there are any issues, the system
 * displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/40/c541a704b747ae83b0ce8f0ed322a9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_EHS_REPORT_INCIDENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_EHS_REPORT_INCIDENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Environment, Health and Safety - Incident Reporting Integration(SAP_COM_0369)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3FP'>Lean Incident Management Reporting(3FP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PFP'>Lean Incident Management Reporting(PFP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>EHS Incident business object</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultEHSIncidentCreateService" )
@Deprecated
public class DefaultEHSIncidentCreateService implements EHSIncidentCreateService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link EHSIncidentCreateService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultEHSIncidentCreateService()
    {
        servicePath = EHSIncidentCreateService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultEHSIncidentCreateService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEHSIncidentCreateService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultEHSIncidentCreateService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultEHSIncidentCreateServiceBatch batch()
    {
        return new DefaultEHSIncidentCreateServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CurEHSLocationInclRootHierFluentHelper getAllCurEHSLocationInclRootHier()
    {
        return new CurEHSLocationInclRootHierFluentHelper(servicePath, "C_CurEHSLocationInclRootHier");
    }

    @Override
    @Nonnull
    public CurEHSLocationInclRootHierByKeyFluentHelper getCurEHSLocationInclRootHierByKey( final UUID eHSLocationUUID )
    {
        return new CurEHSLocationInclRootHierByKeyFluentHelper(
            servicePath,
            "C_CurEHSLocationInclRootHier",
            eHSLocationUUID);
    }

    @Override
    @Nonnull
    public EHSLocationValueHelpFluentHelper getAllEHSLocationValueHelp()
    {
        return new EHSLocationValueHelpFluentHelper(servicePath, "C_EHSLocationValueHelp");
    }

    @Override
    @Nonnull
    public EHSLocationValueHelpByKeyFluentHelper getEHSLocationValueHelpByKey( final UUID eHSLocationUUID )
    {
        return new EHSLocationValueHelpByKeyFluentHelper(servicePath, "C_EHSLocationValueHelp", eHSLocationUUID);
    }

    @Override
    @Nonnull
    public EHSLocClassifierVHFluentHelper getAllEHSLocClassifierVH()
    {
        return new EHSLocClassifierVHFluentHelper(servicePath, "C_EHSLocClassifierVH");
    }

    @Override
    @Nonnull
    public EHSLocClassifierVHByKeyFluentHelper getEHSLocClassifierVHByKey( final UUID eHSClassifierUUID )
    {
        return new EHSLocClassifierVHByKeyFluentHelper(servicePath, "C_EHSLocClassifierVH", eHSClassifierUUID);
    }

    @Override
    @Nonnull
    public EHSPersonValueHelpFluentHelper getAllEHSPersonValueHelp()
    {
        return new EHSPersonValueHelpFluentHelper(servicePath, "C_EHSPersonValueHelp");
    }

    @Override
    @Nonnull
    public EHSPersonValueHelpByKeyFluentHelper getEHSPersonValueHelpByKey( final String businessPartner )
    {
        return new EHSPersonValueHelpByKeyFluentHelper(servicePath, "C_EHSPersonValueHelp", businessPartner);
    }

    @Override
    @Nonnull
    public EHSLocationTypeFluentHelper getAllEHSLocationType()
    {
        return new EHSLocationTypeFluentHelper(servicePath, "I_EHSLocationType");
    }

    @Override
    @Nonnull
    public EHSLocationTypeByKeyFluentHelper getEHSLocationTypeByKey( final String eHSLocationType )
    {
        return new EHSLocationTypeByKeyFluentHelper(servicePath, "I_EHSLocationType", eHSLocationType);
    }

    @Override
    @Nonnull
    public EHSLocClassifierTextFluentHelper getAllEHSLocClassifierText()
    {
        return new EHSLocClassifierTextFluentHelper(servicePath, "I_EHSLocClassifierText");
    }

    @Override
    @Nonnull
    public EHSLocClassifierTextByKeyFluentHelper getEHSLocClassifierTextByKey(
        final UUID eHSLocationUUID,
        final UUID eHSLocClassifierUUID,
        final UUID eHSLocClassifierRefUUID )
    {
        return new EHSLocClassifierTextByKeyFluentHelper(
            servicePath,
            "I_EHSLocClassifierText",
            eHSLocationUUID,
            eHSLocClassifierUUID,
            eHSLocClassifierRefUUID);
    }

    @Override
    @Nonnull
    public AttachmentCreateFluentHelper createAttachment( @Nonnull final Attachment attachment )
    {
        return new AttachmentCreateFluentHelper(servicePath, attachment, "A_Attachment");
    }

    @Override
    @Nonnull
    public IncidentFluentHelper getAllIncident()
    {
        return new IncidentFluentHelper(servicePath, "A_Incident");
    }

    @Override
    @Nonnull
    public IncidentByKeyFluentHelper getIncidentByKey( final UUID incidentUUID )
    {
        return new IncidentByKeyFluentHelper(servicePath, "A_Incident", incidentUUID);
    }

    @Override
    @Nonnull
    public IncidentCreateFluentHelper createIncident( @Nonnull final Incident incident )
    {
        return new IncidentCreateFluentHelper(servicePath, incident, "A_Incident");
    }

    @Override
    @Nonnull
    public LocationFluentHelper getAllLocation()
    {
        return new LocationFluentHelper(servicePath, "A_Location");
    }

    @Override
    @Nonnull
    public LocationByKeyFluentHelper getLocationByKey( final UUID locationUUID )
    {
        return new LocationByKeyFluentHelper(servicePath, "A_Location", locationUUID);
    }

    @Override
    @Nonnull
    public PersonCreateFluentHelper createPerson( @Nonnull final Person person )
    {
        return new PersonCreateFluentHelper(servicePath, person, "A_Person");
    }

}
